/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.cpp;

import emitters.NsVersionAliases;
import emitters.Versions;
import emitters.bindings.APIAudit;
import emitters.bindings.cpp.CppEmitter;
import emitters.core.SyntaxException;
import emitters.model.DataObject;
import emitters.model.DataProperty;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class CppInterfaceEmitter
extends CppEmitter {
    private final boolean _emitInlineApi;
    private final String _classApiDecl;
    private final String _memberApiDecl;
    private final String _inlineApiDecl;
    private Set<String> _aggregateHeaderSet = new TreeSet<String>();
    private final APIAudit _apiAuditingType = APIAudit.initAPIAuditing();
    private static final String INTERNAL_API_WARNING = "REFERENCING_INTERNAL_API";
    private static final String DEPRECATED_API_WARNING = "REFERENCING_DEPRECATED_API";

    public CppInterfaceEmitter(Map<String, String> options, String directory) {
        super(options);
        this.setHeadersDir(directory);
        this._emitInlineApi = CppInterfaceEmitter.parseOptionalBoolean(options.get("emit.inline.api"), false);
        if (this._emitInlineApi) {
            this._classApiDecl = this._apiName + "_CLASS ";
            this._memberApiDecl = this._apiName + "_MEMBER ";
            this._inlineApiDecl = this._apiName + "_INLINE ";
        } else {
            this._classApiDecl = this._apiDecl;
            this._memberApiDecl = "";
            this._inlineApiDecl = "";
        }
        String aggregateHeaders = options.get("aggregate.hpp");
        if (aggregateHeaders != null) {
            for (String header : aggregateHeaders.split(",")) {
                this._aggregateHeaderSet.add(header);
            }
        }
        this.addHeader("vmomi/client.h");
        this.addHeader("vmomi/Validator.h");
        if (this._apiAuditingType != APIAudit.NOTSET) {
            this.addHeader("vmomi/ApiAudit.h");
        }
        if (this._apiHeaderFile != null) {
            this.addHeader(this._apiHeaderFile);
        }
    }

    public String getAPIAuditingMsg(boolean isInternal, boolean isDeprecated) {
        if (this._apiAuditingType == APIAudit.NOTSET) {
            return null;
        }
        if (this._apiAuditingType == APIAudit.INTERNAL) {
            if (isInternal) {
                return INTERNAL_API_WARNING;
            }
        } else if (this._apiAuditingType == APIAudit.DEPRECATED) {
            if (isDeprecated) {
                return DEPRECATED_API_WARNING;
            }
        } else {
            throw new RuntimeException("Unexpected API audit type: " + (Object)((Object)this._apiAuditingType));
        }
        return null;
    }

    public String getAPIAuditingMsg(VmodlObject obj) {
        return this.getAPIAuditingMsg(obj.isInternal(), obj.isDeprecated());
    }

    public String getAPIAuditingMsg(Method method) {
        return this.getAPIAuditingMsg(method.isInternal(), method.isDeprecated());
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        for (VmodlObject obj : objects) {
            if (CppInterfaceEmitter.isBuiltin(obj)) continue;
            String string = this.getHeaderDeclFile(obj);
            String objNs = obj.getNamespace();
            this.beginObjHeader(obj, string);
            this.setNamespace(objNs);
            this.emitOutOfDeclInlines(obj);
            this.setNamespace("");
            this.endObjHeader(obj);
            this.beginObjDecl(obj, string);
            this.setNamespace(objNs);
            this.emitObject(obj);
            this.setNamespace("");
            this.emitTypeDecl(obj);
            this.endFile();
        }
        if (!this._aggregateHeaderSet.isEmpty()) {
            String path;
            TreeMap<String, Set<String>> headerMap = new TreeMap<String, Set<String>>();
            for (String string : this._aggregateHeaderSet) {
                int index = string.lastIndexOf(46);
                path = string.substring(0, index);
                headerMap.put(path, new TreeSet());
            }
            for (String string : this._aggregateHeaderSet) {
                int index = string.lastIndexOf(47);
                path = string.substring(0, index);
                this.registerInHeaderMap(string, path, headerMap);
            }
            for (VmodlObject vmodlObject : objects) {
                if (CppInterfaceEmitter.isBuiltin(vmodlObject)) continue;
                String headerPath = this._headersDir + vmodlObject.getNamespace().replace('.', '/');
                String header = headerPath + "/" + vmodlObject.getClassName() + ".h";
                this.registerInHeaderMap(header, headerPath, headerMap);
            }
            for (Map.Entry entry : headerMap.entrySet()) {
                this.beginHeader((String)entry.getKey() + ".h");
                this.emitIncludes((Iterable)entry.getValue());
                this.endFile();
            }
        }
        this.emitApiHeader();
        this.emitVersionsHeader();
    }

    private void registerInHeaderMap(String header, String path, Map<String, Set<String>> map) {
        Set<String> headerSet = map.get(path);
        if (headerSet != null) {
            headerSet.add(header);
        }
    }

    private void ThrowCyclicDependency(VmodlObject obj, VmodlObject[] objects) {
        StringBuilder sb = new StringBuilder("Cyclic dependency between nested types: ");
        String sep = "";
        for (VmodlObject nestedObj : objects) {
            sb.append(sep);
            sb.append(nestedObj.getName());
            sep = ", ";
        }
        throw SyntaxException.at(obj, sb.toString(), new Object[0]);
    }

    private void sortByDependency(VmodlObject obj, VmodlObject[] objects) {
        block0: for (int frontIdx = 0; frontIdx < objects.length - 1; ++frontIdx) {
            block1: for (int untestedIdx = objects.length - 1; untestedIdx >= frontIdx; --untestedIdx) {
                for (int i = frontIdx + 1; i < objects.length; ++i) {
                    if (!objects[frontIdx].dependsOn(objects[i])) {
                        continue;
                    }
                    VmodlObject temp = objects[frontIdx];
                    objects[frontIdx] = objects[untestedIdx];
                    objects[untestedIdx] = temp;
                    continue block1;
                }
                continue block0;
            }
            this.ThrowCyclicDependency(obj, Arrays.copyOfRange(objects, frontIdx, objects.length));
        }
    }

    private void emitNestedObjects(VmodlObject obj) {
        VmodlObject[] nestedObjects = new VmodlObject[obj.getNestedList().size()];
        nestedObjects = obj.getNestedList().toArray(nestedObjects);
        this.sortByDependency(obj, nestedObjects);
        for (VmodlObject nestedObj : nestedObjects) {
            if (nestedObj.getKind() == VmodlObject.Kind.Enum) continue;
            this.emitLine("class " + nestedObj.getClassName() + ";");
        }
        for (VmodlObject nestedObj : nestedObjects) {
            this.emitGap();
            this.emitObject(nestedObj);
        }
    }

    private void emitTypeDecl(VmodlObject obj) {
        this.emitLine(CppInterfaceEmitter.formatDecl("extern const " + this._apiDecl + "Vmomi::TypeInfo", CppInterfaceEmitter.formatTypeInfo(obj)), ";");
        if (obj.getKind() == VmodlObject.Kind.ManagedObject) {
            this.emitLine(CppInterfaceEmitter.formatDecl("extern " + this._apiDecl + "Vmomi::ManagedMethod *", CppInterfaceEmitter.formatMethodObjects((ManagedObject)obj)), "[];");
        }
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitTypeDecl(nestedObj);
        }
    }

    private void emitObject(VmodlObject obj) {
        switch (obj.getKind()) {
            case DataObject: {
                this.emitDataObject((DataObject)obj);
                break;
            }
            case Enum: {
                this.emitEnum((Enum)obj);
                break;
            }
            case ManagedObject: {
                this.emitManagedObject((ManagedObject)obj);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected object type");
            }
        }
    }

    private void emitManagedObject(ManagedObject obj) {
        String methodDecl;
        this.emitClassHeader(obj);
        this.emitLine();
        this.emitLine("typedef " + obj.getClassName() + " MoType;");
        this.emitLine();
        this.emitNestedObjects(obj);
        this.emitTypeMethod(obj);
        this.emitLine();
        String apiAuditMsgMO = this.getAPIAuditingMsg(obj);
        for (Property property : obj.getPropertyList()) {
            VmodlDecl decl = property.getDecl();
            String resultParamComment = CppInterfaceEmitter.getInParamString(decl);
            if (decl.isManaged() && decl.getObject() != null) {
                resultParamComment = "Reference to " + decl.getObject().getClassName() + " object";
                this.emitLine("// Property Type: " + decl.getObject().getClassName());
            }
            this.emitComment(property.getComment(), "@param result [out] " + resultParamComment);
            methodDecl = "virtual " + this.formatMethodDecl(property.getAccessor());
            this.emitMethodDecl(methodDecl, apiAuditMsgMO);
            this.emitLine(" = 0;");
            if (!property.isReadonly()) {
                this.emitComment(property.getComment());
                methodDecl = "virtual " + this.formatMethodDecl(property.getMutator());
                this.emitMethodDecl(methodDecl, apiAuditMsgMO);
                this.emitLine(" = 0;");
            }
            this.emitLine();
        }
        for (Method method : obj.getMethodList()) {
            String resultParamComment = null;
            String apiAuditMsg = null;
            apiAuditMsg = apiAuditMsgMO != null ? apiAuditMsgMO : this.getAPIAuditingMsg(method);
            if (method.isTask()) {
                resultParamComment = "@param result [out] Reference to Vim::Task object";
            }
            this.emitComment(method.getComment(), resultParamComment);
            methodDecl = "virtual " + this.formatMethodDecl(method);
            this.emitMethodDecl(methodDecl, apiAuditMsg);
            this.emitLine(" = 0;");
        }
        for (Method method : obj.getMethodList()) {
            String methodName = method.getName();
            this.emitLine("static const char METHOD_" + methodName.toUpperCase() + "[];");
        }
        this.emitClassFooter(obj);
        this.emitManagedObjectStub(obj);
    }

    private void emitManagedObjectStub(ManagedObject obj) {
        ManagedObject base = (ManagedObject)obj.getBaseObject();
        String className = CppInterfaceEmitter.getStubName(obj);
        String baseImpl = CppInterfaceEmitter.isBuiltin(base) ? "Vmomi::StubImpl" : CppInterfaceEmitter.getQualifiedStubName(base);
        String apiAuditMsgMO = this.getAPIAuditingMsg(obj);
        this.emitLine("class " + this._apiDecl + CppInterfaceEmitter.getStubName(obj) + " : virtual public " + obj.getClassName() + ", public " + baseImpl + " {");
        this.emitLine("public:");
        this.indent();
        this.emitMethodDecl(className + "(Vmomi::MoRef *moref, Vmomi::StubAdapter *adapter, Vmomi::RequestContext *context)", apiAuditMsgMO);
        this.emitLine(";");
        this.emitMethodDecl("~" + className + "()", apiAuditMsgMO);
        this.emitLine(";");
        for (Property property : obj.getPropertyListWithOverrides()) {
            this.emitMethodDecl(this.formatMethodDecl(property.getAccessor()), apiAuditMsgMO);
            this.emitLine(";");
            if (!this._emitAsyncStubMethods) continue;
            this.emitMethodDecl(this.formatAsyncMethodDecl(property.getAccessor()), apiAuditMsgMO);
            this.emitLine(";");
        }
        this.emitLine();
        for (Method method : obj.getMethodList()) {
            String apiAuditMsg = apiAuditMsgMO != null ? apiAuditMsgMO : this.getAPIAuditingMsg(method);
            this.emitMethodDecl(this.formatMethodDecl(method), apiAuditMsg);
            this.emitLine(";");
            if (!this._emitAsyncStubMethods) continue;
            this.emitMethodDecl(this.formatAsyncMethodDecl(method), apiAuditMsg);
            this.emitLine(";");
        }
        this.unindent();
        this.emitLine("};");
    }

    private void emitDataObject(DataObject obj) {
        String className = obj.getClassName();
        String apiAuditMsg = this.getAPIAuditingMsg(obj);
        this.emitClassHeader(obj);
        this.emitNestedObjects(obj);
        if (obj.isFault()) {
            this.emitException(obj);
            this.unindent();
            this.emitLine("protected:");
            this.indent();
            this.emitLine(this._memberApiDecl + "virtual NORETURN void ThrowInternal();");
            this.unindent();
            this.emitLine("public:");
            this.indent();
            this.emitLine(this._inlineApiDecl + "virtual Exception *CreateException() { return new " + className + "::Exception(this); }");
        }
        this.emitMethodDecl(this._memberApiDecl + className + "()", apiAuditMsg);
        this.emitLine(";");
        List<String> declList = CppInterfaceEmitter.getPropDeclList(obj);
        if (declList.size() > 0) {
            String param;
            String protectedType;
            String type;
            List<Property> baseProps = CppInterfaceEmitter.getRecursiveConstructorProperties(obj.getBaseObject());
            List<Property> props = CppInterfaceEmitter.getConstructorProperties(obj);
            String baseClassName = CppInterfaceEmitter.getQualifiedClassName(obj.getBaseObject());
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<String> args = new ArrayList<String>();
            ArrayList<String> baseParams = new ArrayList<String>();
            ArrayList<String> inits = new ArrayList<String>();
            int i = 0;
            for (Property prop : baseProps) {
                type = "T" + i;
                protectedType = "Vmacore::ForceConstLvalue<" + type + ">";
                param = CppInterfaceEmitter.getFormalName(prop);
                types.add("class " + type);
                args.add(type + "&& " + param);
                baseParams.add("std::forward<" + protectedType + ">(" + param + ")");
                ++i;
            }
            inits.add(baseClassName + "(" + CppInterfaceEmitter.join(baseParams) + ")");
            for (Property prop : props) {
                type = "T" + i;
                protectedType = "Vmacore::ForceConstLvalue<" + type + ">";
                param = CppInterfaceEmitter.getFormalName(prop);
                types.add("class " + type);
                args.add(type + "&& " + param);
                inits.add(CppInterfaceEmitter.getMemberName(prop) + "(std::forward<" + protectedType + ">(" + param + "))");
                ++i;
            }
            this.emitLine("template<" + CppInterfaceEmitter.join(types) + ">");
            this.emitFunctionDecl(this._inlineApiDecl + className + "(" + CppInterfaceEmitter.join(args) + ") :", apiAuditMsg);
            this.emitLine();
            this.indent();
            this.emitLine(CppInterfaceEmitter.join(inits));
            this.unindent();
            this.emitLine("{ }");
        }
        this.emitMethodDecl(this._memberApiDecl + "~" + className + "()", apiAuditMsg);
        this.emitLine(";");
        this.emitGap();
        this.unindent();
        this.emitLine("protected:");
        this.indent();
        this.emitMethodDecl(this._memberApiDecl + className + "(const " + className + "& rhs)", apiAuditMsg);
        this.emitLine(";");
        this.emitGap();
        this.unindent();
        this.emitLine("public: // interface Any");
        this.indent();
        this.emitTypeMethod(obj);
        this.emitCloneMethod(obj);
        if (this._emitDiffMethod) {
            this.emitIsEqualMethod(obj);
            this.emitDiffPropertiesMethod(obj);
        }
        this.emitGap();
        this.unindent();
        this.emitLine("public:");
        this.indent();
        for (Property p : obj.getPropertyList()) {
            DataProperty property = (DataProperty)p;
            String cppComment = property.getComment();
            if (cppComment == null) {
                cppComment = new String();
            }
            VmodlDecl decl = property.getDecl();
            String returnTypeName = CppInterfaceEmitter.getPropertyReturnString(decl);
            String paramTypeName = CppInterfaceEmitter.getInParamString(decl);
            String memberName = CppInterfaceEmitter.getMemberName(property);
            String returnComment = returnTypeName;
            if (decl.isManaged() && decl.getObject() != null) {
                this.emitLine("// Property Type: " + decl.getObject().getClassName());
                returnComment = "Reference to " + decl.getObject().getClassName() + " object";
            }
            this.emitComment(property.getComment(), "@returns " + returnComment);
            String getterFun = CppInterfaceEmitter.formatDecl(returnTypeName, property.getAccessor().getName()) + "()";
            if (!decl.isArray()) {
                if (decl.isValue() || decl.isManaged()) {
                    this.emitMethodDecl(this._inlineApiDecl + getterFun + " const", apiAuditMsg);
                    this.emitLine(" { return " + memberName + "; }");
                } else {
                    this.emitMethodDecl(this._inlineApiDecl + getterFun, apiAuditMsg);
                    this.emitLine(" { return " + memberName + "; }");
                    this.emitMethodDecl(this._inlineApiDecl + "const " + getterFun + " const", apiAuditMsg);
                    this.emitLine(" { return " + memberName + "; }");
                }
                if (decl.isValue() && decl.isOptional()) {
                    this.emitMethodDecl(this._inlineApiDecl + CppInterfaceEmitter.formatDecl("bool", property.getAccessor().getName()) + "(" + CppInterfaceEmitter.getBaseTypeString(decl) + "& val) const", apiAuditMsg);
                    this.emitLine(" {");
                    this.indent();
                    this.emitLine("if (!" + memberName + ".HasValue()) { return false; }");
                    this.emitLine("val = " + memberName + ".GetValue();");
                    this.emitLine("return true;");
                    this.unindent();
                    this.emitLine("}");
                }
            } else {
                this.emitMethodDecl(this._memberApiDecl + getterFun, apiAuditMsg);
                this.emitLine(";");
                this.emitMethodDecl(this._inlineApiDecl + "const " + getterFun + " const ", apiAuditMsg);
                this.emitLine("{ return const_cast<" + className + "*>(this)->" + property.getAccessor().getName() + "(); }");
                String isSetFun = CppInterfaceEmitter.formatDecl("bool", property.getIsSet().getName()) + "()";
                this.emitMethodDecl(this._inlineApiDecl + isSetFun + " const", apiAuditMsg);
                this.emitLine(";");
            }
            if (decl.isArray()) {
                String fun = CppInterfaceEmitter.formatDecl(CppInterfaceEmitter.getGetPtrPropertyReturnString(decl), property.getGetPtr().getName()) + "() noexcept";
                this.emitMethodDecl(this._inlineApiDecl + fun, apiAuditMsg);
                this.emitLine(" {");
                this.emitLine("\treturn " + memberName + ".Ptr();");
                this.emitLine("}");
                String constFun = CppInterfaceEmitter.formatDecl("const " + CppInterfaceEmitter.getGetPtrPropertyReturnString(decl), property.getGetPtr().getName()) + "() const noexcept";
                this.emitMethodDecl(this._inlineApiDecl + constFun, apiAuditMsg);
                this.emitLine(" {");
                this.emitLine("\treturn " + memberName + ".Ptr();");
                this.emitLine("}");
            }
            String peekerFun = CppInterfaceEmitter.formatDecl(CppInterfaceEmitter.getPeekPropertyReturnString(decl), property.getPeeker().getName()) + "() const";
            if (decl.isSingleValue()) {
                this.emitMethodDecl(this._inlineApiDecl + peekerFun, apiAuditMsg);
                this.emitLine(" {");
                this.indent();
                if (decl.isSingleValue() && !decl.isOptional()) {
                    this.emitLine("return &" + memberName + ";");
                } else {
                    this.emitLine("return " + memberName + ".Peek();");
                }
                this.unindent();
                this.emitLine("}");
            } else {
                this.emitMethodDecl(this._memberApiDecl + peekerFun, apiAuditMsg);
                this.emitLine(";");
            }
            this.emitComment(property.getComment(), "@param val [in] new value");
            String setterFun = CppInterfaceEmitter.formatDecl("void", property.getMutator().getName()) + "(" + CppInterfaceEmitter.formatDecl(paramTypeName, "val") + ")";
            if (!decl.isSingleValue()) {
                this.emitLine("template<class T> inline void");
                this.emitLine(property.getMutator().getName() + "(Ref<T>&& val)");
                this.emitLine("{");
                this.indent();
                this.emitLine(memberName + " = std::move(val);");
                this.emitValidation(memberName, property.getPropIndex());
                this.unindent();
                this.emitLine("}");
            }
            if (decl.isSingleValue()) {
                this.emitMethodDecl(this._inlineApiDecl + setterFun, apiAuditMsg);
                this.emitLine(" {");
                this.indent();
                this.emitLine(memberName + " = val;");
                this.emitValidation(memberName, property.getPropIndex());
                this.unindent();
                this.emitLine("}");
                this.emitLine();
                this.emitLine("template<class T,");
                this.emitLine("         class = typename std::enable_if<");
                this.emitLine("            std::is_assignable<" + CppInterfaceEmitter.getTypeString(decl) + ", Vmacore::ForceConstLvalue<T>>::value>::type>");
                this.emitLine("inline void");
                this.emitLine(property.getMutator().getName() + "(T&& val)");
                this.emitLine(" {");
                this.indent();
                if (!decl.isOptional() && decl.getTypeId() == VmodlDecl.TypeId.STRING) {
                    this.emitLine(memberName + ".assign(std::forward<Vmacore::ForceConstLvalue<T>>(val));");
                } else {
                    this.emitLine(memberName + " = std::forward<Vmacore::ForceConstLvalue<T>>(val);");
                }
                this.emitValidation(memberName, property.getPropIndex());
                this.unindent();
                this.emitLine("}");
                this.emitLine();
            } else {
                this.emitMethodDecl(this._memberApiDecl + setterFun, apiAuditMsg);
                this.emitLine(";");
            }
            String swapperFun = CppInterfaceEmitter.formatDecl("void", property.getSwapper().getName()) + "(" + CppInterfaceEmitter.formatDecl(CppInterfaceEmitter.getSwapPropertyInParamString(decl), "val") + ")";
            if (decl.isSingleValue()) {
                this.emitMethodDecl(this._inlineApiDecl + swapperFun, apiAuditMsg);
                this.emitLine(" {");
                this.indent();
                this.emitLine("ASSERT(val != nullptr);");
                this.emitLine("Vmomi::Swap(" + memberName + ", val);");
                this.emitValidation(memberName, property.getPropIndex());
                this.unindent();
                this.emitLine("}");
            } else {
                this.emitMethodDecl(this._memberApiDecl + swapperFun, apiAuditMsg);
                this.emitLine(";");
            }
            if (!decl.isOptional() || !decl.isSingleValue()) continue;
            this.emitComment(property.getComment());
            this.emitMethodDecl(this._inlineApiDecl + CppInterfaceEmitter.formatDecl("void", property.getUnsetter().getName()) + "()", apiAuditMsg);
            this.emitLine(" { " + memberName + ".Unset(); }");
        }
        this.emitLine();
        this.unindent();
        this.emitLine("#ifdef VMX86_SERVER");
        this.emitLine("private:");
        this.emitLine("#else // VMX86_SERVER");
        this.emitLine("public:");
        this.emitLine("#endif // VMX86_SERVER");
        this.indent();
        for (Property property : obj.getPropertyList()) {
            String memberName = CppInterfaceEmitter.getMemberName(property);
            VmodlDecl decl = property.getDecl();
            this.emitComment(property.getComment());
            this.emitLine(CppInterfaceEmitter.formatDecl(CppInterfaceEmitter.getClassVariableDeclString(decl), memberName) + ";");
        }
        this.emitClassFooter(obj);
    }

    private void emitEnum(Enum obj) {
        this.emitComment(obj.getComment());
        this.emitLine("enum " + obj.getClassName() + " {");
        this.indent();
        for (String value : obj.getValueList()) {
            this.emitComment(obj.getComment(value));
            if (obj.getClassName().equals("VsanObjectTypeEnum") && value.equals("namespace")) {
                value = "namespace_";
            }
            if (obj.getClassName().equals("VsanHealthLogLevelEnum")) {
                value = "HEALTH_LOG_" + value;
            }
            this.emitLine(value + ",");
        }
        this.unindent();
        this.emitLine("};");
        this.emitLine();
        this.emitLine("// Enum value strings for enum type " + obj.getClassName());
        for (String value : obj.getValueList()) {
            String valueString = obj.getValueString(value);
            VmodlObject container = obj.getContainer();
            String modifier = container != null ? (container.getKind() == VmodlObject.Kind.DataObject ? this._memberApiDecl + "static" : "static") : this._apiDecl + "extern";
            this.emitLine(String.format("%s const char %s[%d];", modifier, valueString, value.length() + 1));
        }
        this.emitLine();
    }

    private void emitException(DataObject obj) {
        String className = obj.getClassName();
        String apiAuditMsg = this.getAPIAuditingMsg(obj);
        String baseClassName = CppInterfaceEmitter.getQualifiedClassName(obj.getBaseObject());
        this.emitLine("class " + this._classApiDecl + " Exception : public " + baseClassName + "::Exception {");
        this.emitLine("public:");
        this.indent();
        this.emitMethodDecl(this._inlineApiDecl + "Exception(" + className + " *fault)", apiAuditMsg);
        this.emitLine(" : " + baseClassName + "::Exception(fault) {}");
        List<String> declList = CppInterfaceEmitter.getPropDeclList(obj);
        List<String> argList = CppInterfaceEmitter.getPropArgList(obj);
        this.emitMethodDecl(this._inlineApiDecl + "Exception(" + CppInterfaceEmitter.join(declList, ", ") + ")", apiAuditMsg);
        this.emitLine(" : " + baseClassName + "::Exception(new " + className + "(" + CppInterfaceEmitter.join(argList, ", ") + ")) {}");
        this.emitMethodDecl(this._inlineApiDecl + "~Exception() throw()", apiAuditMsg);
        this.emitLine(" {}");
        this.emitMethodDecl(this._inlineApiDecl + className + " *GetFault()", apiAuditMsg);
        this.emitLine(" {");
        this.indent();
        String castArg = "(_fault.Ptr())";
        String staticCast = CppInterfaceEmitter.formatTemplate("static_cast", className + " *") + castArg;
        String dynamicCast = CppInterfaceEmitter.formatTemplate("dynamic_cast", className + " *") + castArg;
        this.emitLine("ASSERT(" + staticCast + " == " + dynamicCast + ");");
        this.emitLine("return " + staticCast + ";");
        this.unindent();
        this.emitLine("}");
        this.emitMethodDecl(this._inlineApiDecl + "const " + className + " *GetFault() const", apiAuditMsg);
        this.emitLine(" { return const_cast<" + className + "::Exception *>(this)->GetFault(); }");
        this.emitMethodDecl(this._inlineApiDecl + "Vmacore::Exception *Clone() const", apiAuditMsg);
        this.emitLine(" { return CloneImpl(this); }");
        this.emitMethodDecl(this._memberApiDecl + "NORETURN void Throw()", apiAuditMsg);
        this.emitLine(";");
        this.unindent();
        this.emitLine("};");
    }

    private void emitOutOfDeclInlines(VmodlObject obj) {
        if (obj.getKind() == VmodlObject.Kind.DataObject) {
            for (Property property : obj.getPropertyList()) {
                if (property.getDecl().isSingleValue()) continue;
                if (property.getDecl().isArray()) {
                    this.emitDataObjectIsSet(obj, (DataProperty)property);
                }
                this.emitDataObjectPeeker(obj, (DataProperty)property);
                this.emitDataObjectSetter(obj, (DataProperty)property);
                this.emitDataObjectSwapper(obj, (DataProperty)property);
            }
        }
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitOutOfDeclInlines(nestedObj);
        }
    }

    private void emitDataObjectIsSet(VmodlObject obj, DataProperty property) {
        String className = CppInterfaceEmitter.getFullClassName(obj);
        String memberName = CppInterfaceEmitter.getMemberName(property);
        this.emitLine("inline bool");
        this.emitLine(className + "::" + property.getIsSet().getName() + "() const");
        this.emitLine("{");
        this.emitLine("\treturn " + memberName + ".IsSet();");
        this.emitLine("}");
        this.emitLine();
    }

    private void emitDataObjectPeeker(VmodlObject obj, DataProperty property) {
        VmodlDecl decl = property.getDecl();
        String returnTypeName = CppInterfaceEmitter.getPeekPropertyReturnString(decl);
        String className = CppInterfaceEmitter.getFullClassName(obj);
        String memberName = CppInterfaceEmitter.getMemberName(property);
        this.emitLine("inline " + returnTypeName);
        this.emitLine(className + "::" + property.getPeeker().getName() + "() const");
        this.emitLine("{");
        this.emitLine("\treturn " + memberName + ".Peek();");
        this.emitLine("}");
        this.emitLine();
    }

    private void emitDataObjectSetter(VmodlObject obj, DataProperty property) {
        VmodlDecl decl = property.getDecl();
        String paramTypeName = CppInterfaceEmitter.getInParamString(decl);
        String className = CppInterfaceEmitter.getFullClassName(obj);
        String memberName = CppInterfaceEmitter.getMemberName(property);
        this.emitLine("inline void");
        this.emitLine(className + "::" + property.getMutator().getName() + "(" + CppInterfaceEmitter.formatDecl(paramTypeName, "val") + ")");
        this.emitLine("{");
        this.indent();
        this.emitLine(memberName + " = val;");
        this.emitValidation(memberName, property.getPropIndex());
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitDataObjectSwapper(VmodlObject obj, DataProperty property) {
        VmodlDecl decl = property.getDecl();
        String paramTypeName = CppInterfaceEmitter.getSwapPropertyInParamString(decl);
        String className = CppInterfaceEmitter.getFullClassName(obj);
        String memberName = CppInterfaceEmitter.getMemberName(property);
        this.emitLine("inline void");
        this.emitLine(className + "::" + property.getSwapper().getName() + "(" + CppInterfaceEmitter.formatDecl(paramTypeName, "val") + ")");
        this.emitLine("{");
        this.indent();
        this.emitLine("ASSERT(val != nullptr);");
        this.emitLine("Vmomi::Swap(" + memberName + ", val);");
        this.emitValidation(memberName, property.getPropIndex());
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitTypeMethod(VmodlObject obj) {
        String apiAuditMsg = this.getAPIAuditingMsg(obj);
        VmodlObject.Kind kind = obj.getKind();
        if (kind == VmodlObject.Kind.ManagedObject) {
            this.emitMethodDecl("Vmomi::ManagedObjectType *_GetType() const", apiAuditMsg);
            this.emitLine(";");
        } else {
            this.emitMethodDecl(this._memberApiDecl + "Vmomi::Type *_GetType() const", apiAuditMsg);
            this.emitLine(";");
            if (kind == VmodlObject.Kind.DataObject) {
                this.emitMethodDecl(this._memberApiDecl + "Vmomi::DataObjectType *_GetDataType() const", apiAuditMsg);
                this.emitLine(";");
            }
        }
    }

    private void emitCloneMethod(VmodlObject obj) {
        String apiAuditMsg = this.getAPIAuditingMsg(obj);
        this.emitMethodDecl(this._inlineApiDecl + obj.getClassName() + " *_Clone() const", apiAuditMsg);
        this.emitLine(" { return new " + obj.getClassName() + "(*this); }");
    }

    private void emitIsEqualMethod(VmodlObject obj) {
        String apiAuditMsg = this.getAPIAuditingMsg(obj);
        this.emitMethodDecl(this._memberApiDecl + "bool _IsEqual(const Vmomi::Any *obj, bool looseMatch) const", apiAuditMsg);
        this.emitLine(";");
    }

    private void emitDiffPropertiesMethod(DataObject obj) {
        if (obj.isFault()) {
            return;
        }
        String apiAuditMsg = this.getAPIAuditingMsg(obj);
        this.emitMethodDecl(this._memberApiDecl + "void _DiffProperties(const Vmomi::Any *obj, const Vmomi::String& ppath, Vmomi::PropertyDiffSet& diffSet) const", apiAuditMsg);
        this.emitLine();
        this.emitLine(";");
    }

    @Override
    protected void emitComment(String comment) {
        this.emitComment(comment, null);
    }

    @Override
    protected void emitComment(String comment, String supplementalComment) {
        this.emitGap();
        if (comment != null && (comment = comment.trim()).isEmpty()) {
            comment = null;
        }
        if (supplementalComment != null && (supplementalComment = supplementalComment.trim()).isEmpty()) {
            supplementalComment = null;
        }
        Pattern genericEol = Pattern.compile("\r\n?|\n");
        if (comment != null || supplementalComment != null) {
            this.emitLine("/**");
            if (comment != null) {
                for (String line : genericEol.split(comment)) {
                    this.emitLine(" * " + line);
                }
            }
            if (supplementalComment != null) {
                for (String line : genericEol.split(supplementalComment)) {
                    this.emitLine(" * " + line);
                }
            }
            this.emitLine(" */");
        }
    }

    private void emitClassHeader(VmodlObject obj) {
        String typeDecl;
        String baseDecl;
        String baseClassName = CppInterfaceEmitter.getQualifiedClassName(obj.getBaseObject());
        if (obj.getKind() == VmodlObject.Kind.ManagedObject) {
            baseDecl = "virtual public " + baseClassName;
            typeDecl = this._apiDecl;
        } else {
            baseDecl = "public " + baseClassName;
            typeDecl = this._classApiDecl;
        }
        this.emitComment(obj.getComment());
        String name = obj.getClassName();
        this.emitLine("class " + typeDecl + name + " : " + baseDecl + " {");
        this.emitLine("public:");
        this.indent();
    }

    private void emitClassFooter(VmodlObject obj) {
        this.unindent();
        this.emitLine("};");
        this.emitLine();
    }

    private void beginObjHeader(VmodlObject obj, String declFilename) {
        this.beginHeader(this.getHeaderFile(obj));
        this.emitLine("#ifndef VMOMI_EMITTER");
        this.emitLine("#   define VMOMI_EMITTER");
        this.emitLine("#   define LOCAL_VMOMI_EMITTER");
        this.emitLine("#endif");
        this.emitLine();
        this.emitInclude("vmomi/emitter.h");
        this.emitInclude(declFilename);
        this.emitLine();
        Set<VmodlObject> propertyObjects = this.getPropertyObjects(obj);
        this.includeMethodFaultIfNeeded(propertyObjects);
        Set<VmodlObject> dependentObjects = this.getDependentObjects(obj, propertyObjects);
        this.emitDependentIncludes(dependentObjects, declFilename);
    }

    private void endObjHeader(VmodlObject obj) {
        this.emitLine("#ifdef LOCAL_VMOMI_EMITTER");
        this.emitLine("#   undef LOCAL_VMOMI_EMITTER");
        this.emitLine("#   undef VMOMI_EMITTER");
        this.emitLine("#endif");
        this.endFile();
    }

    private void beginObjDecl(VmodlObject obj, String declFilename) {
        this.beginHeader(declFilename);
        this.includeMethodFaultIfNeeded(CppInterfaceEmitter.allNestedTypes(obj));
        this.emitIncludes();
        this.emitDependentIncludes(obj.getHardDependencies(), declFilename);
        this.emitLine();
        TreeMap<String, VmodlObject> declMap = new TreeMap<String, VmodlObject>();
        for (VmodlObject vmodlObject : obj.getSoftDependencies()) {
            declMap.put(CppInterfaceEmitter.getQualifiedClassName(vmodlObject), vmodlObject);
        }
        for (Map.Entry entry : declMap.entrySet()) {
            VmodlObject dependObj = (VmodlObject)entry.getValue();
            if (CppInterfaceEmitter.isBuiltin(dependObj)) continue;
            this.setNamespace(dependObj.getNamespace());
            this.emitLine("class ", dependObj.getClassName(), ";");
        }
        this.setNamespace("");
    }

    private Set<VmodlObject> getPropertyObjects(VmodlObject obj) {
        HashSet<VmodlObject> result = new HashSet<VmodlObject>();
        for (VmodlObject nestedObj : CppInterfaceEmitter.allNestedTypes(obj)) {
            for (Property property : nestedObj.getPropertyList()) {
                VmodlDecl decl = property.getDecl();
                VmodlObject object = decl.getObject();
                if (object == null || decl.isValue()) continue;
                result.add(object);
            }
        }
        return result;
    }

    private void includeMethodFaultIfNeeded(Iterable<VmodlObject> list) {
        for (VmodlObject vmodlObject : list) {
            if (!vmodlObject.isFault()) continue;
            this.emitInclude("vmomi/MethodFault.h");
            return;
        }
    }

    private Set<VmodlObject> getDependentObjects(VmodlObject obj, Set<VmodlObject> propertyObjects) {
        HashSet<VmodlObject> result = new HashSet<VmodlObject>();
        for (VmodlObject object : obj.getSoftDependencies()) {
            if (!propertyObjects.contains(object)) continue;
            result.add(object);
        }
        return result;
    }

    private String getHeaderDeclFile(VmodlObject obj) {
        return this.getHeaderFilePrefix(obj) + "-decl.h";
    }

    private void emitDependentIncludes(Set<VmodlObject> objects, String declFilename) {
        TreeSet<String> includeSet = new TreeSet<String>();
        for (VmodlObject dependObj : objects) {
            String dependHeader = this.getHeaderDeclFile(dependObj);
            if (dependHeader.equals(declFilename) || CppInterfaceEmitter.isBuiltin(dependObj)) continue;
            includeSet.add(dependHeader);
        }
        this.emitIncludes(includeSet);
    }

    private void emitApiHeader() {
        if (this._apiHeaderFile == null) {
            return;
        }
        this.beginHeader(this._apiHeaderFile);
        this.emitLine("#ifndef " + this._apiName);
        this.emitLine("#   if defined STATIC_" + this._apiName);
        this.emitLine("#      define " + this._apiName + " VMW_LIB_STATIC");
        this.emitLine("#   elif defined EXPORT_" + this._apiName);
        this.emitLine("#      define " + this._apiName + " VMW_LIB_DYNAMIC");
        this.emitLine("#   else");
        this.emitLine("#      define " + this._apiName + " VMW_LIB_CLIENT");
        this.emitLine("#   endif");
        this.emitLine("#endif");
        this.emitLine();
        this.emitLine("#define " + this._apiName + "_CLASS VMOMI_EXPORT_CLASS(" + this._apiName + ")");
        this.emitLine("#define " + this._apiName + "_MEMBER VMOMI_EXPORT_MEMBER(" + this._apiName + ")");
        this.emitLine("#define " + this._apiName + "_INLINE VMOMI_EXPORT_INLINE(" + this._apiName + ")");
        this.endFile();
    }

    private void emitVersionsHeader() {
        if (this._apiName.equals("VMODL_HOSTD_API") || this._apiName.equals("VMODL_VIMINT_API")) {
            return;
        }
        this.beginHeader(this.getVersionsHeader());
        this.emitInclude("vmomi/version.h");
        if (this._apiHeaderFile != null) {
            this.emitInclude(this._apiHeaderFile);
        }
        this.emitLine();
        this.setNamespace(this._capitalizedNamespace);
        TreeSet<Version> versionSet = this.getVersionSet(this._targetNs);
        Iterator<Version> it = versionSet.descendingIterator();
        int disabledCount = 0;
        this.emitLine("enum class VERSION {", INDENT);
        while (it.hasNext()) {
            Version version = it.next();
            Version.Kind kind = version.getKind();
            if (kind == Version.Kind.FEATURE) continue;
            if (kind == Version.Kind.DISABLED) {
                ++disabledCount;
                continue;
            }
            this.emitLine(version.getSimpleName().toUpperCase(), ",");
        }
        this.emitLine(UNINDENT, "};");
        this.emitLine();
        for (NsVersionAliases.Entry entry : Versions.getNsVersionAliases()) {
            this.emitLine("const VERSION ", entry.label, "_VERSION = VERSION::", entry.version.getSimpleName().toUpperCase(), ";");
        }
        this.emitLine();
        this.emitLine("extern ", this._apiDecl, "Vmomi::NamespaceId vmodlNamespaceId;");
        this.emitLine("extern ", this._apiDecl, "const Vmomi::PublicVersion *vmodlNsPublicVersions[", Integer.toString(versionSet.size() - disabledCount), "];");
        this.emitLine("extern ", this._apiDecl, "const Vmomi::InternalVersion *vmodlNsInternalVersions[", Integer.toString(versionSet.size() - disabledCount), "];");
        this.emitLine();
        this.emitLine("inline const Vmomi::PublicVersion *GetPublicVersion(VERSION version) {");
        this.emitLine("\treturn vmodlNsPublicVersions[static_cast<unsigned>(version)];");
        this.emitLine("}");
        this.emitLine();
        this.emitLine("inline const Vmomi::InternalVersion *GetInternalVersion(VERSION version) {");
        this.emitLine("\treturn vmodlNsInternalVersions[static_cast<unsigned>(version)];");
        this.emitLine("}");
        this.setNamespace("");
        this.endFile();
    }

    static Iterable<VmodlObject> allNestedTypes(final VmodlObject obj) {
        return new Iterable<VmodlObject>(){

            @Override
            public Iterator<VmodlObject> iterator() {
                class NestedTypeIter
                implements Iterator<VmodlObject> {
                    private List<VmodlObject> _pendingTypes = new ArrayList<VmodlObject>();

                    public NestedTypeIter(VmodlObject obj) {
                        this._pendingTypes.add(obj);
                    }

                    @Override
                    public boolean hasNext() {
                        return !this._pendingTypes.isEmpty();
                    }

                    @Override
                    public VmodlObject next() {
                        if (this._pendingTypes.isEmpty()) {
                            throw new NoSuchElementException();
                        }
                        VmodlObject result = this._pendingTypes.remove(0);
                        this._pendingTypes.addAll(result.getNestedList());
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new NestedTypeIter(obj);
            }
        };
    }
}

