/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.ObjectRegistry;
import emitters.VmodlEmitter;
import emitters.generators.joap.ObjectsEnumerator;
import emitters.lists.CoreObjects;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;

public abstract class JoapEmitter
extends VmodlEmitter {
    protected final String _folder;
    protected final ManagedObject[] _managedObjects;
    protected final DataObject[] _dataObjects;
    protected final Enum[] _enums;

    public JoapEmitter(String folder) {
        this._folder = folder;
        ObjectsEnumerator enumerator = this.enumerateObjects();
        this._managedObjects = enumerator.getManagedObjects();
        this._dataObjects = enumerator.getDataObjects();
        this._enums = enumerator.getEnums();
    }

    ObjectsEnumerator enumerateObjects() {
        class EnumeratorFilter
        implements ObjectsEnumerator.Filter {
            private final CoreObjects _coreObjects = new CoreObjects();

            EnumeratorFilter() {
            }

            @Override
            public boolean shouldEmit(VmodlObject object) {
                return JoapEmitter.shouldEmit(object) && !this._coreObjects.contains(object);
            }
        }
        return new ObjectsEnumerator(ObjectRegistry.getAllObjects(), new EnumeratorFilter());
    }

    protected static boolean shouldEmit(VmodlApi vmodlApi) {
        return vmodlApi.getVersion().getKind() == Version.Kind.LTS && !vmodlApi.isInternal();
    }
}

