/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.VmodlObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ObjectsEnumerator {
    public static final ManagedObject[] ManagedObjectArray = new ManagedObject[0];
    public static final DataObject[] DataObjectArray = new DataObject[0];
    public static final Enum[] EnumArray = new Enum[0];
    private final Collection<VmodlObject> _objects;
    private final Filter _filter;
    private final Set<ManagedObject> _managedObjectSet;
    private final Set<DataObject> _dataObjectSet;
    private final Set<Enum> _enumSet;
    private final ManagedObject[] _managedObjects;
    private final DataObject[] _dataObjects;
    private final Enum[] _enums;

    public ObjectsEnumerator(Collection<VmodlObject> objects, Filter filter) {
        this._objects = objects;
        this._filter = filter;
        int count = objects.size();
        this._dataObjectSet = new HashSet<DataObject>(2 * count);
        this._managedObjectSet = new HashSet<ManagedObject>(count / 8);
        this._enumSet = new HashSet<Enum>();
        this.enumerate(this._objects);
        this._managedObjects = this._managedObjectSet.toArray(ManagedObjectArray);
        this._dataObjects = this._dataObjectSet.toArray(DataObjectArray);
        this._enums = this._enumSet.toArray(EnumArray);
        Arrays.sort(this._managedObjects);
        Arrays.sort(this._dataObjects);
        Arrays.sort(this._enums);
    }

    private void enumerate(Iterable<VmodlObject> objects) {
        for (VmodlObject object : objects) {
            if (!this._filter.shouldEmit(object)) continue;
            switch (object.getKind()) {
                case ManagedObject: {
                    this._managedObjectSet.add((ManagedObject)object);
                    break;
                }
                case DataObject: {
                    this._dataObjectSet.add((DataObject)object);
                    break;
                }
                case Enum: {
                    this._enumSet.add((Enum)object);
                }
            }
            this.enumerate(object.getNestedList());
        }
    }

    public ManagedObject[] getManagedObjects() {
        return this._managedObjects;
    }

    public DataObject[] getDataObjects() {
        return this._dataObjects;
    }

    public Enum[] getEnums() {
        return this._enums;
    }

    public static interface Filter {
        public boolean shouldEmit(VmodlObject var1);
    }
}

