/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.Versions;
import emitters.generators.joap.DummyRawObject;
import emitters.generators.joap.JoapEmitter;
import emitters.generators.joap.OperationId;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.Field;
import emitters.model.ManagedObject;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenAPI3
extends JoapEmitter {
    private final OP_ID_FLAVOR _opIdFlavor;
    private final boolean _variableNamespace;
    private final boolean _variableVersion;
    private final Set<CustomObject> _customObjects;
    private static final Comparator<VmodlApi> NameComparator = new Comparator<VmodlApi>(){

        @Override
        public int compare(VmodlApi lhs, VmodlApi rhs) {
            return lhs.getName().compareTo(rhs.getName());
        }
    };
    private static final Comparator<CustomObject> CustomObjectComparator = new Comparator<CustomObject>(){

        @Override
        public int compare(CustomObject lhs, CustomObject rhs) {
            return lhs._name.compareTo(rhs._name);
        }
    };
    private static final String CORE_NAMESPACE = "core";
    private static final String CORE_PACKAGE = "core.";
    private static final String ANY_SCHEMA_NAME = "Any";
    private static final String MOREF_SCHEMA_NAME = "MoRef";
    private static final String MOID_PARAM_NAME = "moId";
    private static final String MOID_PARAM_SCHEMA_NAME = "moId";
    private static final String NAMESPACE_PARAM_NAME = "urlNamespace";
    private static final String NAMESPACE_PARAM_SCHEMA_NAME = "urlNamespace";
    private static final String VERSION_PARAM_NAME = "urlVersion";
    private static final String VERSION_PARAM_SCHEMA_NAME = "urlVersion";
    private static final DataObject _Any = new DataObject(new DummyRawObject("Any", ""), null);
    private static final Enum _moTypes = new Enum(new DummyRawObject("MoTypes", ""), null);
    private static final Primitive[] PRIMITIVES = new Primitive[]{new Primitive("Boolean", VmodlDecl.TypeId.BOOLEAN), new Primitive("Byte", VmodlDecl.TypeId.BYTE), new Primitive("Short", VmodlDecl.TypeId.SHORT), new Primitive("Int", VmodlDecl.TypeId.INT), new Primitive("Long", VmodlDecl.TypeId.LONG), new Primitive("Float", VmodlDecl.TypeId.FLOAT), new Primitive("Double", VmodlDecl.TypeId.DOUBLE), new Primitive("String", VmodlDecl.TypeId.STRING), new Primitive("DateTime", VmodlDecl.TypeId.DATETIME), new Primitive("URI", VmodlDecl.TypeId.URI), new Primitive("Binary", VmodlDecl.TypeId.BINARY), new Primitive("TypeName", VmodlDecl.TypeId.TYPENAME), new Primitive("PropPath", VmodlDecl.TypeId.PROPPATH), new Primitive("MethodName", VmodlDecl.TypeId.METHODNAME), new Primitive("MoRef", VmodlDecl.TypeId.MANAGED)};
    private static final Map<String, String> NS_REMAP = new HashMap<String, String>();
    private static final Method[] METHOD_ARRAY;
    private static final Property[] PROPERTY_ARRAY;
    private static final CustomObject[] CUSTOM_OBJECT_ARRAY;
    private static final List<DataObject> NO_FAULTS;
    private static final String BYTE_MIN = "-128";
    private static final String BYTE_MAX = "127";
    private static final String SHORT_MIN = "-32768";
    private static final String SHORT_MAX = "32767";
    private static final String APPLICATION_JSON = "application/json:";

    public OpenAPI3(Map<String, String> options, String folder) {
        super(folder);
        OP_ID_FLAVOR opIdFlavor_ = OP_ID_FLAVOR.DEFAULT;
        String opIdFlavor = options.get("opid.flavor");
        if (opIdFlavor != null) {
            if (opIdFlavor.equals("with.hash")) {
                opIdFlavor_ = OP_ID_FLAVOR.WITH_HASH;
            } else if (opIdFlavor.equals("optimized")) {
                opIdFlavor_ = OP_ID_FLAVOR.OPTIMIZED;
            } else {
                throw new RuntimeException("Unkwnown opid.flavor: " + opIdFlavor);
            }
        }
        this._opIdFlavor = opIdFlavor_;
        boolean variableNamespace_ = false;
        boolean variableVersion_ = false;
        String urlFlavor = options.get("url.flavor");
        if (urlFlavor != null) {
            if (urlFlavor.equals("variable.namespace")) {
                variableNamespace_ = true;
            } else if (urlFlavor.equals("variable.version")) {
                variableVersion_ = true;
            } else if (urlFlavor.equals("variable.schema")) {
                variableNamespace_ = true;
                variableVersion_ = true;
            } else {
                throw new RuntimeException("Unkown url.flavor: " + urlFlavor);
            }
        }
        this._variableNamespace = variableNamespace_;
        this._variableVersion = variableVersion_;
        this.preprocessManagedObjects();
        this._customObjects = new HashSet<CustomObject>(this._managedObjects.length * 4);
        this.setIndentSpaces("  ");
    }

    void preprocessManagedObjects() {
        for (ManagedObject managedObject : this._managedObjects) {
            String moType = OpenAPI3.getJsonName(managedObject);
            _moTypes.addValue(moType, null, null);
        }
        switch (this._opIdFlavor) {
            case WITH_HASH: {
                this.setOpIdHashes();
                break;
            }
            case OPTIMIZED: {
                this.setOnDemandOpIdHashes();
                break;
            }
        }
    }

    private void setOpIdHashes() {
        for (ManagedObject managedObject : this._managedObjects) {
            String opId;
            String hash = OpenAPI3.calcHash(managedObject);
            for (Method method : managedObject.getMethodList()) {
                opId = OpenAPI3.getNameHashCombo(method.getName(), hash);
                method.setCustomName(opId);
            }
            for (Property property : this.getReleasedProperties(managedObject)) {
                opId = OpenAPI3.getNameHashCombo(property.getName(), hash);
                ((ManagedProperty)property).setCustomName(opId);
            }
        }
    }

    private void setOnDemandOpIdHashes() {
        ArrayList<OperationId> opList = new ArrayList<OperationId>(this._managedObjects.length * 4);
        for (ManagedObject managedObject : this._managedObjects) {
            String hash = OpenAPI3.calcHash(managedObject);
            for (Method method : managedObject.getMethodList()) {
                opList.add(new OperationId(hash, method));
            }
            for (Property property : this.getReleasedProperties(managedObject)) {
                opList.add(new OperationId(hash, property));
            }
        }
        OperationId[] operations = opList.toArray(new OperationId[0]);
        Arrays.sort(operations, OperationId.getComparator());
        String lastName = null;
        int startIndex = 0;
        int size = operations.length;
        for (int i = 0; i < size; ++i) {
            String name = operations[i].getName();
            if (name.equals(lastName)) continue;
            if (i - startIndex > 1) {
                this.setOpIdHashes(operations, startIndex, i);
            }
            startIndex = i;
            lastName = name;
        }
        if (size - startIndex > 1) {
            this.setOpIdHashes(operations, startIndex, size);
        }
    }

    private void setOpIdHashes(OperationId[] operations, int index, int endIndex) {
        while (index < endIndex) {
            operations[index++].setName();
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.beginFile(this._folder + "/joap.yaml");
        this.emitHeader("vSphere APIs", this.getTargetVersion().getWireId());
        this.emitLine("paths:", INDENT);
        for (ManagedObject managedObject : this._managedObjects) {
            this.emitMethods(managedObject);
            this.emitManagedPropertyGetters(managedObject);
        }
        this.unindent();
        this.emitLine("components:", INDENT);
        this.emitLine("schemas:", INDENT);
        this.emitCoreObjects();
        this.emitCustomObjects();
        this.emitDataObjects();
        this.emitEnums();
        this.unindent();
        this.emitLine("parameters:", INDENT);
        this.emitMoIdParameter();
        if (this._variableNamespace) {
            this.emitNamespaceParameter();
        }
        if (this._variableVersion) {
            this.emitVersionParameter();
        }
        this.unindent();
        this.endFile();
    }

    private Version getTargetVersion() {
        Version version = Versions.getTargetVersion();
        String wireNs = version.getWireNs();
        block0: while (version.getKind() != Version.Kind.LTS) {
            for (Version parent : version.getDirectParents()) {
                if (!parent.getWireNs().equals(wireNs)) continue;
                version = parent;
                continue block0;
            }
        }
        return version;
    }

    private void emitHeader(String title, String version) {
        this.emitLine("openapi: 3.0.0");
        this.emitLine("info:", INDENT);
        this.emitLine("title: ", OpenAPI3.qs(title));
        this.emitLine("version: ", version);
        this.unindent();
        this.emitGap();
        this.emitLine("servers:", INDENT);
        this.emitLine("- url: http://localhost/sdk");
        this.unindent();
        this.emitGap();
    }

    private void emitMethods(ManagedObject managedObject) {
        Method[] methods = managedObject.getMethodList().toArray(METHOD_ARRAY);
        Arrays.sort(methods, NameComparator);
        String moType = OpenAPI3.getJsonName(managedObject);
        for (Method method : methods) {
            if (!OpenAPI3.shouldEmit(method)) continue;
            this.pushIndent();
            this.emitOperation(moType, method.getName(), this.getOpId(moType, method), "post");
            List<Parameter> parameters = method.getParameterList();
            if (!parameters.isEmpty()) {
                String schemaId = moType + "." + method.getName() + ".params";
                this._customObjects.add(new MethodParameters(schemaId, parameters));
                this.emitRequestBody(schemaId);
            }
            VmodlDecl result = method.isTask() ? Method.taskReturnDecl() : method.getReturnDecl();
            this.emitResponse(result, method.getFaultList());
            this.popIndent();
            this.emitGap();
        }
    }

    private void emitManagedPropertyGetters(ManagedObject managedObject) {
        Property[] properties = this.getReleasedProperties(managedObject).toArray(PROPERTY_ARRAY);
        Arrays.sort(properties, NameComparator);
        String moType = OpenAPI3.getJsonName(managedObject);
        for (Property property : properties) {
            this.pushIndent();
            this.emitOperation(moType, property.getName(), this.getOpId(moType, property), "get");
            this.emitResponse(property.getDecl(), NO_FAULTS);
            this.popIndent();
            this.emitGap();
        }
    }

    private void emitOperation(String moTypeId, String methodName, String opId, String httpMethod) {
        this.emitOperationSchema();
        this.emitLine("/", moTypeId, "/{", "moId", "}/", methodName, ":");
        this.emitLine(INDENT, httpMethod, ":");
        this.emitLine(INDENT, "tags: [", moTypeId, "]");
        this.emitLine("operationId: ", opId);
        this.emitLine("parameters:", INDENT);
        this.emitLine("- $ref: '#/components/parameters/", "moId", "'");
        this.emitOperationSchemaParams();
        this.unindent();
    }

    private void emitOperationSchema() {
        Version targetVersion = this.getTargetVersion();
        if (this._variableNamespace) {
            this.emitPartial("/{", "urlNamespace", "}");
        } else {
            this.emitPartial("/", targetVersion.getNamespace());
        }
        if (this._variableVersion) {
            this.emitPartial("/{", "urlVersion", "}");
        } else {
            this.emitPartial("/", targetVersion.getWireId());
        }
    }

    private void emitOperationSchemaParams() {
        if (this._variableNamespace) {
            this.emitLine("- $ref: '#/components/parameters/", "urlNamespace", "'");
        }
        if (this._variableVersion) {
            this.emitLine("- $ref: '#/components/parameters/", "urlVersion", "'");
        }
    }

    private String getOpId(String moType, Method method) {
        switch (this._opIdFlavor) {
            case WITH_HASH: {
                return method.getCustomName();
            }
            case OPTIMIZED: {
                String customName = method.getCustomName();
                return customName != null ? customName : method.getName();
            }
        }
        return moType + "." + method.getName();
    }

    private String getOpId(String moType, Property property) {
        ManagedProperty managedProperty = (ManagedProperty)property;
        switch (this._opIdFlavor) {
            case WITH_HASH: {
                return this.getterName(managedProperty.getCustomName());
            }
            case OPTIMIZED: {
                String customName = managedProperty.getCustomName();
                return this.getterName(customName != null ? customName : managedProperty.getName());
            }
        }
        return moType + "." + this.getterName(managedProperty.getName());
    }

    private String getterName(String name) {
        return "get" + OpenAPI3.capitalize(name);
    }

    private void emitRequestBody(String schemaId) {
        this.pushIndent();
        this.emitLine("requestBody:", INDENT);
        this.emitLine("required: true");
        this.emitContentTags();
        this.emitRef(schemaId);
        this.popIndent();
    }

    private void emitResponse(VmodlDecl result, List<DataObject> faults) {
        this.emitLine("responses:", INDENT);
        this.pushIndent();
        if (result.getTypeId() == VmodlDecl.TypeId.VOID) {
            this.emitLine("'204':", INDENT);
            this.emitOpenAPI_description("No Content");
        } else {
            this.emitLine("'200':", INDENT);
            this.emitOpenAPI_description("OK");
            this.emitContentTags();
            if (result.isOptional()) {
                this.emitLine("nullable: true");
                this.emitLine("allOf:", INDENT);
                this.emitPartial("- ");
                this.indent();
            }
            this.emitDecl(result);
        }
        this.popIndent();
        if (faults.size() > 0) {
            this.emitLine("'500':", INDENT);
            this.emitOpenAPI_description("Failure");
            this.emitContentTags();
            this.emitRef(this.getCommonAncestor(faults));
        }
    }

    VmodlObject getCommonAncestor(List<DataObject> faults) {
        VmodlObject firstFault = faults.get(0);
        if (faults.size() == 1) {
            return firstFault;
        }
        ArrayList<VmodlObject> faultsList = this.getParentsList(firstFault);
        int index = 0;
        block0: for (DataObject fault : faults) {
            ArrayList<VmodlObject> parentsList = this.getParentsList(fault);
            int faultsIndex = faultsList.size();
            int parentsIndex = parentsList.size();
            while (faultsIndex > index && parentsIndex > 0) {
                if (faultsList.get(--faultsIndex) == parentsList.get(--parentsIndex)) continue;
                index = faultsIndex + 1;
                continue block0;
            }
        }
        return faultsList.get(index);
    }

    ArrayList<VmodlObject> getParentsList(VmodlObject fault) {
        ArrayList<VmodlObject> result = new ArrayList<VmodlObject>();
        do {
            result.add(fault);
        } while ((fault = fault.getBaseObject()) != null);
        return result;
    }

    private void emitContentTags() {
        this.emitLine("content:", INDENT);
        this.emitLine(APPLICATION_JSON, INDENT);
        this.emitLine("schema:", INDENT);
    }

    private void emitCoreObjects() {
        this.emitAnySchema();
        this.emitMoRefSchema();
        for (Primitive primitive : PRIMITIVES) {
            this.emitBoxedPrimitive(primitive);
        }
    }

    private void emitAnySchema() {
        VmodlDecl stringDecl = new VmodlDecl(VmodlDecl.TypeId.STRING);
        this.emitSchemaObject(ANY_SCHEMA_NAME, null, this.getFieldList("className", stringDecl));
        this.pushIndent();
        this.emitLine(INDENT, "discriminator:");
        this.emitLine(INDENT, "propertyName: className");
        this.popIndent();
    }

    private void emitMoRefSchema() {
        VmodlDecl optionalStringDecl = new VmodlDecl(VmodlDecl.TypeId.STRING);
        optionalStringDecl.setOptional();
        Field[] fields = new Field[]{new Field("type", new VmodlDecl(VmodlDecl.TypeId.ENUM, _moTypes)), new Field("moId", new VmodlDecl(VmodlDecl.TypeId.STRING)), new Field("container", optionalStringDecl)};
        this.emitSchemaObject(MOREF_SCHEMA_NAME, null, Arrays.asList(fields));
        this.emitEnumSchema(_moTypes);
    }

    private void emitBoxedPrimitive(Primitive primitive) {
        String typeName = CORE_PACKAGE + primitive.typeName;
        VmodlDecl typeDecl = new VmodlDecl(primitive.typeId);
        this.emitBoxedType(typeName, typeDecl);
    }

    private void emitBoxedType(String typeName, VmodlDecl typeDecl) {
        this.emitSchemaObject(typeName, _Any, this.getFieldList(typeDecl));
        this.emitBoxedArray(typeName, typeDecl);
    }

    private void emitBoxedArray(String typeName, VmodlDecl decl) {
        String arrayName = typeName + ".array";
        VmodlDecl arrayDecl = new VmodlDecl(decl.getTypeId(), decl.getObject());
        arrayDecl.setArray();
        this.emitSchemaObject(arrayName, _Any, this.getFieldList(arrayDecl));
    }

    private List<? extends Field> getFieldList(VmodlDecl decl) {
        return this.getFieldList("value", decl);
    }

    private List<? extends Field> getFieldList(String name, VmodlDecl decl) {
        Field[] fields = new Field[]{new Field(name, decl)};
        return Arrays.asList(fields);
    }

    private void emitSchemaObject(String name, VmodlObject base, List<? extends Field> fields) {
        this.pushIndent();
        this.emitSchemaEntry(name);
        this.emitOpenAPI_object(base, fields);
        this.emitGap();
        this.popIndent();
    }

    private void emitCustomObjects() {
        CustomObject[] customObjectList = this._customObjects.toArray(CUSTOM_OBJECT_ARRAY);
        Arrays.sort(customObjectList, CustomObjectComparator);
        for (CustomObject customObject : customObjectList) {
            customObject.generate();
        }
    }

    private void emitDataObjects() {
        for (DataObject dataObject : this._dataObjects) {
            VmodlObject base = dataObject.getBaseObject();
            if (base == null) {
                base = _Any;
            }
            String name = OpenAPI3.getJsonName(dataObject);
            this.emitSchemaObject(name, base, this.getReleasedProperties(dataObject));
            this.emitBoxedArray(name, new VmodlDecl(VmodlDecl.TypeId.DATA, dataObject));
        }
    }

    private void emitEnums() {
        for (Enum enum_ : this._enums) {
            List<String> values = enum_.getValueList();
            if (values.isEmpty()) continue;
            this.emitEnumSchema(enum_);
            this.emitBoxedType(OpenAPI3.getJsonName(enum_), new VmodlDecl(VmodlDecl.TypeId.ENUM, enum_));
        }
    }

    private void emitEnumSchema(Enum enum_) {
        this.pushIndent();
        this.emitSchemaEntry(this.getSchemaName(enum_));
        this.emitLine("type: string");
        this.emitLine("enum:", INDENT);
        for (String value : enum_.getValueList()) {
            this.emitLine("- ", value);
        }
        this.emitGap();
        this.popIndent();
    }

    private String getSchemaName(Enum enum_) {
        return OpenAPI3.getJsonName(enum_) + ".enum";
    }

    private void emitSchemaEntry(String id) {
        this.emitLine(id, ":");
        this.indent();
    }

    private void emitDashRef(VmodlObject object) {
        this.emitPartial("- ");
        this.emitRef(object);
    }

    private void emitRef(VmodlObject object) {
        this.emitRef(OpenAPI3.getJsonName(object));
    }

    private void emitRef(String typeName) {
        this.emitPartial("$ref: ");
        this.emitSchemaRef(typeName);
    }

    private void emitSchemaRef(String schemaId) {
        this.emitLine("'#/components/schemas/", schemaId, "'");
    }

    private void emitDecl(VmodlDecl decl) {
        if (decl.isArray()) {
            this.emitLine("type: array");
            this.emitLine("items:", INDENT);
        }
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                this.emitOpenAPI_type("boolean");
                break;
            }
            case BYTE: {
                this.emitOpenAPI_int(BYTE_MIN, BYTE_MAX);
                break;
            }
            case SHORT: {
                this.emitOpenAPI_int(SHORT_MIN, SHORT_MAX);
                break;
            }
            case INT: {
                this.emitOpenAPI_type("integer", "int32");
                break;
            }
            case LONG: {
                this.emitOpenAPI_type("integer", "int64");
                break;
            }
            case FLOAT: {
                this.emitOpenAPI_type("number", "float");
                break;
            }
            case DOUBLE: {
                this.emitOpenAPI_type("number", "double");
                break;
            }
            case BINARY: {
                this.emitOpenAPI_type("string", "byte");
                break;
            }
            case DATETIME: {
                this.emitOpenAPI_type("string", "date-time");
                break;
            }
            case METHODNAME: 
            case PROPPATH: 
            case TYPENAME: 
            case URI: 
            case STRING: {
                if (decl.isSecret()) {
                    this.emitOpenAPI_type("string", "password");
                    break;
                }
                this.emitOpenAPI_type("string");
                break;
            }
            case ANY: {
                this.emitRef(ANY_SCHEMA_NAME);
                break;
            }
            case MANAGED: {
                this.emitRef(MOREF_SCHEMA_NAME);
                break;
            }
            case ENUM: {
                this.emitRef(this.getSchemaName((Enum)decl.getObject()));
                break;
            }
            case DATA: {
                this.emitRef(decl.getObject());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected object type: " + (Object)((Object)decl.getTypeId()));
            }
        }
    }

    private void emitOpenAPI_type(String type) {
        this.emitLine("type: ", type);
    }

    private void emitOpenAPI_type(String type, String format) {
        this.emitOpenAPI_type(type);
        this.emitLine("format: ", format);
    }

    private void emitOpenAPI_int(String min, String max) {
        this.emitOpenAPI_type("integer");
        this.emitLine("minimum: ", min);
        this.emitLine("maximum: ", max);
    }

    private void emitOpenAPI_object(VmodlObject base, List<? extends Field> fields) {
        if (base != null) {
            this.emitLine("allOf:", INDENT);
            this.emitDashRef(base);
            this.emitPartial("- ");
            this.indent();
        }
        this.emitLine("type: object");
        if (fields.isEmpty()) {
            return;
        }
        ArrayList<String> requiredFields = new ArrayList<String>();
        this.emitLine("properties:", INDENT);
        for (Field field : fields) {
            VmodlDecl decl = field.getDecl();
            String name = field.getName();
            if (!decl.isOptional()) {
                requiredFields.add(name);
            }
            this.pushIndent();
            this.emitLine(name, ":");
            this.indent();
            this.emitDecl(decl);
            this.popIndent();
        }
        this.unindent();
        if (!requiredFields.isEmpty()) {
            this.emitLine("required:", INDENT);
            for (String string : requiredFields) {
                this.emitLine("- ", string);
            }
            this.unindent();
        }
    }

    private void emitOpenAPI_description(String description) {
        this.emitLine("description: \"", description, "\"");
    }

    private List<Property> getReleasedProperties(VmodlObject object) {
        List<Property> allProperties = object.getPropertyListWithOverrides();
        ArrayList<Property> properties = new ArrayList<Property>(allProperties.size());
        for (Property property : allProperties) {
            if (!OpenAPI3.shouldEmit(property)) continue;
            properties.add(property);
        }
        return properties;
    }

    private void emitMoIdParameter() {
        this.pushIndent();
        this.emitLine("moId", ":");
        this.emitLine(INDENT, "name: ", "moId");
        this.emitLine("in: path");
        this.emitLine("required: true");
        this.emitLine("schema:", INDENT);
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
    }

    private void emitNamespaceParameter() {
        this.pushIndent();
        this.emitLine("urlNamespace", ":");
        this.emitLine(INDENT, "name: ", "urlNamespace");
        this.emitLine("in: path");
        this.emitLine("required: true");
        this.emitLine("schema:", INDENT);
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
    }

    private void emitVersionParameter() {
        this.pushIndent();
        this.emitLine("urlVersion", ":");
        this.emitLine(INDENT, "name: ", "urlVersion");
        this.emitLine("in: path");
        this.emitLine("required: true");
        this.emitLine("schema:", INDENT);
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
    }

    private static String getJsonName(VmodlObject object) {
        String jsonName = object.getCustomName();
        if (jsonName == null) {
            jsonName = OpenAPI3.getJsonPackagePrefix(object) + object.getFullClassName();
            object.setCustomName(jsonName);
        }
        return jsonName;
    }

    private static String getJsonPackagePrefix(VmodlObject object) {
        String package_ = object.getPackage();
        if (package_.isEmpty()) {
            return "";
        }
        String remap = NS_REMAP.get(package_);
        return (remap != null ? remap : package_) + ".";
    }

    private static String calcHash(ManagedObject managedObject) {
        MessageDigest digest = Versions.initDigest();
        digest.update(VmodlDecl.toBytes(OpenAPI3.getJsonName(managedObject)));
        byte[] result = digest.digest();
        return String.format("%02x%02x", result[0], result[1]);
    }

    static String getNameHashCombo(String name, String hash) {
        return name + "_" + hash;
    }

    static {
        NS_REMAP.put("vmodl", CORE_NAMESPACE);
        NS_REMAP.put("vmodl.fault", "core.fault");
        NS_REMAP.put("vmodl.query", "query");
        NS_REMAP.put("vmodl.reflect", "\u0000");
        NS_REMAP.put("vmodl.infra", "\u0000");
        METHOD_ARRAY = new Method[0];
        PROPERTY_ARRAY = new Property[0];
        CUSTOM_OBJECT_ARRAY = new CustomObject[0];
        NO_FAULTS = new ArrayList<DataObject>();
    }

    private static class Primitive {
        String typeName;
        VmodlDecl.TypeId typeId;

        Primitive(String typeName_, VmodlDecl.TypeId typeId_) {
            this.typeName = typeName_;
            this.typeId = typeId_;
        }
    }

    static enum OP_ID_FLAVOR {
        DEFAULT,
        WITH_HASH,
        OPTIMIZED;

    }

    private class MethodParameters
    extends CustomObject {
        private final List<Parameter> _parameters;

        MethodParameters(String name, List<Parameter> parameters) {
            super(name);
            this._parameters = parameters;
        }

        @Override
        void generate() {
            OpenAPI3.this.emitSchemaObject(this._name, null, this._parameters);
        }
    }

    private abstract class CustomObject {
        protected final String _name;

        CustomObject(String name) {
            this._name = name;
        }

        abstract void generate();
    }
}

