/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap.legacy;

import emitters.ApiFilter;
import emitters.ObjectRegistry;
import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.generators.joap.legacy.BaseObjects;
import emitters.generators.joap.legacy.CoreObjectsEx;
import emitters.generators.joap.legacy.GroupObjects;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.Field;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class OpenAPI3_sliced
extends VmodlEmitter {
    private static final String SLICE_SUFFIX = "_s";
    private static final String GROUP_SUFFIX = "_g";
    private static final String METHOD_INPUT_SUFFIX = "_i";
    private final ApiFilter _filter = ApiFilter.getReleasedAPIsFilter();
    private final String _folder;
    private String _namespace;
    private final Set<VmodlObject> _externalNsObjects = new HashSet<VmodlObject>();
    private final Set<VmodlObject> _fileTags = new HashSet<VmodlObject>();
    private List<ManagedObject> _queuedObjects = new ArrayList<ManagedObject>();
    private List<ManagedObject> _emittedMoObjects = new ArrayList<ManagedObject>();
    private List<DataObject> _emittedDoObjects = new ArrayList<DataObject>();
    private List<Enum> _emittedEnumObjects = new ArrayList<Enum>();
    private boolean _hasCompSchemas;
    private boolean _hasPaths;
    private boolean _forceLocalRefs;
    private final BaseObjects _baseObjects = new BaseObjects();
    private final CoreObjectsEx _coreObjectsEx = new CoreObjectsEx();
    private final GroupObjects _groupObjects = new GroupObjects();
    private VmodlObject _any;
    private VmodlObject _managedObjectReference;
    private VmodlObject _dataObject;
    private VmodlObject _dynamicData;
    private VmodlObject _methodFault;
    private VmodlObject _runtimeFault;
    private VmodlObject _managedObjectNotFound;

    public OpenAPI3_sliced(Map<String, String> options, String folder) {
        this._folder = folder;
        this._namespace = Versions.getTargetVersion().getNamespace();
        this._any = ObjectRegistry.getObject(Utils.AnyClassName);
        this._managedObjectReference = ObjectRegistry.getObject(Utils.ManagedObjectReferenceClassName);
        this._dataObject = ObjectRegistry.getObject(Utils.DataObjectClassName);
        this._dynamicData = ObjectRegistry.getObject(Utils.DynamicDataClassName);
        this._methodFault = ObjectRegistry.getObject(Utils.MethodFaultClassName);
        this._runtimeFault = ObjectRegistry.getObject(Utils.RuntimeFaultClassName);
        this._managedObjectNotFound = ObjectRegistry.getObject(Utils.ManagedObjectNotFoundClassName);
        this.setIndentSpaces("  ");
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        for (VmodlObject obj : objects) {
            this.emitObj(obj);
        }
        HashSet<VmodlObject> exEmitted = new HashSet<VmodlObject>();
        HashSet<VmodlObject> exToEmit = new HashSet<VmodlObject>(this._externalNsObjects);
        while (!exToEmit.isEmpty()) {
            for (VmodlObject obj : exToEmit) {
                this.emitObj(obj);
                exEmitted.add(obj);
            }
            exToEmit = new HashSet<VmodlObject>(this._externalNsObjects);
            exToEmit.removeAll(exEmitted);
        }
        this.emitNsPaths();
        this.emitNsAll();
    }

    private void emitObj(VmodlObject obj) {
        if (!this._filter.shouldEmit(obj)) {
            return;
        }
        this.beginFileForObject(obj);
        this.dispatchEmitObject(obj, true);
        this.emitFileTags();
        this.endFile();
    }

    private String tagName(VmodlObject obj) {
        return obj.getWsdlName();
    }

    private String tagDescription(VmodlObject obj) {
        return obj.getQualifiedVmodlType();
    }

    private void emitFileTags() {
        if (this._fileTags.isEmpty()) {
            return;
        }
        this.emitLine("tags:", INDENT);
        for (VmodlObject obj : this._fileTags) {
            this.emitLine("- name: " + OpenAPI3_sliced.qq(this.tagName(obj)));
            this.emitLine("\tdescription: ", OpenAPI3_sliced.qq(this.tagDescription(obj)));
        }
        this.unindent();
    }

    private void emitNsPaths() {
        this.beginFile(this._namespace.replace(".", "/") + "/" + this._namespace + "_paths.yaml");
        String title = this._namespace + " namespace paths";
        this.emitHeader(title, Versions.getTargetVersion().getVmodlName());
        for (ManagedObject mo : this._emittedMoObjects) {
            this.emitMoPaths(mo);
        }
        this.emitFileTags();
        this.endFile();
    }

    private void emitNsAll() {
        this._forceLocalRefs = true;
        this.beginFile(this._namespace + "_all.yaml");
        String title = this._namespace + " namespace paths";
        this.emitHeader(title, Versions.getTargetVersion().getVmodlName());
        for (VmodlObject vmodlObject : this._baseObjects) {
            if (vmodlObject.getKind() != VmodlObject.Kind.DataObject || this._emittedDoObjects.contains(vmodlObject)) continue;
            this.emitDoImpl((DataObject)vmodlObject, false);
        }
        for (Enum enum_ : this._emittedEnumObjects) {
            this.emitEnumImpl(enum_);
        }
        for (DataObject dataObject : this._emittedDoObjects) {
            this.emitDoImpl(dataObject, false);
        }
        VmodlObject propertyCollector = ObjectRegistry.getObject("vmodl.query.PropertyCollector");
        if (propertyCollector != null) {
            this._emittedMoObjects.add((ManagedObject)propertyCollector);
        }
        for (ManagedObject mo : this._emittedMoObjects) {
            this.emitMoMethodInputs(mo);
        }
        for (ManagedObject mo : this._emittedMoObjects) {
            this.emitMoPaths(mo);
        }
        this.emitFileTags();
        this.endFile();
        this._forceLocalRefs = false;
    }

    private void emitMo(ManagedObject obj, boolean topLevel) {
        if (topLevel) {
            this.emitHeader(obj, "ManagedObject");
        }
        this.emitNestedObjects(obj);
        this._queuedObjects.add(obj);
        if (!topLevel) {
            return;
        }
        for (ManagedObject mo : this._queuedObjects) {
            if (this.isExternalNsObj(mo)) continue;
            this.emitMoMethodInputs(mo);
        }
        for (ManagedObject mo : this._queuedObjects) {
            if (this.isExternalNsObj(mo)) continue;
            this.emitMoPaths(mo);
            this._emittedMoObjects.add(mo);
        }
        this._queuedObjects.clear();
    }

    private void emitMoMethodInputs(ManagedObject obj) {
        TreeSet<Method> methods = new TreeSet<Method>(new MethodComparator());
        methods.addAll(obj.getMethodList());
        for (Method meth : methods) {
            if (!this._filter.shouldEmit(meth) || !this.hasUnfilteredField(meth.getParameterList())) continue;
            this.pushIndent();
            this.emitCompSchemas();
            this.emitMethodInputHeader(meth);
            this.emitDoSliceFields(meth.getParameterList());
            this.emitGap();
            this.popIndent();
        }
    }

    private void emitMoPaths(ManagedObject obj) {
        this.emitMoProperties(obj);
        this.emitMethods(obj);
    }

    private void emitMoProperties(VmodlObject obj) {
        for (Property prop : obj.getPropertyListWithOverrides()) {
            if (!this._filter.shouldEmit(prop)) continue;
            VmodlDecl decl = prop.getDecl();
            String opId = obj.getWsdlName() + prop.getWsdlName();
            this.pushIndent();
            this.emitPaths();
            this.emitMethodHeader("get", obj, prop.getName(), "ManagedProperty", opId);
            this.emitLine("responses:", INDENT);
            this.emitResult(decl);
            this.emitFaultResponse("404", this._managedObjectNotFound);
            this.emitFaultResponse("500", this._runtimeFault);
            this.emitGap();
            this.popIndent();
        }
    }

    private void emitMethodHeader(String verb, VmodlObject obj, String method, String type, String operationId) {
        this.emitLine("/", obj.getQualifiedVmodlType().replace(".", "/"), "/{mo_id}/", method, ":");
        this.indent();
        this.pushIndent();
        this.emitLine("summary: ", OpenAPI3_sliced.qq(obj.getName() + " " + method + " " + type));
        this.emitLine("parameters:", INDENT);
        this.emitLine("- name: " + OpenAPI3_sliced.qq("mo_id"), INDENT);
        this.emitLine("in: path");
        this.emitLine("description: ", OpenAPI3_sliced.qq("Managed object Id"));
        this.emitLine("required: true");
        this.emitLine("schema:");
        this.emitLine("\ttype: string");
        this.popIndent();
        this.emitLine(verb + ":", INDENT);
        this.emitLine("tags: [", OpenAPI3_sliced.qq(this.tagName(obj)), "]");
        this.emitLine("operationId: ", operationId);
        this.emitLine("description: ", OpenAPI3_sliced.qq(obj.getName() + " " + method + " " + type));
        this.emitMethodSecurity();
        this._fileTags.add(obj);
    }

    private void emitMethodSecurity() {
        this.emitLine("security: []");
    }

    private void emitResult(VmodlDecl decl) {
        this.pushIndent();
        this.emitLine("'200':", INDENT);
        this.emitLine("description: ", "success");
        if (decl.getTypeId() != VmodlDecl.TypeId.VOID) {
            this.emitLine("content:", INDENT);
            this.emitLine(OpenAPI3_sliced.qq("application/json") + ":", INDENT);
            this.emitLine("schema:", INDENT);
            this.emitDecl(decl);
        }
        this.popIndent();
    }

    void emitWrapDecl(VmodlDecl decl) {
        this.pushIndent();
        if (decl.isPrimitive()) {
            this.emitLine("type: object");
            this.emitLine("properties:", INDENT);
            this.emitLine("value:", INDENT);
        }
        this.emitDecl(decl);
        this.popIndent();
    }

    private void emitFaultResponse(String code, VmodlObject obj) {
        this.pushIndent();
        this.emitLine(OpenAPI3_sliced.qs(code) + ":", INDENT);
        this.emitLine("description: ", OpenAPI3_sliced.qq(obj.getName()));
        this.emitLine("content:", INDENT);
        this.emitLine(OpenAPI3_sliced.qq("application/json") + ":", INDENT);
        this.emitLine("schema:", INDENT);
        this.emitRefRemap(obj);
        this.popIndent();
    }

    private void emitMethodParams(Method meth) {
        List<Parameter> params = meth.getParameterList();
        if (params.size() == 0 || !this.hasUnfilteredField(params)) {
            return;
        }
        this.pushIndent();
        this.emitLine("requestBody:", INDENT);
        this.emitLine("required: true");
        this.emitLine("content:", INDENT);
        this.emitLine(OpenAPI3_sliced.qq("application/json") + ":", INDENT);
        this.emitLine("schema:", INDENT);
        this.emitMethodInputRef(meth);
        this.popIndent();
    }

    private void emitMethodInputRef(Method meth) {
        VmodlObject cont = meth.getContainer().getRootContainer();
        String mname = this.getMethodInputTypeName(meth);
        this.emitLine("$ref: ", this.makeRef(this.getRefFileNameRemap(cont), mname));
    }

    private void emitMethods(ManagedObject obj) {
        TreeSet<Method> methods = new TreeSet<Method>(new MethodComparator());
        methods.addAll(obj.getMethodList());
        for (Method meth : methods) {
            if (!this._filter.shouldEmit(meth)) continue;
            this.pushIndent();
            this.emitPaths();
            this.emitMethodHeader("post", obj, meth.getName(), "ManagedMethod", meth.getWsdlName());
            this.emitMethodParams(meth);
            this.emitLine("responses:", INDENT);
            this.emitResult(meth.getReturnDecl());
            this.emitFaultResponse("404", this._managedObjectNotFound);
            this.emitFaultResponse("500", this._runtimeFault);
            int faultCode = 490;
            for (VmodlObject vmodlObject : meth.getFaultList()) {
                if (!this._filter.shouldEmit(vmodlObject)) continue;
                this.emitFaultResponse(Integer.toString(faultCode), vmodlObject);
                --faultCode;
            }
            this.emitGap();
            this.popIndent();
        }
    }

    private void emitEnum(Enum obj, boolean topLevel) {
        if (topLevel) {
            this.emitHeader(obj, "EnumObject");
        }
        this._emittedEnumObjects.add(obj);
        this.emitEnumImpl(obj);
    }

    private void emitEnumImpl(Enum obj) {
        this.pushIndent();
        this.emitCompSchemas();
        this.emitLine(obj.getWsdlName() + ":", INDENT);
        this.emitLine("type: string");
        this.emitLine("enum:", INDENT);
        List<Version> vers = obj.getValueVersionList();
        List<String> values = obj.getValueList();
        for (int i = 0; i < values.size(); ++i) {
            Version ver = vers.get(i);
            if (ver != null && !this._filter.shouldEmit(ver)) continue;
            this.emitLine("- ", OpenAPI3_sliced.qq(values.get(i)));
        }
        this.popIndent();
    }

    private void emitEnumExample(Enum obj) {
        List<Version> vers = obj.getValueVersionList();
        List<String> values = obj.getValueList();
        for (int i = 0; i < values.size(); ++i) {
            Version ver = vers.get(i);
            if (ver != null && !this._filter.shouldEmit(ver)) continue;
            this.emitPartial(OpenAPI3_sliced.qq(values.get(i)));
            return;
        }
    }

    private void emitDo(DataObject obj, boolean topLevel) {
        if (topLevel) {
            this.emitHeader(obj, "DataObject");
        }
        this.emitNestedObjects(obj);
        this._emittedDoObjects.add(obj);
        this.emitDoImpl(obj, topLevel);
    }

    private void emitDoAsString(DataObject obj, String format, String example, boolean topLevel) {
        this.emitLine(obj.getWsdlName() + ":", INDENT);
        this.emitLine("description: ", this.makeDescription(obj, topLevel));
        this.emitLine("example: ", OpenAPI3_sliced.qq(example));
        this.emitLine("type: string");
        if (!format.isEmpty()) {
            this.emitLine("format: ", format);
        }
        this.unindent();
    }

    private boolean emitSpecialDo(DataObject obj, boolean topLevel) {
        if (obj == this._any) {
            this.emitAnySchema(obj, topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.Binary")) {
            this.emitDoAsString(obj, "byte", "QmluYXJ5REF0YQ==", topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.DateTime")) {
            this.emitDoAsString(obj, "date-time", "1985-04-28T23:20:50.52Z", topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.MethodName")) {
            this.emitDoAsString(obj, "", "methodname", topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.PropertyPath")) {
            this.emitDoAsString(obj, "", "property.path", topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.TypeName")) {
            this.emitDoAsString(obj, "", "typename", topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.URI")) {
            this.emitDoAsString(obj, "", "http://localhost/sdk", topLevel);
            return true;
        }
        return false;
    }

    private void emitDoImpl(DataObject obj, boolean topLevel) {
        this.pushIndent();
        this.emitCompSchemas();
        if (!this.emitSpecialDo(obj, topLevel)) {
            this.emitDoSlice(obj, topLevel);
            if (this.isGroupObject(obj)) {
                this.emitDoGroup(obj, topLevel);
            }
            this.emitDoSchema(obj, topLevel);
        }
        this.emitGap();
        this.popIndent();
    }

    private void emitDoSlice(DataObject obj, boolean topLevel) {
        this.pushIndent();
        this.emitDoHeader(obj, SLICE_SUFFIX, topLevel);
        this.emitDoSliceFields(obj.getPropertyListWithOverrides());
        this.popIndent();
    }

    private void emitDoSliceExample(DataObject obj) {
        this.emitPartial("{");
        this.emitDoSliceFieldsExample(obj.getPropertyListWithOverrides());
        this.emitPartial("}");
    }

    private boolean hasUnfilteredField(Collection<? extends Field> fields) {
        for (Field field : fields) {
            if (!this._filter.shouldEmit(field)) continue;
            return true;
        }
        return false;
    }

    private void emitDoSliceFields(Collection<? extends Field> fields) {
        boolean hasProps = false;
        ArrayList<String> required = new ArrayList<String>();
        this.pushIndent();
        for (Field field : fields) {
            VmodlDecl decl;
            if (!this._filter.shouldEmit(field)) continue;
            if (!hasProps) {
                this.emitLine("properties:", INDENT);
                hasProps = true;
            }
            if (!(decl = field.getDecl()).isOptional()) {
                required.add(field.getName());
            }
            this.pushIndent();
            this.emitLine(field.getName() + ":", INDENT);
            this.emitDecl(decl);
            this.popIndent();
        }
        if (!hasProps) {
            this.emitLine("properties: {}");
        }
        this.popIndent();
        if (!required.isEmpty()) {
            this.emitLine("required: [", OpenAPI3_sliced.join(required), "]");
        }
    }

    private void emitDoSliceFieldsExample(Collection<? extends Field> fields) {
        boolean firstProp = true;
        for (Field field : fields) {
            VmodlDecl decl;
            if (!this._filter.shouldEmit(field) || (decl = field.getDecl()).isOptional()) continue;
            if (!firstProp) {
                this.emitPartial(", ");
            } else {
                firstProp = false;
            }
            this.emitPartial(OpenAPI3_sliced.qq(field.getName()), ":");
            this.emitDeclExample(decl);
        }
    }

    private void emitDoSchema(DataObject obj, boolean topLevel) {
        this.pushIndent();
        this.emitDoHeader(obj, "", topLevel);
        if (obj == this._any) {
            throw new RuntimeException("Unexpected object type : " + obj.getQualifiedVmodlType());
        }
        this.emitDoSchemaFields(obj);
        this.popIndent();
    }

    private void emitDoGroupExample(DataObject obj) {
        this.emitPartial("{");
        String propName = this.toPropName(obj);
        this.emitPartial(OpenAPI3_sliced.qq(propName) + ":");
        this.emitDoSliceExample(obj);
        this.emitPartial("}");
    }

    private void emitDoSchemaExample(DataObject obj) {
        this.emitPartial("{");
        if (obj == this._any) {
            this.emitAnyFieldsExample();
        } else {
            this.emitDoSchemaFieldsExample(obj);
        }
        this.emitPartial("}");
    }

    private void emitDoSchemaFields(DataObject obj) {
        this.emitLine("properties:", INDENT);
        List<String> required = this.emitDoBaseSliceFields(obj);
        if (this.isGroupObject(obj)) {
            required.add(this.emitGroupProperty(obj));
        } else {
            this.emitDoChildSliceFields(obj);
        }
        this.unindent();
        if (!required.isEmpty()) {
            this.emitLine("required: [", OpenAPI3_sliced.join(required), "]");
        }
    }

    private void emitDoSchemaFieldsExample(DataObject obj) {
        boolean hasBaseFields = this.emitDoBaseSliceFieldsExample(obj);
        if (this.isGroupObject(obj)) {
            if (hasBaseFields) {
                this.emitPartial(",");
            }
            this.emitGroupPropertyExample(obj);
        }
    }

    private void emitAnySchema(DataObject obj, boolean topLevel) {
        if (obj != this._any) {
            throw new RuntimeException("Unexpected object type : " + obj.getQualifiedVmodlType());
        }
        this.emitTypeKindEnum();
        this.pushIndent();
        this.emitDoHeader(obj, "", topLevel);
        this.emitAnyFields(obj);
        this.popIndent();
    }

    private void emitTypeKindEnum() {
        this.pushIndent();
        this.emitLine("TypeKind:", INDENT);
        this.emitLine("type: string");
        this.emitLine("enum:", INDENT);
        this.emitLine("- boolean");
        this.emitLine("- byte");
        this.emitLine("- short");
        this.emitLine("- int");
        this.emitLine("- long");
        this.emitLine("- float");
        this.emitLine("- double");
        this.emitLine("- string");
        this.emitLine("- datetime");
        this.emitLine("- typename");
        this.emitLine("- methodname");
        this.emitLine("- proppath");
        this.emitLine("- uri");
        this.emitLine("- binary");
        this.emitLine("- dataobject");
        this.emitLine("- moref");
        this.emitLine("- fault");
        this.emitLine("- array");
        this.popIndent();
    }

    private void emitAnyFields(DataObject obj) {
        this.emitLine("properties:", INDENT);
        this.emitLine("kind:");
        this.emitLine("\t$ref: '#/components/schemas/TypeKind'");
        this.emitLine("elementKind:");
        this.emitLine("\t$ref: '#/components/schemas/TypeKind'");
        this.emitLine("boolean:");
        this.emitLine("\ttype: ", "boolean");
        this.emitLine("integer:");
        this.emitLine("\ttype: ", "integer");
        this.emitLine("\tformat: ", "int64");
        this.emitLine("number:");
        this.emitLine("\ttype: ", "number");
        this.emitLine("\tformat: ", "double");
        this.emitLine("string:");
        this.emitLine("\ttype: ", "string");
        this.emitLine("binary:");
        this.emitLine("\ttype: ", "string");
        this.emitLine("\tformat: ", "byte");
        this.emitLine("moref:", INDENT);
        this.emitRef(this._managedObjectReference);
        this.unindent();
        this.emitLine("dataobject:", INDENT);
        this.emitRefRemap(this._dataObject);
        this.unindent();
        this.emitLine("fault:", INDENT);
        this.emitRefRemap(this._methodFault);
        this.unindent();
        this.pushIndent();
        this.emitLine("booleanArray:", INDENT);
        this.emitLine("type: array");
        this.emitLine("items:", INDENT);
        this.emitLine("type: ", "boolean");
        this.popIndent();
        this.pushIndent();
        this.emitLine("integerArray:", INDENT);
        this.emitLine("type: array");
        this.emitLine("items:", INDENT);
        this.emitLine("type: ", "integer");
        this.emitLine("format: ", "int64");
        this.popIndent();
        this.pushIndent();
        this.emitLine("numberArray:", INDENT);
        this.emitLine("type: array");
        this.emitLine("items:", INDENT);
        this.emitLine("type: ", "number");
        this.emitLine("format: ", "double");
        this.popIndent();
        this.pushIndent();
        this.emitLine("stringArray:", INDENT);
        this.emitLine("type: array");
        this.emitLine("items:", INDENT);
        this.emitLine("type: ", "string");
        this.popIndent();
        this.pushIndent();
        this.emitLine("binaryArray:", INDENT);
        this.emitLine("type: array");
        this.emitLine("items:", INDENT);
        this.emitLine("type: ", "string");
        this.emitLine("format: ", "byte");
        this.popIndent();
        this.pushIndent();
        this.emitLine("morefArray:", INDENT);
        this.emitLine("type: array");
        this.emitLine("items:", INDENT);
        this.emitRef(this._managedObjectReference);
        this.popIndent();
        this.pushIndent();
        this.emitLine("dataobjectArray:", INDENT);
        this.emitLine("type: array");
        this.emitLine("items:", INDENT);
        this.emitRefRemap(this._dataObject);
        this.popIndent();
        this.pushIndent();
        this.emitLine("faultArray:", INDENT);
        this.emitLine("type: array");
        this.emitLine("items:", INDENT);
        this.emitRefRemap(this._methodFault);
        this.popIndent();
        this.unindent();
    }

    private void emitAnyFieldsExample() {
        this.emitPartial(OpenAPI3_sliced.qq("kind"), ":", OpenAPI3_sliced.qq("string"), ",");
        this.emitPartial(OpenAPI3_sliced.qq("string"), ": ", OpenAPI3_sliced.qq("any_string"));
    }

    private String emitSliceProperty(VmodlObject obj) {
        String propName = this.toPropName(obj);
        this.emitLine(propName + ":", INDENT);
        this.emitRefRemap(obj, SLICE_SUFFIX);
        this.unindent();
        return propName;
    }

    private void emitSlicePropertyExample(VmodlObject obj) {
        String propName = this.toPropName(obj);
        this.emitPartial(OpenAPI3_sliced.qq(propName) + ":");
        this.emitDoSliceExample((DataObject)obj);
    }

    private void emitGroupPropertyExample(VmodlObject obj) {
        String propName = this.toPropName(obj);
        this.emitPartial(OpenAPI3_sliced.qq(propName) + ":");
        this.emitDoGroupExample((DataObject)obj);
    }

    private String emitGroupProperty(VmodlObject obj) {
        String propName = this.toPropName(obj);
        this.emitLine(propName + ":", INDENT);
        this.emitRefRemap(obj, GROUP_SUFFIX);
        this.unindent();
        return propName;
    }

    private List<String> emitDoBaseSliceFields(DataObject obj) {
        ArrayList<String> required = new ArrayList<String>();
        List<VmodlObject> baseObjs = obj.getBaseObjectList();
        if (!this.isGroupObject(obj)) {
            baseObjs.add(obj);
        }
        for (VmodlObject baseObj : baseObjs) {
            if (baseObj == this._dynamicData || baseObj == this._dataObject) continue;
            required.add(this.emitSliceProperty(baseObj));
        }
        return required;
    }

    private boolean emitDoBaseSliceFieldsExample(DataObject obj) {
        List<VmodlObject> baseObjs = obj.getBaseObjectList();
        if (!this.isGroupObject(obj)) {
            baseObjs.add(obj);
        }
        boolean firstProp = true;
        for (VmodlObject baseObj : baseObjs) {
            if (baseObj == this._dynamicData || baseObj == this._dataObject) continue;
            if (!firstProp) {
                this.emitPartial(", ");
            } else {
                firstProp = false;
            }
            this.emitSlicePropertyExample(baseObj);
        }
        return !firstProp;
    }

    private int emitDoChildSliceFields(DataObject obj) {
        int count = 0;
        ArrayList<VmodlObject> descendentsList = new ArrayList<VmodlObject>();
        this.getAllDescendents(obj, descendentsList);
        for (VmodlObject descendent : descendentsList) {
            if (!this._filter.shouldEmit(descendent) || descendent.getKind() != VmodlObject.Kind.DataObject || this._coreObjectsEx.contains(descendent) || descendent == this._dynamicData) continue;
            if (this.isGroupObject(descendent)) {
                this.emitGroupProperty(descendent);
            } else {
                this.emitSliceProperty(descendent);
            }
            ++count;
        }
        return count;
    }

    private void getAllDescendents(VmodlObject object, List<VmodlObject> descendentsList) {
        Set<VmodlObject> descendents = object.getDescendents();
        descendentsList.addAll(descendents);
        for (VmodlObject descendent : descendents) {
            if (this._groupObjects.contains(descendent)) continue;
            this.getAllDescendents(descendent, descendentsList);
        }
    }

    private void emitDoGroup(DataObject obj, boolean topLevel) {
        this.pushIndent();
        this.emitDoHeader(obj, GROUP_SUFFIX, topLevel);
        this.emitDoGroupFields(obj);
        this.popIndent();
    }

    private void emitDoGroupFields(DataObject obj) {
        this.emitLine("properties:", INDENT);
        String propName = this.emitSliceProperty(obj);
        this.emitDoChildSliceFields(obj);
        this.unindent();
        this.emitLine("required: [", propName, "]");
    }

    private void emitDecl(VmodlDecl decl) {
        if (decl.isArray()) {
            this.emitLine("type: array");
            this.emitLine("items:", INDENT);
        }
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                this.emitLine("type: ", "boolean");
                break;
            }
            case BYTE: {
                this.emitLine("type: ", "integer");
                this.emitLine("format: ", "int32");
                break;
            }
            case SHORT: {
                this.emitLine("type: ", "integer");
                this.emitLine("format: ", "int32");
                break;
            }
            case INT: {
                this.emitLine("type: ", "integer");
                this.emitLine("format: ", "int32");
                break;
            }
            case LONG: {
                this.emitLine("type: ", "integer");
                this.emitLine("format: ", "int64");
                break;
            }
            case FLOAT: {
                this.emitLine("type: ", "number");
                this.emitLine("format: ", "float");
                break;
            }
            case DOUBLE: {
                this.emitLine("type: ", "number");
                this.emitLine("format: ", "double");
                break;
            }
            case STRING: {
                this.emitLine("type: ", "string");
                break;
            }
            case DATETIME: {
                this.emitRef(ObjectRegistry.getObject("vmodl.DateTime"));
                break;
            }
            case TYPENAME: {
                this.emitRef(ObjectRegistry.getObject("vmodl.TypeName"));
                break;
            }
            case METHODNAME: {
                this.emitRef(ObjectRegistry.getObject("vmodl.MethodName"));
                break;
            }
            case PROPPATH: {
                this.emitRef(ObjectRegistry.getObject("vmodl.PropertyPath"));
                break;
            }
            case URI: {
                this.emitRef(ObjectRegistry.getObject("vmodl.URI"));
                break;
            }
            case BINARY: {
                this.emitRef(ObjectRegistry.getObject("vmodl.Binary"));
                break;
            }
            case ANY: {
                this.emitRefRemap(this._any);
                break;
            }
            case VOID: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
            case ENUM: {
                VmodlObject enumobj = decl.getObject();
                this.emitRef(enumobj);
                break;
            }
            case MANAGED: {
                this.emitRef(this._managedObjectReference);
                break;
            }
            case DATA: {
                VmodlObject obj = decl.getObject();
                if (obj != null) {
                    this.emitRefRemap(obj);
                    break;
                }
                throw new RuntimeException("Decl without object type: " + (Object)((Object)decl.getTypeId()));
            }
            default: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
        }
    }

    private void emitDeclExample(VmodlDecl decl) {
        if (decl.isArray()) {
            this.emitPartial("[");
        }
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                this.emitPartial("false");
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                this.emitPartial("42");
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                this.emitPartial("3.14");
                break;
            }
            case STRING: {
                this.emitPartial(OpenAPI3_sliced.qq("string"));
                break;
            }
            case DATETIME: {
                this.emitPartial(OpenAPI3_sliced.qq("1985-04-28T23:20:50.52Z"));
                break;
            }
            case TYPENAME: {
                this.emitPartial(OpenAPI3_sliced.qq("typename"));
                break;
            }
            case METHODNAME: {
                this.emitPartial(OpenAPI3_sliced.qq("methodname"));
                break;
            }
            case PROPPATH: {
                this.emitPartial(OpenAPI3_sliced.qq("propname"));
                break;
            }
            case URI: {
                this.emitPartial(OpenAPI3_sliced.qq("http://localhost/api"));
                break;
            }
            case BINARY: {
                this.emitPartial(OpenAPI3_sliced.qq("QmluYXJ5REF0YQ=="));
                break;
            }
            case ANY: {
                this.emitDoSchemaExample((DataObject)this._any);
                break;
            }
            case VOID: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
            case ENUM: {
                VmodlObject enumobj = decl.getObject();
                this.emitEnumExample((Enum)enumobj);
                break;
            }
            case MANAGED: {
                this.emitDoSchemaExample((DataObject)this._managedObjectReference);
                break;
            }
            case DATA: {
                if (decl.isArray()) break;
                VmodlObject obj = decl.getObject();
                if (obj != null) {
                    this.emitDoSchemaExample((DataObject)obj);
                    break;
                }
                throw new RuntimeException("Decl without object type: " + (Object)((Object)decl.getTypeId()));
            }
            default: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
        }
        if (decl.isArray()) {
            this.emitPartial("]");
        }
    }

    private void emitNestedObjects(VmodlObject obj) {
        TreeSet<VmodlObject> nestedObjects = new TreeSet<VmodlObject>(new VmodlObjectComparator());
        nestedObjects.addAll(obj.getNestedList());
        for (VmodlObject nested : nestedObjects) {
            if (!this._filter.shouldEmit(nested)) continue;
            this.dispatchEmitObject(nested, false);
        }
    }

    private void dispatchEmitObject(VmodlObject obj, boolean topLevel) {
        switch (obj.getKind()) {
            case DataObject: {
                this.emitDo((DataObject)obj, topLevel);
                break;
            }
            case Enum: {
                this.emitEnum((Enum)obj, topLevel);
                break;
            }
            case ManagedObject: {
                this.emitMo((ManagedObject)obj, topLevel);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected VmodlObject Kind");
            }
        }
    }

    private void emitHeader(VmodlObject obj, String decltype) {
        Version version = obj.getVersion();
        String title = obj.getName() + " " + decltype;
        String ver = version != null ? version.getVmodlName() : "None";
        this.emitHeader(title, ver);
    }

    private void emitHeader(String title, String version) {
        this.pushIndent();
        this.emitLine("openapi: 3.0.0");
        this.emitLine("servers:", INDENT);
        this.emitLine("- url: http://localhost/sdk", INDENT);
        this.emitLine("description: Joap server");
        this.popIndent();
        this.pushIndent();
        this.emitLine("info:", INDENT);
        this.emitLine("title: ", title);
        this.emitLine("version: ", version);
        this.emitLine("description: ", "Joap API");
        this.emitLine("contact:", INDENT);
        this.emitLine("name: ", "VMware, Inc.");
        this.popIndent();
        this.emitGap();
        this._hasCompSchemas = false;
        this._hasPaths = false;
        this._fileTags.clear();
    }

    private void emitCompSchemas() {
        if (!this._hasCompSchemas) {
            this.emitLine("components:");
            this.emitLine("\tschemas:");
            this._hasCompSchemas = true;
        }
        this.indent();
        this.indent();
    }

    private void emitPaths() {
        if (!this._hasPaths) {
            this.emitLine("paths:");
            this._hasPaths = true;
        }
        this.indent();
    }

    private String getRefFileName(VmodlObject obj) {
        return this.getObjectFileName(obj.getRootContainer());
    }

    private String getRefFileNameRemap(VmodlObject obj) {
        return this.getObjectFileNameRemap(obj.getRootContainer());
    }

    private String makeRef(String fname, String name) {
        String relFname = this.relativePath(this.fullFname(fname), this.getFilename());
        return OpenAPI3_sliced.qs(relFname + "#/components/schemas/" + name);
    }

    private String makeRef(VmodlObject obj, String suffix) {
        String fname = this.getRefFileName(obj);
        return this.makeRef(fname, obj.getWsdlName() + suffix);
    }

    private String makeRefRemap(VmodlObject obj, String suffix) {
        String fname = this.getRefFileNameRemap(obj);
        return this.makeRef(fname, obj.getWsdlName() + suffix);
    }

    private void emitRef(VmodlObject obj, String suffix) {
        this.emitLine("$ref: ", this.makeRef(obj, suffix));
    }

    private void emitRef(VmodlObject obj) {
        this.emitRef(obj, "");
    }

    private void emitRefRemap(VmodlObject obj, String suffix) {
        if (this.isExternalNsObj(obj)) {
            this._externalNsObjects.add(obj.getRootContainer());
        }
        this.emitLine("$ref: ", this.makeRefRemap(obj, suffix));
    }

    private void emitRefRemap(VmodlObject obj) {
        this.emitRefRemap(obj, "");
    }

    private boolean isExternalNsObj(VmodlObject obj) {
        return !obj.getVersion().getNamespace().equals(this._namespace);
    }

    private void emitDoHeader(VmodlObject obj, String suffix, boolean topLevel) {
        this.emitLine(obj.getWsdlName() + suffix + ":", INDENT);
        this.emitLine("description: ", this.makeDescription(obj, topLevel));
        this.emitPartial("example: ");
        if (suffix.equals(SLICE_SUFFIX)) {
            this.emitDoSliceExample((DataObject)obj);
        } else if (suffix.equals(GROUP_SUFFIX)) {
            this.emitDoGroupExample((DataObject)obj);
        } else {
            this.emitDoSchemaExample((DataObject)obj);
        }
        this.emitGap();
        this.emitLine("type: object");
    }

    private String getMethodInputTypeName(Method meth) {
        return meth.getWsdlName() + METHOD_INPUT_SUFFIX;
    }

    private int emitMethodInputHeader(Method meth) {
        this.emitLine(this.getMethodInputTypeName(meth) + ":", INDENT);
        this.emitLine("description: ", this.makeDescription(meth));
        this.emitPartial("example: {");
        this.emitDoSliceFieldsExample(meth.getParameterList());
        this.emitLine("}");
        this.emitLine("type: object");
        return 1;
    }

    private boolean isGroupObject(VmodlObject obj) {
        return this._groupObjects.contains(obj);
    }

    private String makeDescription(VmodlObject obj, boolean topLevel) {
        VmodlObject cont = obj.getContainer();
        String contStr = cont != null ? cont.getName() : "null";
        String desc = obj.getName() + (obj.isFault() ? " FaultClass" : "") + " DataObject" + (topLevel ? "" : " Nested") + " Container: " + contStr;
        return OpenAPI3_sliced.qq(desc);
    }

    private String makeDescription(Method meth) {
        String desc = meth.getWsdlName() + "Method Input";
        return OpenAPI3_sliced.qq(desc);
    }

    private String toPropName(VmodlObject obj) {
        return obj.getWsdlName();
    }

    private String getObjectFileSuffix(VmodlObject obj) {
        if (obj.getKind() == VmodlObject.Kind.ManagedObject) {
            return "_mo";
        }
        return "_do";
    }

    private String getObjectFileName(VmodlObject obj) {
        return this.getObjectFileName(obj.getQualifiedVmodlType(), this.getObjectFileSuffix(obj));
    }

    private String getObjectFileNameRemap(VmodlObject obj) {
        String fname = this.getObjectFileName(obj);
        if (this.isExternalNsObj(obj)) {
            fname = this._namespace.replace(".", "/") + "/_" + fname;
        }
        return fname;
    }

    private String getObjectFileName(String qtype, String suffix) {
        return qtype.replace('.', '/') + suffix + ".yaml";
    }

    private void beginFileForObject(VmodlObject obj) {
        this.beginFile(this.getObjectFileNameRemap(obj));
    }

    @Override
    protected void beginFile(String filename) {
        super.beginFile(this.fullFname(filename));
    }

    private String fullFname(String fname) {
        return this._folder + '/' + fname;
    }

    private String relativePath(String path, String base) {
        if (path.equals(base) || this._forceLocalRefs) {
            return "";
        }
        Path fname = Paths.get(path, new String[0]).getFileName();
        Path pathAbsolute = Paths.get(path, new String[0]).getParent();
        Path pathBase = Paths.get(base, new String[0]).getParent();
        Path pathRelative = pathBase.relativize(pathAbsolute);
        pathRelative = pathRelative.resolve(fname);
        return pathRelative.toString();
    }

    private static class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method lhs, Method rhs) {
            return lhs.getWsdlName().compareTo(rhs.getWsdlName());
        }
    }

    private static class VmodlObjectComparator
    implements Comparator<VmodlObject> {
        private VmodlObjectComparator() {
        }

        @Override
        public int compare(VmodlObject lhs, VmodlObject rhs) {
            return lhs.getClassName().compareTo(rhs.getClassName());
        }
    }
}

