/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap.legacy;

import emitters.ObjectRegistry;
import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.generators.joap.ObjectsEnumerator;
import emitters.lists.CoreObjects;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.Field;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Swagger2
extends VmodlEmitter {
    private final String _folder;
    private final VmodlObject _Any;
    private final VmodlObject _MoRef;
    private final VmodlObject _MethodFault;
    private final ManagedObject[] _managedObjects;
    private final DataObject[] _dataObjects;
    private final Enum[] _enums;
    private final Set<CustomObject> _customObjects;
    private static final Comparator<VmodlApi> NameComparator = new Comparator<VmodlApi>(){

        @Override
        public int compare(VmodlApi lhs, VmodlApi rhs) {
            return lhs.getName().compareTo(rhs.getName());
        }
    };
    private static final Comparator<CustomObject> CustomObjectComparator = new Comparator<CustomObject>(){

        @Override
        public int compare(CustomObject lhs, CustomObject rhs) {
            return lhs._name.compareTo(rhs._name);
        }
    };
    private static final Method[] METHOD_ARRAY = new Method[0];
    private static final Property[] PROPERTY_ARRAY = new Property[0];
    private static final CustomObject[] CUSTOM_OBJECT_ARRAY = new CustomObject[0];
    private static final List<DataObject> NO_FAULTS = new ArrayList<DataObject>();
    private static final Field[] ANY_DECL = new Field[]{new Field("className", new VmodlDecl(VmodlDecl.TypeId.STRING))};
    private static final Field[] BOOLEAN_DECL = new Field[]{new Field("value", new VmodlDecl(VmodlDecl.TypeId.BOOLEAN))};
    private static final Field[] BYTE_DECL = new Field[]{new Field("value", new VmodlDecl(VmodlDecl.TypeId.BYTE))};
    private static final Field[] SHORT_DECL = new Field[]{new Field("value", new VmodlDecl(VmodlDecl.TypeId.SHORT))};
    private static final Field[] INT_DECL = new Field[]{new Field("value", new VmodlDecl(VmodlDecl.TypeId.INT))};
    private static final Field[] LONG_DECL = new Field[]{new Field("value", new VmodlDecl(VmodlDecl.TypeId.LONG))};
    private static final Field[] FLOAT_DECL = new Field[]{new Field("value", new VmodlDecl(VmodlDecl.TypeId.FLOAT))};
    private static final Field[] DOUBLE_DECL = new Field[]{new Field("value", new VmodlDecl(VmodlDecl.TypeId.DOUBLE))};
    private static final Field[] BINARY_DECL = new Field[]{new Field("value", new VmodlDecl(VmodlDecl.TypeId.BINARY))};
    private static final Field[] DATETIME_DECL = new Field[]{new Field("value", new VmodlDecl(VmodlDecl.TypeId.DATETIME))};
    private static final Field[] STRING_DECL = new Field[]{new Field("value", new VmodlDecl(VmodlDecl.TypeId.STRING))};
    private static final String BYTE_MIN = "-128";
    private static final String BYTE_MAX = "127";
    private static final String SHORT_MIN = "-32768";
    private static final String SHORT_MAX = "32767";

    public Swagger2(Map<String, String> options, String folder) {
        this._folder = folder;
        this._Any = ObjectRegistry.getObject(Utils.AnyClassName);
        this._MoRef = ObjectRegistry.getObject(Utils.ManagedObjectReferenceClassName);
        this._MethodFault = ObjectRegistry.getObject(Utils.MethodFaultClassName);
        ObjectsEnumerator enumerator = this.enumerateObjects();
        this._managedObjects = enumerator.getManagedObjects();
        this._dataObjects = enumerator.getDataObjects();
        this._enums = enumerator.getEnums();
        this._customObjects = new HashSet<CustomObject>(this._managedObjects.length * 4);
        this.setIndentSpaces("  ");
    }

    ObjectsEnumerator enumerateObjects() {
        class EnumeratorFilter
        implements ObjectsEnumerator.Filter {
            private final CoreObjects _coreObjects = new CoreObjects();

            EnumeratorFilter() {
            }

            @Override
            public boolean shouldEmit(VmodlObject object) {
                return Swagger2.shouldEmit(object) && !this._coreObjects.contains(object);
            }
        }
        return new ObjectsEnumerator(ObjectRegistry.getAllObjects(), new EnumeratorFilter());
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.beginFile(this._folder + "/joap.yaml");
        this.emitHeader("vSphere APIs", this.getTargetVersion().getWireId());
        this.emitLine("paths:", INDENT);
        for (ManagedObject managedObject : this._managedObjects) {
            this.emitMethods(managedObject);
            this.emitManagedPropertyGetters(managedObject);
        }
        this.unindent();
        this.emitLine("definitions:", INDENT);
        this.emitCoreObjects();
        this.emitCustomObjects();
        this.emitDataObjects();
        this.emitEnums();
        this.endFile();
    }

    private Version getTargetVersion() {
        Version version = Versions.getTargetVersion();
        String wireNs = version.getWireNs();
        block0: while (version.getKind() != Version.Kind.LTS) {
            for (Version parent : version.getDirectParents()) {
                if (!parent.getWireNs().equals(wireNs)) continue;
                version = parent;
                continue block0;
            }
        }
        return version;
    }

    private void emitHeader(String title, String version) {
        this.emitLine("swagger: \"2.0\"");
        this.emitLine("info:", INDENT);
        this.emitLine("title: ", Swagger2.qs(title));
        this.emitLine("version: ", version);
        this.unindent();
        this.emitLine("basePath: /sdk");
        this.emitGap();
    }

    private void emitMethods(ManagedObject managedObject) {
        Method[] methods = managedObject.getMethodList().toArray(METHOD_ARRAY);
        Arrays.sort(methods, NameComparator);
        String path = this.getPathFor(managedObject);
        for (Method method : methods) {
            if (!Swagger2.shouldEmit(method)) continue;
            this.pushIndent();
            String methodName = method.getName();
            String opId = path + "_" + methodName;
            String tag = managedObject.getWsdlName();
            this.emitOperation(path, methodName, "post", opId, tag);
            List<Parameter> parameters = method.getParameterList();
            if (!parameters.isEmpty()) {
                String name = opId + "_params";
                this._customObjects.add(new MethodParameters(name, parameters));
                this.emitRequestBody(name);
            }
            VmodlDecl result = method.isTask() ? Method.taskReturnDecl() : method.getReturnDecl();
            this.emitResponse(result, method.getFaultList(), opId);
            this.popIndent();
            this.emitGap();
        }
    }

    private void emitManagedPropertyGetters(ManagedObject managedObject) {
        Property[] properties = this.getReleasedProperties(managedObject).toArray(PROPERTY_ARRAY);
        Arrays.sort(properties, NameComparator);
        String path = this.getPathFor(managedObject);
        for (Property property : properties) {
            String methodName = property.getName();
            String opId = path + "_Get" + Swagger2.capitalize(methodName);
            this.pushIndent();
            String tag = managedObject.getWsdlName();
            this.emitOperation(path, methodName, "get", opId, tag);
            this.emitResponse(property.getDecl(), NO_FAULTS, null);
            this.popIndent();
            this.emitGap();
        }
    }

    private void emitOperation(String path, String methodName, String httpMethod, String opId, String tag) {
        this.emitLine("/", path, "/{moId}/", methodName, ":");
        this.emitLine(INDENT, httpMethod, ":");
        this.emitLine(INDENT, "operationId: ", opId);
        this.emitLine("tags: [", Swagger2.qq(tag), "]");
        this.pushIndent();
        this.emitLine("parameters:", INDENT);
        this.emitLine("- name: moId", INDENT);
        this.emitLine("in: path");
        this.emitLine("required: true");
        this.emitLine("type: string");
        this.popIndent();
    }

    private void emitRequestBody(String schemaId) {
        this.pushIndent();
        this.indent();
        this.emitLine("- name: " + schemaId.toLowerCase(), INDENT);
        this.emitLine("in: body");
        this.emitLine("required: true");
        this.emitLine("schema:", INDENT);
        this.emitRef(schemaId);
        this.popIndent();
    }

    private void emitResponse(VmodlDecl result, List<DataObject> faults, String opId) {
        this.emitLine("responses:", INDENT);
        this.pushIndent();
        this.emitLine("'200':", INDENT);
        this.emitOpenAPI_description("OK");
        if (result.getTypeId() != VmodlDecl.TypeId.VOID) {
            this.emitLine("schema:", INDENT);
            this.emitDecl(result);
            if (result.isOptional()) {
                this.popIndent();
                this.pushIndent();
                this.emitLine("'204':", INDENT);
                this.emitOpenAPI_description("OK");
            }
        }
        this.popIndent();
        DataObject fault = this.selectRepresentativeFault_(faults);
        if (fault != null) {
            this.emitLine("'500':", INDENT);
            this.emitOpenAPI_description("Failure");
            this.emitLine("schema:", INDENT);
            this.emitRef(fault);
        }
    }

    private DataObject selectRepresentativeFault_(List<DataObject> faults) {
        return faults.size() > 0 ? (DataObject)this._MethodFault : null;
    }

    private void emitCoreObjects() {
        this.emitAnySchema();
        this.emitBoxedPrimitive("Boolean", BOOLEAN_DECL);
        this.emitBoxedPrimitive("Byte", BYTE_DECL);
        this.emitBoxedPrimitive("Short", SHORT_DECL);
        this.emitBoxedPrimitive("Int", INT_DECL);
        this.emitBoxedPrimitive("Long", LONG_DECL);
        this.emitBoxedPrimitive("Float", FLOAT_DECL);
        this.emitBoxedPrimitive("Double", DOUBLE_DECL);
        this.emitBoxedPrimitive("Binary", BINARY_DECL);
        this.emitBoxedPrimitive("DateTime", DATETIME_DECL);
        this.emitBoxedPrimitive("String", STRING_DECL);
    }

    private void emitAnySchema() {
        this.emitLine("Any:");
        this.emitOpenAPI_object(null, Arrays.asList(ANY_DECL));
        this.emitLine("\t", "discriminator: className");
    }

    private void emitBoxedPrimitive(String primitive, Field[] decl) {
        this.emitLine("Boxed", primitive, ":");
        this.emitOpenAPI_object(this._Any, Arrays.asList(decl));
    }

    private void emitCustomObjects() {
        CustomObject[] customObjectList = this._customObjects.toArray(CUSTOM_OBJECT_ARRAY);
        Arrays.sort(customObjectList, CustomObjectComparator);
        for (CustomObject customObject : customObjectList) {
            this.emitLine(customObject._name, ":");
            customObject.generate();
        }
    }

    private void emitDataObjects() {
        for (DataObject dataObject : this._dataObjects) {
            VmodlObject base = dataObject.getBaseObject();
            if (base == null) {
                base = this._Any;
            }
            this.emitLine(this.getSchemaIdFor(dataObject), ":");
            this.emitOpenAPI_object(base, this.getReleasedProperties(dataObject));
        }
    }

    private void emitEnums() {
        for (Enum enum_ : this._enums) {
            List<String> values = enum_.getValueList();
            if (values.isEmpty()) continue;
            this.pushIndent();
            this.emitLine(this.getSchemaIdFor(enum_) + ":", INDENT);
            this.emitLine("type: string");
            this.emitLine("enum:", INDENT);
            for (String value : values) {
                this.emitLine("- ", value);
            }
            this.popIndent();
        }
    }

    private String getPathFor(ManagedObject managedObject) {
        return managedObject.getWsdlName();
    }

    private String getSchemaIdFor(VmodlObject object) {
        return object.getWsdlName();
    }

    private void emitDashRef(VmodlObject obj) {
        this.emitPartial("- ");
        this.emitRef(obj);
    }

    private void emitRef(VmodlObject object) {
        this.emitRef(this.getSchemaIdFor(object));
    }

    private void emitRef(String target) {
        this.emitLine("$ref: '#/definitions/", target, "'");
    }

    private void emitDecl(VmodlDecl decl) {
        if (decl.isArray()) {
            this.emitLine("type: array");
            this.emitLine("items:", INDENT);
        }
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                this.emitOpenAPI_type("boolean");
                break;
            }
            case BYTE: {
                this.emitOpenAPI_int(BYTE_MIN, BYTE_MAX);
                break;
            }
            case SHORT: {
                this.emitOpenAPI_int(SHORT_MIN, SHORT_MAX);
                break;
            }
            case INT: {
                this.emitOpenAPI_type("integer", "int32");
                break;
            }
            case LONG: {
                this.emitOpenAPI_type("integer", "int64");
                break;
            }
            case FLOAT: {
                this.emitOpenAPI_type("number", "float");
                break;
            }
            case DOUBLE: {
                this.emitOpenAPI_type("number", "double");
                break;
            }
            case BINARY: {
                this.emitOpenAPI_type("string", "byte");
                break;
            }
            case DATETIME: {
                this.emitOpenAPI_type("string", "date-time");
                break;
            }
            case METHODNAME: 
            case PROPPATH: 
            case TYPENAME: 
            case URI: 
            case STRING: {
                this.emitOpenAPI_type("string");
                break;
            }
            case ANY: {
                this.emitRef(this._Any);
                break;
            }
            case MANAGED: {
                this.emitRef(this._MoRef);
                break;
            }
            case ENUM: 
            case DATA: {
                this.emitRef(decl.getObject());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
        }
    }

    private void emitOpenAPI_type(String type) {
        this.emitLine("type: ", type);
    }

    private void emitOpenAPI_type(String type, String format) {
        this.emitOpenAPI_type(type);
        this.emitLine("format: ", format);
    }

    private void emitOpenAPI_int(String min, String max) {
        this.emitOpenAPI_type("integer");
        this.emitLine("minimum: ", min);
        this.emitLine("maximum: ", max);
    }

    private void emitOpenAPI_object(VmodlObject base, List<? extends Field> fields) {
        this.emitLine(INDENT, "type: object");
        if (base != null) {
            this.emitLine("allOf:");
            this.emitDashRef(base);
            this.emitLine("- description: \"Placeholder for buggy swagger2vmodl\"");
        }
        if (fields.isEmpty()) {
            this.unindent();
            return;
        }
        ArrayList<String> requiredFields = new ArrayList<String>();
        if (base != null) {
            this.indent();
        }
        this.emitLine("properties:", INDENT);
        for (Field field : fields) {
            VmodlDecl decl = field.getDecl();
            String name = field.getName();
            if (!decl.isOptional()) {
                requiredFields.add(name);
            }
            this.pushIndent();
            this.emitLine(name, ":");
            this.indent();
            this.emitDecl(decl);
            this.popIndent();
        }
        if (base != null) {
            this.unindent();
        }
        this.unindent();
        if (!requiredFields.isEmpty()) {
            if (base != null) {
                this.indent();
            }
            this.emitLine("required:", INDENT);
            for (String string : requiredFields) {
                this.emitLine("- ", string);
            }
            if (base != null) {
                this.unindent();
            }
            this.unindent();
        }
        this.unindent();
    }

    private void emitOpenAPI_description(String description) {
        this.emitLine("description: \"", description, "\"");
    }

    private List<Property> getReleasedProperties(VmodlObject object) {
        List<Property> allProperties = object.getPropertyListWithOverrides();
        ArrayList<Property> properties = new ArrayList<Property>(allProperties.size());
        for (Property property : allProperties) {
            if (!Swagger2.shouldEmit(property)) continue;
            properties.add(property);
        }
        return properties;
    }

    private static boolean shouldEmit(VmodlApi vmodlApi) {
        return vmodlApi.getVersion().getKind() == Version.Kind.LTS && !vmodlApi.isInternal();
    }

    private class MethodParameters
    extends CustomObject {
        private final List<Parameter> _parameters;

        MethodParameters(String name, List<Parameter> parameters) {
            super(name);
            this._parameters = parameters;
        }

        @Override
        void generate() {
            Swagger2.this.emitOpenAPI_object(null, this._parameters);
        }
    }

    private abstract class CustomObject {
        final String _name;

        CustomObject(String name) {
            this._name = name;
        }

        abstract void generate();
    }
}

