/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.Utils;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;

public class ManagedProperty
extends Property {
    private Version _internalBefore;
    private String _customName;

    public ManagedProperty(VmodlObject container, String name, String wsdlName2, VmodlDecl decl, String privId, Version version, String comment) {
        super(container, name, wsdlName2, decl, true, privId, version, comment);
    }

    ManagedProperty(ManagedProperty mprop, Version version) {
        super(mprop, version);
    }

    public void setInternalBefore(Version version) {
        this._internalBefore = version;
    }

    public void setCustomName(String customName) {
        if (this._customName != null) {
            throw new RuntimeException(this._container.getFullClassName() + "." + this.getName() + ": the custom ID is already set to " + this._customName);
        }
        this._customName = customName;
    }

    @Override
    public Method getAccessor() {
        String accessorName = this.getAccessorPrefix() + Utils.capitalize(this._name);
        Method method = new Method(this._container, accessorName, this._decl, this._privId, this._version, this._comment);
        method.setWsdlName("Get" + this._wsdlName);
        return method;
    }

    @Override
    public Method getMutator() {
        String mutatorName = this.getMutatorPrefix() + Utils.capitalize(this._name);
        Method method = new Method(this._container, mutatorName, VmodlDecl.voidType, this._version, this._comment);
        method.setWsdlName("Set" + this._wsdlName);
        method.addParameter(new Parameter("val", this._decl, this._privId, this._version, this._comment));
        return method;
    }

    @Override
    public Method getUnsetter() {
        throw new RuntimeException("Managed properties have no unsetter");
    }

    @Override
    public Method getPeeker() {
        String peekerName = this.getPeekerPrefix() + Utils.capitalize(this._name);
        return new Method(this._container, peekerName, this._decl, this._version, this._comment);
    }

    @Override
    public Method getSwapper() {
        String swapperName = this.getSwapperPrefix() + Utils.capitalize(this._name);
        Method method = new Method(this._container, swapperName, VmodlDecl.voidType, this._version, this._comment);
        method.addParameter(new Parameter("val", this._decl, this._version, this._comment));
        return method;
    }

    @Override
    public String getAccessorPrefix() {
        return this._decl.isBoolean() ? "Is" : "Get";
    }

    @Override
    public String getMutatorPrefix() {
        if (this._readonly) {
            throw new RuntimeException("Readonly managed property has no mutator");
        }
        return "Set";
    }

    @Override
    public String getUnsetterPrefix() {
        if (this._decl.isOptional() && this._decl.isPrimitive() && !this._decl.isArray()) {
            return "Unset";
        }
        throw new RuntimeException("Unset used for non-optional-primitive type");
    }

    @Override
    public String getPeekerPrefix() {
        return "Peek";
    }

    @Override
    public String getSwapperPrefix() {
        return "Swap";
    }

    @Override
    public boolean isInternal() {
        return this._decl.isInternal();
    }

    @Override
    public Version getInternalBefore() {
        return this._internalBefore;
    }

    public String getCustomName() {
        return this._customName;
    }

    @Override
    void print(String indent) {
        super.print(indent);
        if (this._internalBefore != null) {
            System.out.print(" internal before: " + this._internalBefore.getVmodlName());
        }
    }
}

