/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.backend.FssConfig;
import emitters.backend.Platform;
import emitters.model.Feature;
import emitters.model.Maturity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import vmodl.featureList;
import vmodl.featureSpec;
import vmodl.releaseList;

public class Product {
    private final String _name;
    private FssConfig _fssConfig;
    private final Set<Feature> _ltsFeatures = new HashSet<Feature>();
    private final Set<Feature> _devFeatures = new HashSet<Feature>();
    private final Map<String, Feature> _features = new HashMap<String, Feature>();
    private final Set<String> _releases = new LinkedHashSet<String>();
    private static Map<String, Product> _products = new HashMap<String, Product>();
    private static final List<Feature> NO_PARENTS = new ArrayList<Feature>(0);

    Product(String name, releaseList releaseList2, featureList featureList2) {
        this._name = name;
        String configClass = "emitters.config." + name + "FssConfig";
        this._fssConfig = Platform.fetchFssConfig(configClass);
        this.retrieveFeatures(featureList2.value());
        this.retrieveReleases(releaseList2.value());
    }

    private void retrieveFeatures(featureSpec[] featureList2) {
        this.validateFeatureSpec(featureList2);
        this.fillFeatureMap(featureList2, 0);
    }

    private void validateFeatureSpec(featureSpec[] featureList2) {
        if (this._name.contains("Test")) {
            return;
        }
        String previousName = "";
        for (featureSpec feature2 : featureList2) {
            String name = feature2.name();
            int result = name.compareToIgnoreCase(previousName);
            if (result <= 0) {
                throw new RuntimeException("Features in non-alphabetical order in product " + this._name + ": " + previousName + " followed by " + name);
            }
            previousName = name;
        }
    }

    private void fillFeatureMap(featureSpec[] featureSpecs, int index) {
        for (int i = index; i < featureSpecs.length; ++i) {
            Feature feature2;
            List<Feature> parents;
            featureSpec fspec = featureSpecs[i];
            String featureName = fspec.name();
            String[] featureDeps = fspec.dependencies();
            if (this._features.containsKey(featureName)) continue;
            if (featureDeps.length == 0) {
                parents = NO_PARENTS;
            } else {
                boolean recurse = false;
                parents = new ArrayList<Feature>();
                int j = 0;
                while (j < featureDeps.length) {
                    if (this._features.containsKey(featureDeps[j])) {
                        parents.add(this._features.get(featureDeps[j]));
                        ++j;
                        continue;
                    }
                    if (recurse) {
                        throw new RuntimeException("Feature '" + featureName + "' depends on '" + featureDeps[j] + "' which is not defined or there is a circular dependency in  product " + this._name);
                    }
                    recurse = true;
                    this.fillFeatureMap(featureSpecs, i + 1);
                }
            }
            switch (this._fssConfig.getState(featureName)) {
                case ENABLED: {
                    this.validateBranch(featureName);
                    feature2 = new Feature(featureName, Maturity.LTS, parents);
                    this._ltsFeatures.add(feature2);
                    break;
                }
                case DISABLED: {
                    feature2 = new Feature(featureName, Maturity.DEV, parents);
                    this._devFeatures.add(feature2);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported state for feature " + featureName);
                }
            }
            this._features.put(featureName, feature2);
        }
    }

    private void validateBranch(String featureName) {
        String product;
        if (this._fssConfig.isFrozen() && (product = this._fssConfig.getProduct()) != null && product.equals("vSphere")) {
            String message = "The automatic generation of next release's VMODL version is currently disabled. To ensure VMODL APIs associated with the enabled feature '" + featureName + "' are included in the release, do replace annotations @feature(\"" + featureName + "\") with @released(\"7.0.x.y\"). In addition, the line containing @featureSpec(name = \"" + featureName + "\") has to be removed from bora/vim/vmomi/product/vSphere.java";
            throw new RuntimeException(message);
        }
    }

    private void retrieveReleases(String[] releaseList2) {
        for (int i = releaseList2.length - 1; i >= 0; --i) {
            this._releases.add(releaseList2[i]);
        }
    }

    public Feature getFeature(String name) {
        return this._features.get(name);
    }

    public FssConfig getFssConfig() {
        return this._fssConfig;
    }

    public Set<Feature> getLtsFeatures() {
        return this._ltsFeatures;
    }

    public Set<Feature> getDevFeatures() {
        return this._devFeatures;
    }

    public Set<String> getReleases() {
        return this._releases;
    }

    public static Product createProduct(String name, releaseList releaseList2, featureList features) {
        Product product = new Product(name, releaseList2, features);
        if (_products.put(name, product) == null) {
            return product;
        }
        throw new RuntimeException("Product '" + name + "' is already created");
    }

    public static Product getProduct(String name) {
        return _products.get(name);
    }
}

