/*
 * Decompiled with CFR 0.152.
 */
package emitters.wsdl;

import emitters.Services;
import emitters.Versions;
import emitters.backend.Platform;
import emitters.model.ManagedObject;
import emitters.model.Version;
import emitters.model.VmodlObject;
import emitters.wsdl.BaseWSDLEmitter;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WSDLGenerator2
extends BaseWSDLEmitter {
    private Map<String, String> _elementMap = new HashMap<String, String>();

    public WSDLGenerator2(Map<String, String> options, boolean ltsOnly) {
        super(options, ltsOnly);
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.commonSetup();
        this._outputDirPath = this._outputDirPath + File.separator + Services.getTargetService();
        this.generateSchemas();
        if (this._wsdlServiceFilename == null) {
            if (this._xsdFilename != null) {
                this.generateTargetSchema(this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
            }
        } else if (this._wsdlInterfaceFilename == null) {
            if (this._xsdFilename == null) {
                this.generateServiceWSDL(this._wsdlServiceFilename, null, null, this._targetNSPrefix, this._targetNamespace);
            } else {
                this.generateServiceWSDL(this._wsdlServiceFilename, null, this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
                this.generateTargetSchema(this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
            }
        } else if (this._xsdFilename == null) {
            this.generateServiceWSDL(this._wsdlServiceFilename, this._wsdlInterfaceFilename, null, this._targetNSPrefix, this._targetNamespace);
            this.generateInterfaceWSDL(this._wsdlInterfaceFilename, null, this._targetNSPrefix, this._targetNamespace);
        } else {
            this.generateServiceWSDL(this._wsdlServiceFilename, this._wsdlInterfaceFilename, this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
            this.generateInterfaceWSDL(this._wsdlInterfaceFilename, this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
            this.generateTargetSchema(this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
        }
    }

    private void generateServiceWSDL(String serviceWSDLFilename, String interfaceWSDLFilename, String schemaFilename, String targetNSPrefix, String targetNS) {
        this._indentationLevel = 0;
        PrintWriter out = Platform.createTextFile(new File(this._outputDirPath, serviceWSDLFilename));
        this.emitXMLDeclaration(out);
        this.emitCopyrightNotice(out);
        if (interfaceWSDLFilename == null) {
            this.emitDefinitionsStartTag(out, targetNSPrefix, targetNS, null, null, "http://schemas.xmlsoap.org/wsdl/", true, true, true, true);
            this.emitInterfaceSections(out, schemaFilename, targetNSPrefix, targetNS);
            this.emitServiceSection(out, targetNSPrefix);
        } else {
            this.emitDefinitionsStartTag(out, null, targetNS + "Service", "interface", targetNS, "http://schemas.xmlsoap.org/wsdl/", false, true, false, false);
            this.emitIndentedLine(out, "<import location=\"%s\" namespace=\"%s\" />", interfaceWSDLFilename, targetNS);
            this.emitServiceSection(out, "interface");
        }
        this.emitDefinitionsEndTag(out);
        out.close();
        if (this._indentationLevel != 0) {
            throw new IllegalStateException("non-zero indentation level");
        }
    }

    private void generateInterfaceWSDL(String interfaceWSDLFilename, String schemaFilename, String targetNSPrefix, String targetNS) {
        this._indentationLevel = 0;
        PrintWriter out = Platform.createTextFile(new File(this._outputDirPath, interfaceWSDLFilename));
        this.emitXMLDeclaration(out);
        this.emitCopyrightNotice(out);
        this.emitDefinitionsStartTag(out, targetNSPrefix, targetNS, null, null, "http://schemas.xmlsoap.org/wsdl/", true, true, true, true);
        if (this._wsdlAddSecurityPolicies) {
            this.emitSecurityPolicies(out);
        }
        this.emitInterfaceSections(out, schemaFilename, targetNSPrefix, targetNS);
        this.emitDefinitionsEndTag(out);
        out.close();
        if (this._indentationLevel != 0) {
            throw new IllegalStateException("non-zero indentation level");
        }
    }

    private String schemaNamespaceId(String serviceName) {
        String serviceNS = Services.schemaNamespaceId(serviceName);
        if (!this.hideInternalDecls()) {
            serviceNS = "internal" + serviceNS;
        }
        return serviceNS;
    }

    private void generateSchemas() {
        Map<String, Set<String>> importSchema = Services.getImportTypesMap();
        for (String service2 : importSchema.keySet()) {
            String targetNSPrefix = this.schemaNamespaceId(service2);
            String targetNS = "urn:" + targetNSPrefix;
            this.generateSchema(service2, targetNSPrefix, targetNS);
        }
    }

    private void generateTargetSchema(String xsdFileName, String targetNSPrefix, String targetNS) {
        this._indentationLevel = 0;
        PrintWriter out = Platform.createTextFile(new File(this._outputDirPath, xsdFileName));
        this.emitXMLDeclaration(out);
        this.emitCopyrightNotice(out);
        this.emitTargetSchema(out, targetNSPrefix, targetNS);
        out.close();
        if (this._indentationLevel != 0) {
            throw new IllegalStateException("non-zero indentation level");
        }
    }

    private String getFilePrefix(String serviceName) {
        String internalWSDL = "";
        if (!this.hideInternalDecls()) {
            internalWSDL = "internal";
        }
        return internalWSDL + serviceName;
    }

    private void generateSchema(String currentService, String targetNSPrefix, String targetNS) {
        this._indentationLevel = 0;
        PrintWriter out = Platform.createTextFile(new File(this._outputDirPath, this.getFilePrefix(currentService) + "-types.xsd"));
        PrintWriter messageOut = Services.shouldGenerateForMessages(currentService) ? Platform.createTextFile(new File(this._outputDirPath, this.getFilePrefix(currentService) + "-messagetypes.xsd")) : null;
        this.emitXMLDeclaration(out);
        this.emitCopyrightNotice(out);
        if (messageOut != null) {
            this.emitXMLDeclaration(messageOut);
            this.emitCopyrightNotice(messageOut);
        }
        StringWriter stringBuf = new StringWriter();
        PrintWriter elementOut = new PrintWriter(stringBuf);
        this.emitSchema(currentService, out, elementOut, messageOut, targetNSPrefix, targetNS);
        elementOut.close();
        if (messageOut != null) {
            messageOut.close();
        }
        out.close();
        this._elementMap.put(currentService, stringBuf.getBuffer().toString());
        if (this._indentationLevel != 0) {
            throw new IllegalStateException("non-zero indentation level");
        }
    }

    private void emitSchemaHeader(PrintWriter out, String currentService, String targetNSPrefix, String targetNS) {
        this.emitIndentedLine(out, "<schema", new Object[0]);
        this.indent();
        this.emitIndentedLine(out, "targetNamespace=\"%s\"", targetNS);
        this.emitIndentedLine(out, "xmlns=\"http://www.w3.org/2001/XMLSchema\"", new Object[0]);
        this.emitIndentedLine(out, "xmlns:%s=\"%s\"", targetNSPrefix, targetNS);
        this.emitIndentedLine(out, "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"", new Object[0]);
        Set<String> imports = Services.getImportTypesMap().get(currentService);
        HashSet<String> nss = new HashSet<String>();
        nss.add(targetNSPrefix);
        for (String service2 : imports) {
            String importNSPrefix = this.schemaNamespaceId(service2);
            if (nss.contains(importNSPrefix)) continue;
            nss.add(importNSPrefix);
            this.emitIndentedLine(out, "xmlns:%s=\"%s\"", importNSPrefix, "urn:" + importNSPrefix);
        }
        this.emitIndentedLine(out, "elementFormDefault=\"qualified\"", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, ">", new Object[0]);
    }

    @Override
    void emitTargetSchema(PrintWriter out, String targetNSPrefix, String targetNS) {
        this.emitSchemaHeader(out, Services.getTargetService(), targetNSPrefix, targetNS);
        Set<String> imports = Services.getImportTypesMap().get(Services.getTargetService());
        this.indent();
        for (String service2 : imports) {
            String importNamespacePrefix = this.schemaNamespaceId(service2);
            String importFileName = this.getFilePrefix(service2) + "-types.xsd";
            String messageFileName = this.getFilePrefix(service2) + "-messagetypes.xsd";
            if (Services.shouldGenerateForMessages(service2)) {
                if (targetNSPrefix.equals(importNamespacePrefix)) {
                    this.emitIndentedLine(out, "<include schemaLocation=\"" + messageFileName + "\" />", new Object[0]);
                    continue;
                }
                this.emitIndentedLine(out, "<import namespace=\"urn:" + importNamespacePrefix + "\" schemaLocation=\"" + messageFileName + "\" />", new Object[0]);
                continue;
            }
            if (targetNSPrefix.equals(importNamespacePrefix)) {
                this.emitIndentedLine(out, "<include schemaLocation=\"" + importFileName + "\" />", new Object[0]);
                continue;
            }
            this.emitIndentedLine(out, "<import namespace=\"urn:" + importNamespacePrefix + "\" schemaLocation=\"" + importFileName + "\" />", new Object[0]);
        }
        this.emitIndentedLine(out, "<include schemaLocation=\"" + this.getFilePrefix(Services.getTargetService()) + "-messagetypes.xsd\" />", new Object[0]);
        Version targetVersion = Versions.getTargetVersion();
        if (!Versions.hasLegacyChild(targetVersion)) {
            this.emitIndentedLine(out, "<element name=\"versionURI\" type=\"xsd:string\" />", new Object[0]);
        }
        for (String buf : this._elementMap.values()) {
            out.write(buf);
        }
        this.unindent();
        this.emitIndentedLine(out, "</schema>", new Object[0]);
    }

    private void emitSchema(String currentService, PrintWriter out, PrintWriter elementOut, PrintWriter messageOut, String targetNSPrefix, String targetNS) {
        this.emitSchemaHeader(out, currentService, targetNSPrefix, targetNS);
        if (messageOut != null) {
            this.emitSchemaHeader(messageOut, currentService, targetNSPrefix, targetNS);
        }
        this.indent();
        if (this._importAutoPrepTypes) {
            this.emitIndentedLine(out, "<import namespace=\"urn:sysimage-vmware-com:autoprep1\" %s", "schemaLocation=\"autoprep-types.xsd\" />");
        }
        Set<String> imports = Services.getImportTypesMap().get(currentService);
        for (String service2 : imports) {
            String importNamespacePrefix = this.schemaNamespaceId(service2);
            String importFileName = this.getFilePrefix(service2) + "-types.xsd";
            if (targetNSPrefix.equals(importNamespacePrefix)) {
                this.emitIndentedLine(out, "<include schemaLocation=\"" + importFileName + "\" />", new Object[0]);
                if (messageOut == null) continue;
                this.emitIndentedLine(messageOut, "<include schemaLocation=\"" + importFileName + "\" />", new Object[0]);
                continue;
            }
            this.emitIndentedLine(out, "<import namespace=\"urn:" + importNamespacePrefix + "\" schemaLocation=\"" + importFileName + "\" />", new Object[0]);
            if (messageOut == null) continue;
            this.emitIndentedLine(messageOut, "<import namespace=\"urn:" + importNamespacePrefix + "\" schemaLocation=\"" + importFileName + "\" />", new Object[0]);
        }
        if (messageOut != null) {
            this.emitIndentedLine(messageOut, "<include schemaLocation=\"" + this.getFilePrefix(currentService) + "-types.xsd\" />", new Object[0]);
        }
        this.generateTypes(out, elementOut, messageOut, currentService, targetNS);
        if (currentService.equals("core")) {
            this.emitCoreArrayPrimitives(out, targetNSPrefix);
        }
        this.unindent();
        this.emitIndentedLine(out, "</schema>", new Object[0]);
        if (messageOut != null) {
            this.emitIndentedLine(messageOut, "</schema>", new Object[0]);
        }
    }

    private void emitSecurityPolicies(PrintWriter out) {
        SecurityPolicyGenerator polGenerator = new SecurityPolicyGenerator();
        polGenerator.emitSecurityPolicies(out);
    }

    @Override
    String schemaId(VmodlObject obj) {
        return this.schemaNamespaceId(obj);
    }

    @Override
    boolean shouldGenerateFor(VmodlObject obj, String service2) {
        return this.shouldGenerateFor(obj) && Services.shouldGenerateForSchema(service2, obj.getVersion());
    }

    @Override
    String schemaArrayPrefix() {
        return this.schemaNamespaceId("core");
    }

    @Override
    boolean shouldGenerateMo(ManagedObject mo) {
        if (!Services.shouldGenerateForOps(mo.getVersion())) {
            return false;
        }
        return this.shouldGenerateFor(mo);
    }

    private class SecurityPolicyGenerator {
        private SecurityPolicyGenerator() {
        }

        void emitSecurityPolicies(PrintWriter out) {
            this.emitHoKTokenPolicy(out);
            this.emitBearerTokenPolicy(out);
            this.emitAllAlternativesPolicy(out);
        }

        private void emitHoKTokenPolicy(PrintWriter out) {
            this.emitWsPolicyStart(out, "SecPolicy_HoKToken");
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:AsymmetricBinding>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:Policy>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:InitiatorToken>", new Object[0]);
            this.emitSamlTokenPolicy(out);
            WSDLGenerator2.this.emitIndentedLine(out, "</sp:InitiatorToken>", new Object[0]);
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:RecipientToken>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:Policy />", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</sp:RecipientToken>", new Object[0]);
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:AlgorithmSuite>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:Policy>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:Basic128/>", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</wsp:Policy>", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</sp:AlgorithmSuite>", new Object[0]);
            this.emitLayoutPolicy(out);
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:IncludeTimestamp />", new Object[0]);
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:OnlySignEntireHeadersAndBody />", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</wsp:Policy>", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</sp:AsymmetricBinding>", new Object[0]);
            this.emitSignedPartsPolicy(out);
            this.emitWsPolicyEnd(out);
        }

        private void emitBearerTokenPolicy(PrintWriter out) {
            this.emitWsPolicyStart(out, "SecPolicy_BearerToken");
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:SupportingTokens>", new Object[0]);
            this.emitSamlTokenPolicy(out);
            WSDLGenerator2.this.emitIndentedLine(out, "</sp:SupportingTokens>", new Object[0]);
            this.emitWsPolicyEnd(out);
        }

        private void emitAllAlternativesPolicy(PrintWriter out) {
            this.emitWsPolicyStart(out, "SecPolicy_All");
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:PolicyReference URI=\"#%s\"/>", "SecPolicy_HoKToken");
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</wsp:All>", new Object[0]);
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:All>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:PolicyReference URI=\"#%s\"/>", "SecPolicy_BearerToken");
            this.emitWsPolicyEnd(out);
        }

        private void emitWsPolicyStart(PrintWriter out, String policyId) {
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:Policy wsu:Id=\"%s\">", policyId);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:ExactlyOne>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:All>", new Object[0]);
            WSDLGenerator2.this.indent();
        }

        private void emitWsPolicyEnd(PrintWriter out) {
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</wsp:All>", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</wsp:ExactlyOne>", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</wsp:Policy>", new Object[0]);
        }

        private void emitSamlTokenPolicy(PrintWriter out) {
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:Policy>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:SamlToken sp:IncludeToken=\"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/AlwaysToRecipient\">", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:WssSamlV20Token11 />", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</sp:SamlToken>", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</wsp:Policy>", new Object[0]);
            WSDLGenerator2.this.unindent();
        }

        private void emitLayoutPolicy(PrintWriter out) {
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:Layout>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<wsp:Policy>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:Strict />", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</wsp:Policy>", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</sp:Layout>", new Object[0]);
        }

        private void emitSignedPartsPolicy(PrintWriter out) {
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:SignedParts>", new Object[0]);
            WSDLGenerator2.this.indent();
            WSDLGenerator2.this.emitIndentedLine(out, "<sp:Body />", new Object[0]);
            WSDLGenerator2.this.unindent();
            WSDLGenerator2.this.emitIndentedLine(out, "</sp:SignedParts>", new Object[0]);
        }
    }
}

