/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.http.HttpUtils;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAsyncController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAsyncController.class);
    private static final long DEFAULT_RESPONSE_TIMEOUT = 60000L;
    protected final HttpServletRequest _request;
    protected final HttpServletResponse _response;

    public static void sendInternalServerError(Exception exc, HttpServletResponse response) {
        try {
            response.sendError(500);
        }
        catch (IOException e) {
            LOGGER.error("Failed to send response to client.", (Throwable)e);
        }
    }

    public BaseAsyncController(HttpServletRequest request, HttpServletResponse response) {
        this._request = request;
        this._response = response;
    }

    private Stream<HttpProcessStage> buildPipeline(HttpProcessStage stage) {
        return stage.process().flatMap(this::buildPipeline);
    }

    private Stream<HttpProcessStage> buildPipeline() {
        return Streams.just((Object[])new HttpProcessStage[]{this.createPipeline()}).flatMap(this::buildPipeline);
    }

    protected abstract HttpProcessStage createPipeline();

    public Promise<Void> start() throws IOException {
        return this.start(60000L);
    }

    public final Promise<Void> start(long timeout) throws IOException {
        AsyncContext context = this._request.startAsync();
        context.setTimeout(timeout);
        String path = HttpUtils.getPath(this._request);
        context.addListener((AsyncListener)new ContextListener(path));
        return this.buildPipeline().collect().onSuccess(unused -> context.complete()).onError(exc -> {
            LOGGER.warn("Request for path '{}' failed.", (Object)path, exc);
            try {
                BaseAsyncController.sendInternalServerError(exc, this._response);
            }
            finally {
                context.complete();
            }
        }).thenApply(unused -> null);
    }

    private static final class ContextListener
    implements AsyncListener {
        private final String _path;

        ContextListener(String path) {
            this._path = path;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            LOGGER.debug("Processing of request to '{}' completed", (Object)this._path);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            LOGGER.error("Processing of request to '{}' timed out", (Object)this._path);
        }

        public void onError(AsyncEvent event) throws IOException {
            LOGGER.error("Error occured while processing of request to {}", (Object)this._path, (Object)event.getThrowable());
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            LOGGER.debug("Processing of request to '{}' started", (Object)this._path);
        }
    }

    public static interface HttpProcessStage {
        public Stream<HttpProcessStage> process();
    }
}

