/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.srm.client.infrastructure.http.AsyncHttpResponseConsumer;
import com.vmware.srm.client.infrastructure.http.io.AsyncClientUtils;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.io.IOException;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang.Validate;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseController.class);

    public static Promise<HttpResponse> doGet(URI url, KeyStore sslStore, ThumbprintVerifier verifier) {
        Validate.notNull((Object)url, (String)"url");
        HttpGet request = new HttpGet(url);
        CloseableHttpAsyncClient http = AsyncClientUtils.createClient(sslStore, verifier);
        return HttpResponseController.doRequest((HttpUriRequest)request, http);
    }

    public static void doGet(URI url, KeyStore sslStore, ThumbprintVerifier verifier, BasicHeader header, AsyncHttpResponseConsumer responseConsumer, long socketTimeout) {
        Validate.notNull((Object)url, (String)"url");
        Validate.notNull((Object)url, (String)"sslStore");
        Validate.notNull((Object)url, (String)"verifier");
        Validate.notNull((Object)url, (String)"responseConsumer");
        HttpGet request = new HttpGet(url);
        request.setHeader((Header)header);
        CloseableHttpAsyncClient http = AsyncClientUtils.createClient(sslStore, verifier, socketTimeout);
        LOGGER.debug("Sending request " + request.getRequestLine());
        HttpResponseController.doRequest((HttpUriRequest)request, http, responseConsumer);
    }

    public static Promise<HttpResponse> doPost(HttpPost post, KeyStore sslStore, ThumbprintVerifier verifier) {
        CloseableHttpAsyncClient http = AsyncClientUtils.createClient(sslStore, verifier);
        return HttpResponseController.doRequest((HttpUriRequest)post, http);
    }

    private static Promise<HttpResponse> doRequest(HttpUriRequest request, CloseableHttpAsyncClient http) {
        try {
            http.start();
            HttpResponsePromise result = new HttpResponsePromise();
            http.execute(request, result);
            result.materialize().onSuccess(unused -> {
                try {
                    http.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return result;
        }
        catch (RuntimeException e) {
            try {
                http.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private static void doRequest(HttpUriRequest request, CloseableHttpAsyncClient http, AsyncHttpResponseConsumer responseConsumer) {
        try {
            http.start();
            HttpResponsePromise result = new HttpResponsePromise();
            HttpAsyncRequestProducer producer = HttpAsyncMethods.create((HttpUriRequest)request);
            http.execute(producer, (HttpAsyncResponseConsumer)responseConsumer, result);
            result.materialize().onSuccess(unused -> {
                try {
                    http.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    producer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (RuntimeException e) {
            try {
                http.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    static final class HttpResponsePromise<T>
    extends PromiseImpl<T>
    implements FutureCallback<T> {
        HttpResponsePromise() {
        }

        public void cancelled() {
            this.setError(new CancellationException());
        }

        public void completed(T result) {
            this.setResult(result);
        }

        public void failed(Exception exc) {
            this.setError(exc);
        }
    }
}

