/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import com.vmware.srm.client.infrastructure.utils.MixedUtil;
import com.vmware.vim.binding.vim.host.DatastoreBrowser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class DatastorePathUtil {
    public static final String PATH_DELIMITER = "/";
    private static final String REGEX = "^\\s*\\[([^\\]]*)\\]\\s*(.*)$";
    private static final Pattern PATH_REGEX = Pattern.compile("^\\s*\\[([^\\]]*)\\]\\s*(.*)$");
    private static final String OPENING_BRACKET = "[";
    private static final String CLOSING_BRACKET = "]";
    private static Pattern DATASTORE_PATH_PATTERN = Pattern.compile("\\[(.*?)\\] ?((?:.*?/)*)(.*)");

    public static String getDatastore(String path) {
        Matcher matcher = DatastorePathUtil.getMatcher(path);
        String datastore = matcher.group(1);
        return datastore;
    }

    public static String getDirectory(String path) {
        Matcher matcher = DatastorePathUtil.getMatcher(path);
        String filename = matcher.group(2);
        return FilenameUtils.getFullPathNoEndSeparator((String)filename);
    }

    public static String getPath(String fullPath) {
        return DatastorePathUtil.prefixWithDatastoreName(DatastorePathUtil.getDatastore(fullPath), DatastorePathUtil.getDirectory(fullPath));
    }

    public static String getFilename(String path) {
        Matcher matcher = DatastorePathUtil.getMatcher(path);
        String filename = matcher.group(2);
        return FilenameUtils.getName((String)filename);
    }

    private static Matcher getMatcher(String path) {
        if (StringUtils.isEmpty((String)path)) {
            throw new IllegalArgumentException("path");
        }
        Matcher matcher = PATH_REGEX.matcher(path);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid datastore path");
        }
        return matcher;
    }

    public static String escapeDatastoreNameInPath(String datastorePath) {
        return DatastorePathUtil.escapeOrUnescapeDatastoreNameInPath(datastorePath, true);
    }

    public static String unescapeDatastoreNameInPath(String datastorePath) {
        return DatastorePathUtil.escapeOrUnescapeDatastoreNameInPath(datastorePath, false);
    }

    public static void unescapeDatastoreNameInSearchResults(DatastoreBrowser.SearchResults[] typedResults) {
        for (DatastoreBrowser.SearchResults result : typedResults) {
            result.folderPath = DatastorePathUtil.unescapeDatastoreNameInPath(result.folderPath);
        }
    }

    public static String prefixWithDatastoreName(String dsName, String path) {
        return OPENING_BRACKET + dsName + CLOSING_BRACKET + (StringUtils.isNotBlank((String)path) ? " " + path : "");
    }

    public static String constructPath(String base, String pathToAppend) {
        return StringUtils.isNotBlank((String)pathToAppend) ? base + PATH_DELIMITER + pathToAppend : base;
    }

    private static String escapeOrUnescapeDatastoreNameInPath(String datastorePath, boolean escape) {
        Matcher datastorePathMatcher = DATASTORE_PATH_PATTERN.matcher(datastorePath);
        if (datastorePathMatcher.matches()) {
            int datastoreNameGroupStartIndex = datastorePathMatcher.start(1);
            int datastoreNameGroupEndIndex = datastorePathMatcher.end(1);
            String datastoreName = datastorePath.substring(datastoreNameGroupStartIndex, datastoreNameGroupEndIndex);
            datastoreName = escape ? MixedUtil.escapeVimEntityNameSpecialChars(datastoreName) : MixedUtil.unescapeVimEntityNameSpecialChars(datastoreName);
            String datastoreNamePrefix = datastorePath.substring(0, datastoreNameGroupStartIndex);
            String datastoreNameSuffix = datastorePath.substring(datastoreNameGroupEndIndex);
            datastorePath = datastoreNamePrefix + datastoreName + datastoreNameSuffix;
        }
        return datastorePath;
    }
}

