/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import com.vmware.dr.ui.tools.utilities.ExecutorUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;

public abstract class AsyncConsumer<T>
implements Consumer<T> {
    private static final Node SENTINEL = new Node<Object>(null);
    private final AtomicReference<Worker> _workerRef = new AtomicReference();
    private final AtomicReference<Node<T>> _headRef = new AtomicReference();
    private final Consumer<T> _delegate;
    private final Executor _exec;

    private static <T> Node<T> getLast(Node<T> head) {
        Node<T> last = head;
        Node node = last.next.get();
        while (node != null) {
            last = node;
            node = node.next.get();
        }
        return last;
    }

    protected AsyncConsumer(Consumer<T> delegate) {
        this(delegate, ExecutorUtils.getExecutor());
    }

    protected AsyncConsumer(Consumer<T> delegate, Executor exec) {
        Validate.notNull(delegate, (String)"delegate");
        Validate.notNull((Object)exec, (String)"exec");
        this._delegate = delegate;
        this._exec = exec;
    }

    @Override
    public void accept(T item) {
        Node<T> thisNode = new Node<T>(item);
        block0: while (true) {
            Node<T> head = null;
            while (head == null) {
                Worker w;
                head = this._headRef.get();
                if (head != null || !this._headRef.compareAndSet(null, thisNode)) continue;
                if (this._workerRef.get() == null && this._workerRef.compareAndSet(null, w = new Worker())) {
                    this._exec.execute(w);
                }
                return;
            }
            Node<T> last = head;
            do {
                if ((last = AsyncConsumer.getLast(last)) == SENTINEL) continue block0;
            } while (!last.next.compareAndSet(null, thisNode));
            break;
        }
    }

    protected void endOfBatch(T last) {
    }

    protected abstract void handleError(Throwable var1, T var2);

    private void handleErrorInternal(Throwable t, T item) {
        try {
            this.handleError(t, item);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private static final class Node<T> {
        final T item;
        final AtomicReference<Node<T>> next = new AtomicReference();

        Node(T item) {
            this.item = item;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            while (true) {
                Node last;
                Node head;
                if ((head = (Node)AsyncConsumer.this._headRef.getAndSet(null)) == null) {
                    AsyncConsumer.this._workerRef.set(null);
                    if (AsyncConsumer.this._headRef.get() != null && AsyncConsumer.this._workerRef.compareAndSet(null, this)) continue;
                    return;
                }
                do {
                    try {
                        AsyncConsumer.this._delegate.accept(head.item);
                    }
                    catch (Throwable t) {
                        AsyncConsumer.this.handleErrorInternal(t, head.item);
                    }
                    last = head;
                } while ((head = head.next.getAndSet(SENTINEL)) != null);
                try {
                    AsyncConsumer.this.endOfBatch(last.item);
                    continue;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

