/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.configurables.inventory.datacenter;

import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.vim.Tag;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vr.client.impex.configurables.ConfigurableConverter;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeNetwork;
import com.vmware.vr.client.impex.tool.IdBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;

public class NetworkConverter
implements ConfigurableConverter {
    private static final String UPLINK_PG_TAG = "SYSTEM/DVS.UPLINKPG";

    public static List<IeNetwork> fromVmodl(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference[] networks) {
        if (ArrayUtils.isEmpty(networks)) {
            return Collections.emptyList();
        }
        return Arrays.stream(networks).filter(NetworkConverter.isUplink(pcResult).negate()).map(network -> {
            IeNetwork ieNetwork = new IeNetwork();
            ieNetwork.setId(idBuilder.buildId((ManagedObjectReference)network));
            String name = (String)pcResult.getProperty(network, "name");
            ieNetwork.setName(name);
            return ieNetwork;
        }).collect(Collectors.toList());
    }

    private static Predicate<ManagedObjectReference> isUplink(PcResult pcResult) {
        return network -> {
            if (!"DistributedVirtualPortgroup".equals(network.getType())) {
                return false;
            }
            Object[] tags = (Tag[])pcResult.tryGetProperty(network, "tag");
            return ArrayUtils.isNotEmpty(tags) && Arrays.stream(tags).anyMatch(tag -> UPLINK_PG_TAG.equals(tag.key));
        };
    }
}

