/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.actions;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.infrastructure.actions.data.ActionAvailabilityData;
import com.vmware.srm.client.infrastructure.actions.data.ActionsRequestData;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.context.DrRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrDataList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DrInputType(value=ActionsRequestData.class)
public abstract class ActionsRequestHandler<T extends DrRequestContext<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionsRequestHandler.class);

    public Promise<DrDataList<ActionAvailabilityData>> handle(DrData input, T context) {
        ActionsRequestData requestData = (ActionsRequestData)input;
        Validate.notNull((Object)requestData, (String)"requestData");
        Validate.notNull((Object)requestData.getContext(), (String)"requestData.getContext");
        return this.handleImpl(requestData, context).onSuccess(result -> {
            String[] requestedActionIdsArray = requestData.getActionIds();
            HashSet<String> requestedActionIds = new HashSet<String>(Arrays.asList(requestedActionIdsArray));
            HashSet resultActions = new HashSet();
            result.forEach(r -> resultActions.add(r.getActionId()));
            requestedActionIds.removeAll(resultActions);
            if (!requestedActionIds.isEmpty()) {
                LOGGER.error("No availability data returned for actions: {}", requestedActionIds);
            }
        });
    }

    protected abstract Promise<DrDataList<ActionAvailabilityData>> handleImpl(ActionsRequestData var1, T var2);
}

