/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.init.workflow;

import com.vmware.srm.client.infrastructure.init.workflow.DrInitException;
import com.vmware.vim.sso.client.exception.AuthenticationFailedException;

public enum Status {
    UNKNOWN("Unknown configuration error occurred.", 0),
    OK("OK", 1){

        @Override
        public final DrInitException create(Throwable cause) {
            throw new IllegalStateException();
        }
    }
    ,
    CONFIG_ERROR("Unable to read configuration.", 2),
    KEY_STORE_ERROR("Unable to load app key store.", 4),
    WEB_SSO_CERT_PAIR_ERROR("Unable to load web sso certificate pair.", 8),
    PSC_ERROR("Unable to connect to PSC service.", 16){

        @Override
        public final DrInitException create(Throwable cause) {
            if (cause.getCause() instanceof AuthenticationFailedException) {
                throw SU_TOKEN_ERROR.create(cause);
            }
            throw super.create(cause);
        }
    }
    ,
    WEB_SSO_ERROR("Unable to complete WebSSO request.", 32),
    SU_TOKEN_ERROR("Service account token is not valid.", 64),
    OAUTH2_ERROR("OAuth2 configuration error", 128);

    private final String _msg;
    private final int _status;

    private Status(String msg, int status) {
        this._msg = msg;
        this._status = status;
    }

    public int get() {
        return this._status;
    }

    public String getMsg() {
        return this._msg;
    }

    public DrInitException create(Throwable cause) {
        return new DrInitException(this._status, this._msg, cause);
    }
}

