/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.workflow;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import com.vmware.srm.client.topology.impl.core.authentication.RemoteTokenProvider;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.LsppNegotiator;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.vmomi.client.exception.VlsiCertificateException;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vr.client.impex.tool.io.data.Credentials;
import com.vmware.vr.client.impex.workflow.UserInteractor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TopologyCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyCreator.class);

    public static Promise<TopologyImpl> create() {
        return TopologyCreator.getLsppUrl().thenCompose(TopologyCreator::beginTopologyCreation);
    }

    public abstract Promise<PairSetup> selectServerPair(TopologyImpl var1);

    protected static Promise<URI> getLsppUrl() {
        return UserInteractor.getInputWaiter().promptForLspp().thenApply(lspp -> {
            try {
                return Config.createLsppUrl((String)lspp.getHost(), (int)lspp.getPort());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not construct LSPP URL.", e);
            }
        });
    }

    protected static Promise<Set<LsppService>> probeLspp(URI lsppUrl, String thumbprint) {
        LsppNegotiator ln = new LsppNegotiator(lsppUrl, thumbprint, null);
        return ln.query(Types.LsppType.Sso.getVmodlType()).materialize().onSuccess(unused -> ln.close()).thenCompose(result -> {
            if (result.isSuccessful()) {
                return Promises.resolve((Object)((Set)result.getResult()));
            }
            Throwable cause = result.getError().getCause();
            if (cause instanceof CertificateValidationException) {
                CertificateValidationException cve = (CertificateValidationException)cause;
                return Promises.reject((Exception)new ProbeException(lsppUrl, cve.getThumbprint()));
            }
            if (cause instanceof SSLException && cause.getCause() instanceof VlsiCertificateException) {
                VlsiCertificateException vce = (VlsiCertificateException)cause.getCause();
                return Promises.reject((Exception)new ProbeException(lsppUrl, vce.getThumbprint()));
            }
            return Promises.reject((Exception)result.getError());
        });
    }

    protected static Promise<TopologyImpl> beginTopologyCreation(URI lsppUrl) {
        return TopologyCreator.beginTopologyCreation(lsppUrl, null);
    }

    protected static Promise<TopologyImpl> beginTopologyCreation(URI lsppUrl, String lsppThumbprint) {
        return TopologyCreator.probeLspp(lsppUrl, lsppThumbprint).materialize().thenCompose(lsppServicesPr -> {
            if (lsppServicesPr.isSuccessful()) {
                LsppService ssoReg = (LsppService)((Set)lsppServicesPr.getResult()).iterator().next();
                String hostName = SsoUtils.getStsEndpoint((LsppService)ssoReg).url.getHost();
                return TopologyCreator.authenticateAndGetTopologyCreds(ssoReg, lsppUrl, lsppThumbprint, hostName).materialize().thenCompose(result -> {
                    if (result.isSuccessful()) {
                        return Promises.resolve((Object)((TopologyImpl)result.getResult()));
                    }
                    if (result.getError() instanceof TokenProvider.InvalidCredentialsException) {
                        UserInteractor.getIoHelper().writeln("Invalid credentials.");
                        return TopologyCreator.beginTopologyCreation(lsppUrl, lsppThumbprint);
                    }
                    return Promises.reject((Exception)result.getError());
                });
            }
            Exception cause = lsppServicesPr.getError();
            if (cause instanceof ProbeException) {
                ProbeException pe = (ProbeException)cause;
                return TopologyCreator.promptForThumbprint(lsppUrl, pe.thumbprint).thenCompose(answer -> {
                    if (answer.booleanValue()) {
                        return TopologyCreator.beginTopologyCreation(lsppUrl, pe.thumbprint);
                    }
                    return Promises.reject((Exception)pe);
                });
            }
            return Promises.reject((Exception)cause);
        });
    }

    protected static Promise<TopologyImpl> authenticateAndGetTopologyCreds(LsppService ssoReg, URI lsppUrl, String thumbprint, String hostName) {
        Promise credentialsPromise = UserInteractor.getInputWaiter().promptForLocalCredentials(hostName).onSuccess(unused -> UserInteractor.getIoHelper().writeln("Establishing connection...")).thenCompose(creds -> Promises.from(() -> {
            RemoteTokenProvider tp = new RemoteTokenProvider(ssoReg);
            try {
                tp.loginWith(creds.getUsername(), creds.getPassword());
            }
            finally {
                tp.dispose();
            }
            return creds;
        }));
        return credentialsPromise.materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                TopologyImpl result = new TopologyImpl(lsppUrl, thumbprint);
                Credentials creds = (Credentials)((Object)((Object)pr.getResult()));
                return result.init(creds.getUsername(), creds.getPassword()).thenApply(ignored -> result).onError(ignored -> result.destroy());
            }
            Exception cause = pr.getError();
            if (cause instanceof TokenProvider.InvalidCredentialsException) {
                return Promises.reject((Exception)cause);
            }
            return Promises.reject((Exception)new RuntimeException("Unable to complete local login. Reason: " + cause.getMessage(), cause));
        });
    }

    protected static Promise<Boolean> promptForThumbprint(URI lsppUrl, String thumbprint) {
        return UserInteractor.getInputWaiter().promptForThumbprint(lsppUrl.getHost(), thumbprint);
    }

    protected static Promise<ServersView> loginRemoteWithCreds(TopologyImpl topology, PairSetup pairSetup) {
        return UserInteractor.getInputWaiter().promptForRemoteCredentials(pairSetup.pairServerName()).thenCompose(creds -> topology.loginPair(pairSetup, creds.getUsername(), creds.getPassword()));
    }

    protected static <T> Stream<T> from(Promise<T> promise) {
        return promise.materialize().toStream().flatMap(pr -> {
            if (pr.isSuccessful()) {
                return Streams.just((Object[])new Object[]{pr.getResult()});
            }
            LOGGER.warn("Unable to build stream, promise ended with error.", (Throwable)pr.getError());
            return Streams.empty();
        });
    }

    protected static <T> Stream<T> from(Stream<T> stream) {
        return stream.materialize().flatMap(event -> {
            switch (event.type) {
                case error: {
                    LOGGER.warn("Unable to build stream, promise ended with error.", (Throwable)event.error);
                }
                case complete: {
                    return Streams.empty();
                }
            }
            return Streams.just((Object[])new Object[]{event.item});
        });
    }

    static class ProbeException
    extends RuntimeException {
        final URI url;
        final String thumbprint;

        ProbeException(URI url, String thumbprint) {
            super("Cannot connect to " + url.getHost() + " over SSL. Thumbprint : " + thumbprint);
            this.url = url;
            this.thumbprint = thumbprint;
        }
    }
}

