/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim.encryption;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.encryption.CryptoKeyId;
import com.vmware.vim.binding.vim.encryption.CryptoKeyResult;
import com.vmware.vim.binding.vim.encryption.CryptoManager;
import com.vmware.vim.binding.vim.encryption.KeyProviderId;
import com.vmware.vim.binding.vim.encryption.KmipClusterInfo;
import com.vmware.vim.binding.vim.encryption.KmipServerInfo;
import com.vmware.vim.binding.vim.encryption.KmipServerSpec;
import com.vmware.vim.binding.vim.version.v7_0;
import com.vmware.vim.binding.vim.version.v8_0_1_0;
import com.vmware.vim.binding.vim.version.version11;
import com.vmware.vim.binding.vim.version.version14;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.secret;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.util.Calendar;

@fullyQualifiedVmodlName(value="vim.encryption.CryptoManagerKmip")
@managed
@versionClass(value=version11.class)
@wsdlName(value="CryptoManagerKmip")
public interface CryptoManagerKmip
extends CryptoManager {
    @readonly
    @name(value="kmipServers")
    @versionClass(value=version11.class)
    @optional
    @list
    public void getKmipServers(@optional Future<KmipClusterInfo[]> var1);

    @name(value="kmipServers")
    public KmipClusterInfo[] getKmipServers();

    @versionClass(value=version11.class)
    @wsdlName(value="GenerateClientCsr")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void generateClientCsr(@name(value="cluster") @versionClass(value=version11.class) KeyProviderId var1, @name(value="request") @versionClass(value=v8_0_1_0.class) @optional CertSignRequest var2, Future<String> var3);

    @wsdlName(value="GenerateClientCsr")
    public String generateClientCsr(KeyProviderId var1, CertSignRequest var2);

    @versionClass(value=version11.class)
    @wsdlName(value="GenerateKey")
    @privilege(value="Cryptographer.ManageKeys")
    public void generateKey(@name(value="keyProvider") @versionClass(value=version11.class) @optional KeyProviderId var1, @name(value="spec") @versionClass(value=v8_0_1_0.class) @optional CustomAttributeSpec var2, Future<CryptoKeyResult> var3);

    @wsdlName(value="GenerateKey")
    public CryptoKeyResult generateKey(KeyProviderId var1, CustomAttributeSpec var2);

    @versionClass(value=version11.class)
    @wsdlName(value="GenerateSelfSignedClientCert")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void generateSelfSignedClientCert(@name(value="cluster") @versionClass(value=version11.class) KeyProviderId var1, @name(value="request") @versionClass(value=v8_0_1_0.class) @optional CertSignRequest var2, Future<String> var3);

    @wsdlName(value="GenerateSelfSignedClientCert")
    public String generateSelfSignedClientCert(KeyProviderId var1, CertSignRequest var2);

    @versionClass(value=v7_0.class)
    @wsdlName(value="GetDefaultKmsCluster")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void getDefaultKmsCluster(@name(value="entity") @versionClass(value=v7_0.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.ManagedEntity") ManagedObjectReference var1, @name(value="defaultsToParent") @versionClass(value=v7_0.class) @optional Boolean var2, @optional Future<KeyProviderId> var3);

    @wsdlName(value="GetDefaultKmsCluster")
    @optional
    public KeyProviderId getDefaultKmsCluster(ManagedObjectReference var1, Boolean var2);

    @versionClass(value=v7_0.class)
    @wsdlName(value="IsKmsClusterActive")
    @privilege(value="Cryptographer.ManageKeyServers")
    @faults(value={"InvalidArgument"})
    public void IsKmsClusterActive(@name(value="cluster") @versionClass(value=v7_0.class) @optional KeyProviderId var1, Future<Boolean> var2);

    @wsdlName(value="IsKmsClusterActive")
    public boolean IsKmsClusterActive(KeyProviderId var1) throws InvalidArgument;

    @versionClass(value=version11.class)
    @wsdlName(value="ListKmipServers")
    @privilege(value="Cryptographer.ManageKeyServers")
    @list
    public void listKmipServers(@name(value="limit") @versionClass(value=version11.class) @optional Integer var1, @optional @list Future<KmipClusterInfo[]> var2);

    @wsdlName(value="ListKmipServers")
    @optional
    public KmipClusterInfo[] listKmipServers(Integer var1);

    @versionClass(value=v7_0.class)
    @wsdlName(value="ListKmsClusters")
    @privilege(value="Cryptographer.ManageKeyServers")
    @list
    public void listKmsClusters(@name(value="includeKmsServers") @versionClass(value=v7_0.class) @optional Boolean var1, @name(value="managementTypeFilter") @versionClass(value=v7_0.class) @optional Integer var2, @name(value="statusFilter") @versionClass(value=v7_0.class) @optional Integer var3, @optional @list Future<KmipClusterInfo[]> var4);

    @wsdlName(value="ListKmsClusters")
    @optional
    public KmipClusterInfo[] listKmsClusters(Boolean var1, Integer var2, Integer var3);

    @versionClass(value=version11.class)
    @wsdlName(value="MarkDefault")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void markDefault(@name(value="clusterId") @versionClass(value=version11.class) KeyProviderId var1, Future<Void> var2);

    @wsdlName(value="MarkDefault")
    public void markDefault(KeyProviderId var1);

    @versionClass(value=version14.class)
    @wsdlName(value="QueryCryptoKeyStatus")
    @privilege(value="Cryptographer.ManageKeys")
    @list
    public void queryCryptoKeyStatus(@name(value="keyIds") @versionClass(value=version14.class) @optional @list CryptoKeyId[] var1, @name(value="checkKeyBitMap") @versionClass(value=version14.class) int var2, @optional @list Future<CryptoKeyStatus[]> var3);

    @wsdlName(value="QueryCryptoKeyStatus")
    @optional
    public CryptoKeyStatus[] queryCryptoKeyStatus(CryptoKeyId[] var1, int var2);

    @versionClass(value=version11.class)
    @wsdlName(value="RegisterKmipServer")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void registerKmipServer(@name(value="server") @versionClass(value=version11.class) KmipServerSpec var1, Future<Void> var2);

    @wsdlName(value="RegisterKmipServer")
    public void registerKmipServer(KmipServerSpec var1);

    @versionClass(value=v7_0.class)
    @wsdlName(value="RegisterKmsCluster")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void registerKmsCluster(@name(value="clusterId") @versionClass(value=v7_0.class) KeyProviderId var1, @name(value="managementType") @versionClass(value=v7_0.class) @optional String var2, Future<Void> var3);

    @wsdlName(value="RegisterKmsCluster")
    public void registerKmsCluster(KeyProviderId var1, String var2);

    @versionClass(value=version11.class)
    @wsdlName(value="RemoveKmipServer")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void removeKmipServer(@name(value="clusterId") @versionClass(value=version11.class) KeyProviderId var1, @name(value="serverName") @versionClass(value=version11.class) String var2, Future<Void> var3);

    @wsdlName(value="RemoveKmipServer")
    public void removeKmipServer(KeyProviderId var1, String var2);

    @versionClass(value=version11.class)
    @wsdlName(value="RetrieveClientCert")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void retrieveClientCert(@name(value="cluster") @versionClass(value=version11.class) KeyProviderId var1, Future<String> var2);

    @wsdlName(value="RetrieveClientCert")
    public String retrieveClientCert(KeyProviderId var1);

    @versionClass(value=version11.class)
    @wsdlName(value="RetrieveClientCsr")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void retrieveClientCsr(@name(value="cluster") @versionClass(value=version11.class) KeyProviderId var1, Future<String> var2);

    @wsdlName(value="RetrieveClientCsr")
    public String retrieveClientCsr(KeyProviderId var1);

    @versionClass(value=version11.class)
    @wsdlName(value="RetrieveKmipServerCert")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void retrieveKmipServerCert(@name(value="keyProvider") @versionClass(value=version11.class) KeyProviderId var1, @name(value="server") @versionClass(value=version11.class) KmipServerInfo var2, Future<ServerCertInfo> var3);

    @wsdlName(value="RetrieveKmipServerCert")
    public ServerCertInfo retrieveKmipServerCert(KeyProviderId var1, KmipServerInfo var2);

    @versionClass(value=version11.class)
    @wsdlName(value="RetrieveKmipServersStatus_Task")
    @privilege(value="Cryptographer.ManageKeyServers")
    @task
    @list
    public void retrieveKmipServersStatus(@name(value="clusters") @versionClass(value=version11.class) @optional @list KmipClusterInfo[] var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @wsdlName(value="RetrieveKmipServersStatus_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference retrieveKmipServersStatus(KmipClusterInfo[] var1);

    @versionClass(value=version11.class)
    @wsdlName(value="RetrieveSelfSignedClientCert")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void retrieveSelfSignedClientCert(@name(value="cluster") @versionClass(value=version11.class) KeyProviderId var1, Future<String> var2);

    @wsdlName(value="RetrieveSelfSignedClientCert")
    public String retrieveSelfSignedClientCert(KeyProviderId var1);

    @versionClass(value=v7_0.class)
    @wsdlName(value="SetDefaultKmsCluster")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void setDefaultKmsCluster(@name(value="entity") @versionClass(value=v7_0.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.ManagedEntity") ManagedObjectReference var1, @name(value="clusterId") @versionClass(value=v7_0.class) @optional KeyProviderId var2, Future<Void> var3);

    @wsdlName(value="SetDefaultKmsCluster")
    public void setDefaultKmsCluster(ManagedObjectReference var1, KeyProviderId var2);

    @versionClass(value=v8_0_1_0.class)
    @wsdlName(value="SetKeyCustomAttributes")
    @privilege(value="Cryptographer.ManageKeys")
    public void setKeyCustomAttributes(@name(value="keyId") @versionClass(value=v8_0_1_0.class) CryptoKeyId var1, @name(value="spec") @versionClass(value=v8_0_1_0.class) CustomAttributeSpec var2, Future<CryptoKeyResult> var3);

    @wsdlName(value="SetKeyCustomAttributes")
    public CryptoKeyResult setKeyCustomAttributes(CryptoKeyId var1, CustomAttributeSpec var2);

    @versionClass(value=v7_0.class)
    @wsdlName(value="UnregisterKmsCluster")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void unregisterKmsCluster(@name(value="clusterId") @versionClass(value=v7_0.class) KeyProviderId var1, Future<Void> var2);

    @wsdlName(value="UnregisterKmsCluster")
    public void unregisterKmsCluster(KeyProviderId var1);

    @versionClass(value=version11.class)
    @wsdlName(value="UpdateKmipServer")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void updateKmipServer(@name(value="server") @versionClass(value=version11.class) KmipServerSpec var1, Future<Void> var2);

    @wsdlName(value="UpdateKmipServer")
    public void updateKmipServer(KmipServerSpec var1);

    @versionClass(value=version11.class)
    @wsdlName(value="UpdateKmsSignedCsrClientCert")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void updateKmsSignedCsrClientCert(@name(value="cluster") @versionClass(value=version11.class) KeyProviderId var1, @name(value="certificate") @versionClass(value=version11.class) String var2, Future<Void> var3);

    @wsdlName(value="UpdateKmsSignedCsrClientCert")
    public void updateKmsSignedCsrClientCert(KeyProviderId var1, String var2);

    @versionClass(value=version11.class)
    @wsdlName(value="UpdateSelfSignedClientCert")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void updateSelfSignedClientCert(@name(value="cluster") @versionClass(value=version11.class) KeyProviderId var1, @name(value="certificate") @versionClass(value=version11.class) String var2, Future<Void> var3);

    @wsdlName(value="UpdateSelfSignedClientCert")
    public void updateSelfSignedClientCert(KeyProviderId var1, String var2);

    @versionClass(value=version11.class)
    @wsdlName(value="UploadClientCert")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void uploadClientCert(@name(value="cluster") @versionClass(value=version11.class) KeyProviderId var1, @name(value="certificate") @versionClass(value=version11.class) String var2, @name(value="privateKey") @versionClass(value=version11.class) @secret String var3, Future<Void> var4);

    @wsdlName(value="UploadClientCert")
    public void uploadClientCert(KeyProviderId var1, String var2, String var3);

    @versionClass(value=version11.class)
    @wsdlName(value="UploadKmipServerCert")
    @privilege(value="Cryptographer.ManageKeyServers")
    public void uploadKmipServerCert(@name(value="cluster") @versionClass(value=version11.class) KeyProviderId var1, @name(value="certificate") @versionClass(value=version11.class) String var2, Future<Void> var3);

    @wsdlName(value="UploadKmipServerCert")
    public void uploadKmipServerCert(KeyProviderId var1, String var2);

    @versionClass(value=version11.class)
    @wsdlName(value="CryptoManagerKmipServerStatus")
    @data
    @propertyOrder(value={"name", "status", "connectionStatus", "certInfo", "clientTrustServer", "serverTrustClient"})
    public static class ServerStatus
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String name;
        public ManagedEntity.Status status;
        public String connectionStatus;
        public CertificateInfo certInfo;
        public Boolean clientTrustServer;
        public Boolean serverTrustClient;

        public ServerStatus() {
        }

        public ServerStatus(String name2, ManagedEntity.Status status, String connectionStatus, CertificateInfo certInfo, Boolean clientTrustServer, Boolean serverTrustClient) {
            this.name = name2;
            this.status = status;
            this.connectionStatus = connectionStatus;
            this.certInfo = certInfo;
            this.clientTrustServer = clientTrustServer;
            this.serverTrustClient = serverTrustClient;
        }

        @versionClass(value=version11.class)
        public String getName() {
            return this.name;
        }

        @versionClass(value=version11.class)
        public void setName(String name2) {
            this.name = name2;
        }

        @versionClass(value=version11.class)
        public ManagedEntity.Status getStatus() {
            return this.status;
        }

        @versionClass(value=version11.class)
        public void setStatus(ManagedEntity.Status status) {
            this.status = status;
        }

        @versionClass(value=version11.class)
        public String getConnectionStatus() {
            return this.connectionStatus;
        }

        @versionClass(value=version11.class)
        public void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        @optional
        @versionClass(value=version11.class)
        public CertificateInfo getCertInfo() {
            return this.certInfo;
        }

        @optional
        @versionClass(value=version11.class)
        public void setCertInfo(CertificateInfo certInfo) {
            this.certInfo = certInfo;
        }

        @optional
        @versionClass(value=version11.class)
        @Deprecated
        public Boolean isClientTrustServer() {
            return this.clientTrustServer;
        }

        @optional
        @versionClass(value=version11.class)
        public Boolean getClientTrustServer() {
            return this.clientTrustServer;
        }

        @optional
        @versionClass(value=version11.class)
        public void setClientTrustServer(Boolean clientTrustServer) {
            this.clientTrustServer = clientTrustServer;
        }

        @optional
        @versionClass(value=version11.class)
        @Deprecated
        public Boolean isServerTrustClient() {
            return this.serverTrustClient;
        }

        @optional
        @versionClass(value=version11.class)
        public Boolean getServerTrustClient() {
            return this.serverTrustClient;
        }

        @optional
        @versionClass(value=version11.class)
        public void setServerTrustClient(Boolean serverTrustClient) {
            this.serverTrustClient = serverTrustClient;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(320);
            objString.append("(vim.encryption.ServerStatus) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("name = ");
            objString.append(this.getName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("status = ");
            objString.append((Object)this.getStatus());
            objString.append(",\n");
            objString.append("   ");
            objString.append("connectionStatus = ");
            objString.append(this.getConnectionStatus());
            objString.append(",\n");
            objString.append("   ");
            objString.append("certInfo = ");
            if (this.getCertInfo() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getCertInfo()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("clientTrustServer = ");
            objString.append(this.isClientTrustServer());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serverTrustClient = ");
            objString.append(this.isServerTrustClient());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version11.class)
    @wsdlName(value="CryptoManagerKmipServerCertInfo")
    @data
    @propertyOrder(value={"certificate", "certInfo", "clientTrustServer"})
    public static class ServerCertInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String certificate;
        public CertificateInfo certInfo;
        public Boolean clientTrustServer;

        public ServerCertInfo() {
        }

        public ServerCertInfo(String certificate, CertificateInfo certInfo, Boolean clientTrustServer) {
            this.certificate = certificate;
            this.certInfo = certInfo;
            this.clientTrustServer = clientTrustServer;
        }

        @versionClass(value=version11.class)
        public String getCertificate() {
            return this.certificate;
        }

        @versionClass(value=version11.class)
        public void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @optional
        @versionClass(value=version11.class)
        public CertificateInfo getCertInfo() {
            return this.certInfo;
        }

        @optional
        @versionClass(value=version11.class)
        public void setCertInfo(CertificateInfo certInfo) {
            this.certInfo = certInfo;
        }

        @optional
        @versionClass(value=version11.class)
        @Deprecated
        public Boolean isClientTrustServer() {
            return this.clientTrustServer;
        }

        @optional
        @versionClass(value=version11.class)
        public Boolean getClientTrustServer() {
            return this.clientTrustServer;
        }

        @optional
        @versionClass(value=version11.class)
        public void setClientTrustServer(Boolean clientTrustServer) {
            this.clientTrustServer = clientTrustServer;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(vim.encryption.ServerCertInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("certificate = ");
            objString.append(this.getCertificate());
            objString.append(",\n");
            objString.append("   ");
            objString.append("certInfo = ");
            if (this.getCertInfo() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getCertInfo()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("clientTrustServer = ");
            objString.append(this.isClientTrustServer());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=v8_0_1_0.class)
    @wsdlName(value="CryptoManagerKmipCustomAttributeSpec")
    @data
    @propertyOrder(value={"attributes"})
    public static class CustomAttributeSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public KeyValue[] attributes;

        public CustomAttributeSpec() {
        }

        public CustomAttributeSpec(KeyValue[] attributes) {
            this.attributes = attributes;
        }

        @map
        @optional
        @versionClass(value=v8_0_1_0.class)
        public KeyValue[] getAttributes() {
            return this.attributes;
        }

        @map
        @optional
        @versionClass(value=v8_0_1_0.class)
        public void setAttributes(KeyValue[] attributes) {
            this.attributes = attributes;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(120);
            objString.append("(vim.encryption.CustomAttributeSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("attributes = ");
            if (this.getAttributes() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.KeyValue) [\n");
                for (i = 0; i < this.getAttributes().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getAttributes()[i]), (boolean)true));
                    if (i < this.getAttributes().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version14.class)
    @wsdlName(value="CryptoManagerKmipCryptoKeyStatus")
    @data
    @propertyOrder(value={"keyId", "keyAvailable", "reason", "encryptedVMs", "affectedHosts", "referencedByTags"})
    public static class CryptoKeyStatus
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public CryptoKeyId keyId;
        public Boolean keyAvailable;
        public String reason;
        public ManagedObjectReference[] encryptedVMs;
        public ManagedObjectReference[] affectedHosts;
        public String[] referencedByTags;

        public CryptoKeyStatus() {
        }

        public CryptoKeyStatus(CryptoKeyId keyId, Boolean keyAvailable, String reason, ManagedObjectReference[] encryptedVMs, ManagedObjectReference[] affectedHosts, String[] referencedByTags) {
            this.keyId = keyId;
            this.keyAvailable = keyAvailable;
            this.reason = reason;
            this.encryptedVMs = encryptedVMs;
            this.affectedHosts = affectedHosts;
            this.referencedByTags = referencedByTags;
        }

        @versionClass(value=version14.class)
        public CryptoKeyId getKeyId() {
            return this.keyId;
        }

        @versionClass(value=version14.class)
        public void setKeyId(CryptoKeyId keyId) {
            this.keyId = keyId;
        }

        @optional
        @versionClass(value=version14.class)
        @Deprecated
        public Boolean isKeyAvailable() {
            return this.keyAvailable;
        }

        @optional
        @versionClass(value=version14.class)
        public Boolean getKeyAvailable() {
            return this.keyAvailable;
        }

        @optional
        @versionClass(value=version14.class)
        public void setKeyAvailable(Boolean keyAvailable) {
            this.keyAvailable = keyAvailable;
        }

        @optional
        @versionClass(value=version14.class)
        public String getReason() {
            return this.reason;
        }

        @optional
        @versionClass(value=version14.class)
        public void setReason(String reason) {
            this.reason = reason;
        }

        @managedObjectType(value="com.vmware.vim.binding.vim.VirtualMachine")
        @map
        @optional
        @versionClass(value=version14.class)
        public ManagedObjectReference[] getEncryptedVMs() {
            return this.encryptedVMs;
        }

        @managedObjectType(value="com.vmware.vim.binding.vim.VirtualMachine")
        @map
        @optional
        @versionClass(value=version14.class)
        public void setEncryptedVMs(ManagedObjectReference[] encryptedVMs) {
            this.encryptedVMs = encryptedVMs;
        }

        @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem")
        @map
        @optional
        @versionClass(value=version14.class)
        public ManagedObjectReference[] getAffectedHosts() {
            return this.affectedHosts;
        }

        @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem")
        @map
        @optional
        @versionClass(value=version14.class)
        public void setAffectedHosts(ManagedObjectReference[] affectedHosts) {
            this.affectedHosts = affectedHosts;
        }

        @map
        @optional
        @versionClass(value=version14.class)
        public String[] getReferencedByTags() {
            return this.referencedByTags;
        }

        @map
        @optional
        @versionClass(value=version14.class)
        public void setReferencedByTags(String[] referencedByTags) {
            this.referencedByTags = referencedByTags;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(320);
            objString.append("(vim.encryption.CryptoKeyStatus) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("keyId = ");
            if (this.getKeyId() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getKeyId()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("keyAvailable = ");
            objString.append(this.isKeyAvailable());
            objString.append(",\n");
            objString.append("   ");
            objString.append("reason = ");
            objString.append(this.getReason());
            objString.append(",\n");
            objString.append("   ");
            objString.append("encryptedVMs = ");
            if (this.getEncryptedVMs() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.VirtualMachine) [\n");
                for (i = 0; i < this.getEncryptedVMs().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getEncryptedVMs()[i]), (boolean)true));
                    if (i < this.getEncryptedVMs().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("affectedHosts = ");
            if (this.getAffectedHosts() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.HostSystem) [\n");
                for (i = 0; i < this.getAffectedHosts().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getAffectedHosts()[i]), (boolean)true));
                    if (i < this.getAffectedHosts().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("referencedByTags = ");
            if (this.getReferencedByTags() == null) {
                objString.append("null");
            } else {
                objString.append("(STRING) [\n");
                for (i = 0; i < this.getReferencedByTags().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getReferencedByTags()[i]);
                    if (i < this.getReferencedByTags().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version14.class)
        @wsdlName(value="CryptoManagerKmipCryptoKeyStatusKeyUnavailableReason")
        public static enum KeyUnavailableReason {
            KeyStateMissingInCache,
            KeyStateClusterInvalid,
            KeyStateClusterUnreachable,
            KeyStateMissingInKMS,
            KeyStateNotActiveOrEnabled,
            KeyStateManagedByTrustAuthority;

        }
    }

    @versionClass(value=version11.class)
    @wsdlName(value="CryptoManagerKmipClusterStatus")
    @data
    @propertyOrder(value={"clusterId", "overallStatus", "managementType", "servers", "clientCertInfo"})
    public static class ClusterStatus
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public KeyProviderId clusterId;
        public ManagedEntity.Status overallStatus;
        public String managementType;
        public ServerStatus[] servers;
        public CertificateInfo clientCertInfo;

        public ClusterStatus() {
        }

        public ClusterStatus(KeyProviderId clusterId, ManagedEntity.Status overallStatus, String managementType, ServerStatus[] servers, CertificateInfo clientCertInfo) {
            this.clusterId = clusterId;
            this.overallStatus = overallStatus;
            this.managementType = managementType;
            this.servers = servers;
            this.clientCertInfo = clientCertInfo;
        }

        @versionClass(value=version11.class)
        public KeyProviderId getClusterId() {
            return this.clusterId;
        }

        @versionClass(value=version11.class)
        public void setClusterId(KeyProviderId clusterId) {
            this.clusterId = clusterId;
        }

        @optional
        @versionClass(value=v7_0.class)
        public ManagedEntity.Status getOverallStatus() {
            return this.overallStatus;
        }

        @optional
        @versionClass(value=v7_0.class)
        public void setOverallStatus(ManagedEntity.Status overallStatus) {
            this.overallStatus = overallStatus;
        }

        @optional
        @versionClass(value=v7_0.class)
        public String getManagementType() {
            return this.managementType;
        }

        @optional
        @versionClass(value=v7_0.class)
        public void setManagementType(String managementType) {
            this.managementType = managementType;
        }

        @list
        @versionClass(value=version11.class)
        public ServerStatus[] getServers() {
            return this.servers;
        }

        @list
        @versionClass(value=version11.class)
        public void setServers(ServerStatus[] servers) {
            this.servers = servers;
        }

        @optional
        @versionClass(value=version11.class)
        public CertificateInfo getClientCertInfo() {
            return this.clientCertInfo;
        }

        @optional
        @versionClass(value=version11.class)
        public void setClientCertInfo(CertificateInfo clientCertInfo) {
            this.clientCertInfo = clientCertInfo;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(280);
            objString.append("(vim.encryption.ClusterStatus) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("clusterId = ");
            if (this.getClusterId() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getClusterId()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("overallStatus = ");
            objString.append((Object)this.getOverallStatus());
            objString.append(",\n");
            objString.append("   ");
            objString.append("managementType = ");
            objString.append(this.getManagementType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("servers = ");
            if (this.getServers() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.encryption.ServerStatus) [\n");
                for (i = 0; i < this.getServers().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getServers()[i]), (boolean)true));
                    if (i < this.getServers().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("clientCertInfo = ");
            if (this.getClientCertInfo() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getClientCertInfo()), (boolean)false));
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version11.class)
    @wsdlName(value="CryptoManagerKmipCertificateInfo")
    @data
    @propertyOrder(value={"subject", "issuer", "serialNumber", "notBefore", "notAfter", "fingerprint", "checkTime", "secondsSinceValid", "secondsBeforeExpire"})
    public static class CertificateInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String subject;
        public String issuer;
        public String serialNumber;
        public Calendar notBefore;
        public Calendar notAfter;
        public String fingerprint;
        public Calendar checkTime;
        public Integer secondsSinceValid;
        public Integer secondsBeforeExpire;

        public CertificateInfo() {
        }

        public CertificateInfo(String subject, String issuer, String serialNumber, Calendar notBefore, Calendar notAfter, String fingerprint, Calendar checkTime, Integer secondsSinceValid, Integer secondsBeforeExpire) {
            this.subject = subject;
            this.issuer = issuer;
            this.serialNumber = serialNumber;
            this.notBefore = notBefore;
            this.notAfter = notAfter;
            this.fingerprint = fingerprint;
            this.checkTime = checkTime;
            this.secondsSinceValid = secondsSinceValid;
            this.secondsBeforeExpire = secondsBeforeExpire;
        }

        @versionClass(value=version11.class)
        public String getSubject() {
            return this.subject;
        }

        @versionClass(value=version11.class)
        public void setSubject(String subject) {
            this.subject = subject;
        }

        @versionClass(value=version11.class)
        public String getIssuer() {
            return this.issuer;
        }

        @versionClass(value=version11.class)
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @versionClass(value=version11.class)
        public String getSerialNumber() {
            return this.serialNumber;
        }

        @versionClass(value=version11.class)
        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @versionClass(value=version11.class)
        public Calendar getNotBefore() {
            return this.notBefore;
        }

        @versionClass(value=version11.class)
        public void setNotBefore(Calendar notBefore) {
            this.notBefore = notBefore;
        }

        @versionClass(value=version11.class)
        public Calendar getNotAfter() {
            return this.notAfter;
        }

        @versionClass(value=version11.class)
        public void setNotAfter(Calendar notAfter) {
            this.notAfter = notAfter;
        }

        @versionClass(value=version11.class)
        public String getFingerprint() {
            return this.fingerprint;
        }

        @versionClass(value=version11.class)
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @versionClass(value=version11.class)
        public Calendar getCheckTime() {
            return this.checkTime;
        }

        @versionClass(value=version11.class)
        public void setCheckTime(Calendar checkTime) {
            this.checkTime = checkTime;
        }

        @optional
        @versionClass(value=version11.class)
        public Integer getSecondsSinceValid() {
            return this.secondsSinceValid;
        }

        @optional
        @versionClass(value=version11.class)
        public void setSecondsSinceValid(Integer secondsSinceValid) {
            this.secondsSinceValid = secondsSinceValid;
        }

        @optional
        @versionClass(value=version11.class)
        public Integer getSecondsBeforeExpire() {
            return this.secondsBeforeExpire;
        }

        @optional
        @versionClass(value=version11.class)
        public void setSecondsBeforeExpire(Integer secondsBeforeExpire) {
            this.secondsBeforeExpire = secondsBeforeExpire;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(440);
            objString.append("(vim.encryption.CertificateInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("subject = ");
            objString.append(this.getSubject());
            objString.append(",\n");
            objString.append("   ");
            objString.append("issuer = ");
            objString.append(this.getIssuer());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serialNumber = ");
            objString.append(this.getSerialNumber());
            objString.append(",\n");
            objString.append("   ");
            objString.append("notBefore = ");
            objString.append(this.getNotBefore());
            objString.append(",\n");
            objString.append("   ");
            objString.append("notAfter = ");
            objString.append(this.getNotAfter());
            objString.append(",\n");
            objString.append("   ");
            objString.append("fingerprint = ");
            objString.append(this.getFingerprint());
            objString.append(",\n");
            objString.append("   ");
            objString.append("checkTime = ");
            objString.append(this.getCheckTime());
            objString.append(",\n");
            objString.append("   ");
            objString.append("secondsSinceValid = ");
            objString.append(this.getSecondsSinceValid());
            objString.append(",\n");
            objString.append("   ");
            objString.append("secondsBeforeExpire = ");
            objString.append(this.getSecondsBeforeExpire());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=v8_0_1_0.class)
    @wsdlName(value="CryptoManagerKmipCertSignRequest")
    @data
    @propertyOrder(value={"commonName", "organization", "organizationUnit", "locality", "state", "country", "email"})
    public static class CertSignRequest
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String commonName;
        public String organization;
        public String organizationUnit;
        public String locality;
        public String state;
        public String country;
        public String email;

        public CertSignRequest() {
        }

        public CertSignRequest(String commonName, String organization, String organizationUnit, String locality, String state, String country, String email) {
            this.commonName = commonName;
            this.organization = organization;
            this.organizationUnit = organizationUnit;
            this.locality = locality;
            this.state = state;
            this.country = country;
            this.email = email;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public String getCommonName() {
            return this.commonName;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public String getOrganization() {
            return this.organization;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public void setOrganization(String organization) {
            this.organization = organization;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public String getOrganizationUnit() {
            return this.organizationUnit;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public void setOrganizationUnit(String organizationUnit) {
            this.organizationUnit = organizationUnit;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public String getLocality() {
            return this.locality;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public void setLocality(String locality) {
            this.locality = locality;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public String getState() {
            return this.state;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public void setState(String state) {
            this.state = state;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public String getCountry() {
            return this.country;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public void setCountry(String country) {
            this.country = country;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public String getEmail() {
            return this.email;
        }

        @optional
        @versionClass(value=v8_0_1_0.class)
        public void setEmail(String email) {
            this.email = email;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(360);
            objString.append("(vim.encryption.CertSignRequest) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("commonName = ");
            objString.append(this.getCommonName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("organization = ");
            objString.append(this.getOrganization());
            objString.append(",\n");
            objString.append("   ");
            objString.append("organizationUnit = ");
            objString.append(this.getOrganizationUnit());
            objString.append(",\n");
            objString.append("   ");
            objString.append("locality = ");
            objString.append(this.getLocality());
            objString.append(",\n");
            objString.append("   ");
            objString.append("state = ");
            objString.append(this.getState());
            objString.append(",\n");
            objString.append("   ");
            objString.append("country = ");
            objString.append(this.getCountry());
            objString.append(",\n");
            objString.append("   ");
            objString.append("email = ");
            objString.append(this.getEmail());
            objString.append("\n}");
            return objString.toString();
        }
    }
}

