/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PluginVersion {
    private static final String VERSION_PROPS = "plugin-version.properties";
    private static final String DEFAULT_VERSION = "8.7.0";
    private static final Integer DEFAULT_BUILD_NUMBER = 0;
    private static final String VERSION;
    private static final String BUILD_NUMBER;

    public static String getVersion() {
        return VERSION;
    }

    public static String getBuildNumber() {
        return BUILD_NUMBER;
    }

    private static Properties tryLoad(Properties defaults) {
        Properties props = new Properties(defaults);
        ClassLoader thisLoader = PluginVersion.class.getClassLoader();
        InputStream versionPropsStream = thisLoader.getResourceAsStream(VERSION_PROPS);
        if (versionPropsStream == null) {
            PluginVersion.printError("Unable to load resource file", new FileNotFoundException(VERSION_PROPS));
            return props;
        }
        try (InputStream is = versionPropsStream;){
            props.load(is);
        }
        catch (IOException e) {
            PluginVersion.printError("Unable to load resource file", e);
        }
        return props;
    }

    private static Integer tryParseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            String msg = String.format("Unable to parse '%s' as integer.", value);
            PluginVersion.printError(msg, nfe);
            return defaultValue;
        }
    }

    private static void printError(String msg, Exception exc) {
        System.out.println(msg);
        exc.printStackTrace(System.out);
    }

    static {
        Properties props = new Properties();
        props.setProperty("version", DEFAULT_VERSION);
        props.setProperty("buildNumber", DEFAULT_BUILD_NUMBER.toString());
        props = PluginVersion.tryLoad(props);
        VERSION = props.getProperty("version");
        BUILD_NUMBER = PluginVersion.tryParseInt(props.getProperty("buildNumber"), DEFAULT_BUILD_NUMBER).toString();
    }
}

