/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.pbm;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.pbm.SpbmService;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.FixedVersionServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.HttpConfigManagerUtils;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.ManagedObjectProxy;
import com.vmware.vim.binding.pbm.ServiceInstance;
import com.vmware.vim.binding.pbm.ServiceInstanceContent;
import com.vmware.vim.binding.pbm.version.internal.version11;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.KeyStore;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;

public class SpbmServiceImpl
extends FixedVersionServiceImpl<ServiceInstance, ServiceInstanceContent>
implements SpbmService {
    public static final Class<? extends Annotation> VERSION = version11.class;
    public static final ManagedObjectReference SERVICE_INSTANCE;
    public static final VmodlContextInitializer VMODL_INIT;
    private static final String VC_SESSION_COOKIE = "vcSessionCookie";
    private final Supplier<Promise<String>> _vcSessionSupplier;
    private volatile String _currentVcSession;

    public SpbmServiceImpl(URI server, KeyStore store, TokenProvider tokenProvider, Supplier<Promise<String>> vcSessionSupplier) {
        super(server, HttpConfigManagerUtils.COMMON_MANAGER.getConfiguration(), VMODL_INIT, tokenProvider, SERVICE_INSTANCE, "Storage Policy Server", VERSION);
        Validate.notNull(vcSessionSupplier, (String)"vcSessionSupplier");
        this._vcSessionSupplier = vcSessionSupplier;
        HttpConfigManagerUtils.COMMON_MANAGER.addThumbprints(store);
    }

    @Override
    public <T extends ManagedObject> T createStub(ManagedObjectReference moRef) {
        Object stub = super.createStub(moRef);
        String vcSession = this._currentVcSession;
        if (vcSession != null) {
            RequestContextImpl rc = new RequestContextImpl();
            rc.put((Object)VC_SESSION_COOKIE, (Object)vcSession);
            ((Stub)stub)._setRequestContext((RequestContext)rc);
        }
        return stub;
    }

    @Override
    protected String getServerGuid(ServiceInstanceContent content) {
        return content.getAboutInfo().getInstanceUuid();
    }

    @Override
    protected Promise<ServiceInstanceContent> retrieveContent(ServiceInstance serviceInstance) {
        FuturePromise result = new FuturePromise();
        serviceInstance.retrieveContent((Future)result);
        return result;
    }

    @Override
    protected Promise<Void> login(ServiceInstanceContent content, String locale) {
        return this._vcSessionSupplier.get().thenCompose(vcSession -> this.createFreeStub(SERVICE_INSTANCE).thenCompose(si -> {
            RequestContextImpl rc = new RequestContextImpl();
            rc.put((Object)VC_SESSION_COOKIE, vcSession);
            ((Stub)si)._setRequestContext((RequestContext)rc);
            FuturePromise fp = new FuturePromise();
            si.getPbmDebugManager((Future)fp);
            return fp.thenApply(unused -> {
                this._currentVcSession = vcSession;
                return null;
            });
        }));
    }

    @Override
    protected Promise<Void> logout(ServiceInstanceContent content) {
        this._currentVcSession = null;
        return Promises.resolve(null);
    }

    @Override
    protected boolean retryOnError(Exception err) {
        return err instanceof SecurityError;
    }

    @Override
    protected Promise<Boolean> shouldRetryRequest(ManagedObjectProxy moProxy, ManagedObject mo, Method method, Map<String, Object> context, Exception err, int failedTries) {
        return super.shouldRetryRequest(moProxy, mo, method, context, err, failedTries).thenApply(retry -> {
            if (retry.booleanValue()) {
                RequestContextImpl rc = new RequestContextImpl();
                rc.put((Object)VC_SESSION_COOKIE, (Object)this._currentVcSession);
                moProxy._setRequestContext((RequestContext)rc);
            }
            return retry;
        });
    }

    static {
        VmodlContext context = VmodlContext.initContext((String[])new String[0], (boolean)false);
        VMODL_INIT = new VmodlContextInitializer(context, VERSION);
        SERVICE_INSTANCE = ClientUtils.createMoRef("PbmServiceInstance", "ServiceInstance", null);
    }
}

