/*
 * Decompiled with CFR 0.152.
 */
package emitters.backend;

import emitters.backend.FssConfig;
import emitters.model.Entity;
import emitters.model.Product;
import emitters.model.SourcePos;
import emitters.model.VmodlObject;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Map;

public abstract class Platform {
    protected static String _outputPathPrefix = "";
    private static Platform _instance;

    public static Map<String, String> getOptions() {
        return _instance.getOptionsImpl();
    }

    public static void printError(String msg) {
        _instance.printErrorImpl(msg);
    }

    public static void printWarning(String msg) {
        _instance.printWarningImpl(msg);
    }

    public static PrintWriter createTextFile(File file) {
        return _instance.createTextFileImpl(file);
    }

    public static SourcePos getSourcePos(String fullName) {
        return _instance.getSourcePosImpl(fullName);
    }

    public static SourcePos getSourcePos(VmodlObject obj) {
        SourcePos result = obj.getSourcePos();
        if (result == null) {
            result = _instance.getSourcePosImpl(obj);
            obj.setSourcePos(result);
        }
        return result;
    }

    public static SourcePos getSourcePos(VmodlObject obj, Entity entity) {
        SourcePos result = entity.getSourcePos();
        if (result == null) {
            result = _instance.getSourcePosImpl(obj, entity.getName());
            entity.setSourcePos(result);
        }
        return result;
    }

    public static File getFileHandle(String filename) {
        return new File(_outputPathPrefix + filename);
    }

    public static FssConfig fetchFssConfig(String configClass) {
        String errmsg;
        String methodName = "getFssConfig";
        try {
            Class<?> klass = Class.forName(configClass);
            Method method = klass.getDeclaredMethod(methodName, new Class[0]);
            Object result = method.invoke(null, new Object[0]);
            return (FssConfig)result;
        }
        catch (ClassNotFoundException e) {
            errmsg = "class not found (" + e.getMessage() + ")";
        }
        catch (NoSuchMethodException e) {
            errmsg = "method " + methodName + " not found (" + e.getMessage() + ")";
        }
        catch (IllegalAccessException e) {
            errmsg = "illegal access to " + methodName + "(" + e.getMessage() + ")";
        }
        catch (Exception e) {
            errmsg = "general failure (" + e.getMessage() + ")";
        }
        throw new RuntimeException("Can't fetch FSS config from " + configClass + ":  " + errmsg);
    }

    public static boolean builtOnMain() {
        Product product = Product.products.get("vSphere");
        return product != null ? !product.getFssConfig().isFrozen() : true;
    }

    protected static void init(Platform instance) {
        _instance = instance;
    }

    protected abstract Map<String, String> getOptionsImpl();

    protected abstract void printErrorImpl(String var1);

    protected abstract void printWarningImpl(String var1);

    protected abstract PrintWriter createTextFileImpl(File var1);

    protected abstract SourcePos getSourcePosImpl(String var1);

    protected abstract SourcePos getSourcePosImpl(VmodlObject var1);

    protected abstract SourcePos getSourcePosImpl(VmodlObject var1, String var2);
}

