/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.model.DataObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import emitters.model.raw.RawObject;
import emitters.model.raw.RawVersion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManagedObject
extends VmodlObject {
    private List<Method> _methodList = new ArrayList<Method>();
    private List<Method> _enabledMethodList;
    private boolean _isSessionSpecific;

    public ManagedObject(RawObject rawObject, RawVersion rawVersion) {
        super(rawObject, rawVersion);
        this._isSessionSpecific = rawObject.isSessionSpecific();
    }

    public void addMethod(Method method) {
        for (Method meth : this._methodList) {
            if (!meth.getName().equals(method.getName())) continue;
            throw new RuntimeException(String.format("Overloaded methods not allowed in '%s'", method.getName()));
        }
        this._methodList.add(method);
    }

    @Override
    public void setupEnabledLists() {
        super.setupEnabledLists();
        if (this._enabledMethodList == null) {
            this._enabledMethodList = new ArrayList<Method>();
            for (Method method : this._methodList) {
                if (method.getVersion().getKind() == Version.Kind.DISABLED) continue;
                this._enabledMethodList.add(method);
            }
        }
    }

    public List<Method> getMethodList() {
        return this._methodList;
    }

    public List<Method> getEnabledMethodList() {
        return this._enabledMethodList;
    }

    public List<Method> getFullMethodList() {
        return this.getFullMethodList(this.getQualifiedVmodlType());
    }

    private List<Method> getFullMethodList(String forClass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        if (this._base != null) {
            ManagedObject baseMobj = (ManagedObject)this._base;
            methods.addAll(baseMobj.getFullMethodList(forClass));
        }
        for (Method method : this._methodList) {
            String privId;
            Map<String, String> subclassPrivs = method.getSubclassPrivileges();
            if (subclassPrivs != null && (privId = subclassPrivs.get(forClass)) != null) {
                methods.add(new Method(method, privId));
                continue;
            }
            methods.add(method);
        }
        return methods;
    }

    public boolean isSessionSpecific() {
        return this._isSessionSpecific;
    }

    @Override
    public VmodlObject.Kind getKind() {
        return VmodlObject.Kind.ManagedObject;
    }

    public Set<VmodlDecl> getReferencedDecls(boolean wantFaults) {
        return this.getReferencedDecls(wantFaults, true);
    }

    public Set<VmodlDecl> getReferencedDecls(boolean wantFaults, boolean wantRetTypes) {
        HashSet<VmodlDecl> declSet = new HashSet<VmodlDecl>();
        for (Property p : this._propertyList) {
            declSet.add(p.getDecl());
        }
        for (Method m : this._methodList) {
            if (wantRetTypes) {
                declSet.add(m.getReturnDecl());
                if (m.isTask()) {
                    declSet.add(Method.taskReturnDecl());
                }
            }
            for (Parameter parameter : m.getParameterList()) {
                declSet.add(parameter.getDecl());
            }
            if (!wantFaults) continue;
            for (DataObject dataObject : m.getFaultList()) {
                declSet.add(new VmodlDecl(VmodlDecl.TypeId.DATA, dataObject));
            }
        }
        return declSet;
    }

    @Override
    public void enqueueDigest() {
        super.enqueueDigest();
        for (Method method : this._methodList) {
            method.enqueueDigest();
        }
    }

    @Override
    public void print() {
        super.print();
        System.out.println("Methods:");
        for (Method method : this._methodList) {
            method.print();
        }
        System.out.println("Enabled methods:");
        if (this._enabledMethodList != null) {
            for (Method method : this._enabledMethodList) {
                method.print();
            }
        }
        System.out.println("Is session-specific: " + this._isSessionSpecific);
    }
}

