/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.vmomi.core.types.impl.VmodlContextLoader;
import com.vmware.vim.vmomi.core.util.ClassUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;

class SpringContextLoader {
    private static final Log _logger = LogFactory.getLog(SpringContextLoader.class);
    private static final String CONTEXT_FILE = "/context.xml";
    private static final String CONTEXT_FILE_V2 = "/context_v2.xml";
    private static final String CONTEXT_BEAN_NAME = "context";

    SpringContextLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static VmodlContextLoader load(String vmodlPackage) {
        String contextPath = SpringContextLoader.getContextFileNameForPackage(vmodlPackage);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Loading vmodl context %s from %s", vmodlPackage, ClassUtil.getCurrentClassLoader().getResource(contextPath)));
        }
        try (NonValidatingClassPathXmlApplicationContext ctx = new NonValidatingClassPathXmlApplicationContext(contextPath);){
            VmodlContextLoader vmodlContextLoader = (VmodlContextLoader)ctx.getBean(CONTEXT_BEAN_NAME);
            return vmodlContextLoader;
        }
    }

    private static String getContextFileNameForPackage(String packageName) {
        String contextPath = SpringContextLoader.getContextFileNameForPackage(packageName, CONTEXT_FILE_V2);
        if (ClassUtil.getCurrentClassLoader().getResource(contextPath) == null) {
            contextPath = SpringContextLoader.getContextFileNameForPackage(packageName, CONTEXT_FILE);
        }
        return contextPath;
    }

    private static String getContextFileNameForPackage(String packageName, String contextFile) {
        return packageName.replace('.', '/') + contextFile;
    }

    private static class NonValidatingClassPathXmlApplicationContext
    extends ClassPathXmlApplicationContext {
        NonValidatingClassPathXmlApplicationContext(String contextPath) {
            super(contextPath);
        }

        protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
            super.initBeanDefinitionReader(beanDefinitionReader);
            beanDefinitionReader.setValidationMode(0);
        }
    }
}

