/*
 * Decompiled with CFR 0.152.
 */
package dochandling;

import dochandling.JavadocProcessor;
import dochandling.MethodComment;
import dochandling.PropertyComment;
import dochandling.TypeComment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class StandardProcessor
implements JavadocProcessor {
    @Override
    public void processMethodComment(String comment, MethodComment methodComment) {
        this.processPropertyComment(comment, methodComment);
        methodComment.addParameters(this.getTagPairData("param", methodComment.getTags()));
        methodComment.addExceptions(this.getTagPairData("exception", methodComment.getTags()));
        methodComment.addExceptions(this.getTagPairData("throws", methodComment.getTags()));
    }

    @Override
    public void processPropertyComment(String comment, PropertyComment propComment) {
        this.processTypeComment(comment, propComment);
        Collection<String> data = this.getTagData("return", propComment.getTags());
        Iterator<String> i = data.iterator();
        if (i.hasNext()) {
            propComment.setReturnHtml(i.next());
        }
        if ((i = (data = this.getTagData("task", propComment.getTags())).iterator()).hasNext()) {
            propComment.setTaskHtml(i.next());
        }
    }

    @Override
    public void processTypeComment(String comment, TypeComment typeComment) {
        typeComment.setTags(this.getTags(comment));
        if (!typeComment.getTags()[0].startsWith("@")) {
            typeComment.setHtml(typeComment.getTags()[0]);
        }
        typeComment.setAuthors(this.getTagData("author", typeComment.getTags()));
        typeComment.setDeprecated(this.getTagData("deprecated", typeComment.getTags()));
        typeComment.setSeeAlsos(this.getTagData("see", typeComment.getTags()));
        typeComment.setSinces(this.getTagData("since", typeComment.getTags()));
        typeComment.setVersions(this.getTagData("version", typeComment.getTags()));
    }

    private Collection<String> getTagData(String tagText, String[] tags) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String line : tags) {
            if (line.startsWith("@")) {
                line = line.substring(1);
            }
            if (!line.startsWith(tagText)) continue;
            ret.add(line.substring(tagText.length()).trim());
        }
        return ret;
    }

    private Collection<JavadocProcessor.Pair<String, String>> getTagPairData(String tagText, String[] tags) {
        ArrayList<JavadocProcessor.Pair<String, String>> ret = new ArrayList<JavadocProcessor.Pair<String, String>>();
        for (String line : tags) {
            if (line.startsWith("@")) {
                line = line.substring(1);
            }
            if (!line.startsWith(tagText)) continue;
            JavadocProcessor.Pair pair = new JavadocProcessor.Pair();
            pair.first = "";
            pair.second = "";
            String tag = line.substring(tagText.length()).trim();
            String[] thePair = tag.split("\\s", 2);
            if (thePair.length > 0) {
                pair.first = thePair[0].trim();
                if (thePair.length > 1) {
                    pair.second = thePair[1].trim();
                }
            }
            ret.add(pair);
        }
        return ret;
    }

    private String[] getTags(String comment) {
        if (comment == null) {
            return new String[]{""};
        }
        String[] tags = comment.split("^|\\s@");
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tags[i].trim();
            if (tags[i].length() <= 0) continue;
            strings.add(tags[i]);
        }
        if (strings.size() == 0) {
            return new String[]{""};
        }
        return strings.toArray(new String[0]);
    }
}

