/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.cpp;

import emitters.bindings.cpp.PrivilegeValidator;
import emitters.model.Privilege;
import java.util.Map;

public class CppPrivilegeEmitter
extends PrivilegeValidator {
    public CppPrivilegeEmitter(Map<String, String> options, String filename) {
        super(options, filename);
    }

    private String GetPrivilegeConstant(String privilegeId) {
        return "PRIV_" + privilegeId.toUpperCase().replaceAll("\\.", "_");
    }

    @Override
    public void emitPrivileges() {
        String privConstant;
        this.emitLine("/******* AUTOMATICALLY GENERATED CODE - DO NOT EDIT *******/");
        this.emitLine("#pragma once");
        this.emitLine();
        this.emitLine("#include <vmacore/authorizebase.h>");
        this.emitLine();
        this.emitLine("namespace Vim {");
        this.emitLine("namespace Privilege {");
        this.emitLine();
        this.emitLine("struct Entry {");
        this.emitLine("\tconst char *privId;");
        this.emitLine("\tbool isOnParent;");
        this.emitLine("};");
        this.emitLine();
        this.emitLine("#ifdef _WIN32");
        this.emitLine("#define VIM_PRIV_LINKAGE extern __declspec(selectany)");
        this.emitLine("#else");
        this.emitLine("#define VIM_PRIV_LINKAGE static");
        this.emitLine("#endif");
        for (Privilege priv : this._privList) {
            privConstant = this.GetPrivilegeConstant(priv.GetId());
            this.emitLine("VIM_PRIV_LINKAGE const char * const " + privConstant + " = \"" + priv.GetId() + "\";");
        }
        this.emitLine();
        this.emitLine("static const size_t kPrivCount = " + this._privList.size() + ";");
        this.emitLine("VIM_PRIV_LINKAGE const Entry sPrivileges[" + this._privList.size() + "] = {", INDENT);
        for (Privilege priv : this._privList) {
            privConstant = this.GetPrivilegeConstant(priv.GetId());
            this.emitLine("{ " + privConstant + ", " + (priv.IsOnParent() ? "true" : "false") + " },");
        }
        this.emitLine(UNINDENT, "};");
        this.emitLine();
        this.emitLine("class ProviderBase : public Vmacore::Authorize::AppModelProvider {");
        this.emitLine("public:", INDENT);
        this.emitLine("void GetPrivileges(std::list<Vmacore::Authorize::PrivilegeDef>& privs) override {", INDENT);
        this.emitLine("for (size_t i = 0; i < kPrivCount; ++i) {", INDENT);
        this.emitLine("const std::string& pId = sPrivileges[i].privId;");
        this.emitLine("const size_t pos = pId.rfind('.');");
        this.emitLine("privs.push_back(Vmacore::Authorize::PrivilegeDef(");
        this.emitLine("   pId, pId.substr(0, pos), sPrivileges[i].isOnParent));");
        this.emitLine(UNINDENT, "}");
        this.emitLine(UNINDENT, "}");
        this.emitLine(UNINDENT, "};");
        this.emitLine();
        this.emitLine("} // namespace Privilege");
        this.emitLine("} // namespace Vim");
        this.emitLine();
        this.emitLine("namespace Vmacore { namespace Authorize {");
        this.emitLine("using namespace Vim::Privilege;");
        this.emitLine("typedef Vim::Privilege::ProviderBase VmomiPrivileges;");
        this.emitLine("} }");
    }
}

