/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.gobject;

import emitters.bindings.gobject.GObjectEmitter;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.Field;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GObjectImplementationEmitter
extends GObjectEmitter {
    private final String _directory;
    private final String _headerDirectory;
    private final String _packageName;
    private List<String> _includeList = new ArrayList<String>();

    public GObjectImplementationEmitter(Map<String, String> options, String directory) {
        this._directory = directory;
        this._headerDirectory = options.get("header.dir");
        if (this._headerDirectory == null) {
            throw new RuntimeException("The header dir in mandatory for C emitters");
        }
        this._packageName = options.get("package.name");
        if (this._packageName == null) {
            throw new RuntimeException("The package name in mandatory for C emitters");
        }
        String includeList = options.get("include");
        if (includeList != null) {
            for (String header : includeList.split(",")) {
                this._includeList.add(header);
            }
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        ArrayList<VmodlObject> allObjects = new ArrayList<VmodlObject>();
        allObjects.addAll(objects);
        allObjects.addAll(this.collectNestedObjects(objects));
        objects = allObjects;
        for (VmodlObject obj : objects) {
            this.beginFile(obj);
            this.emitObject(obj);
            this.endFile(obj);
        }
        this.emitNameMap(objects);
        this.emitVersionMap();
        this.emitWrapInit(objects);
        this.emitPDef(objects);
        this.emitSubdirMk(objects);
    }

    private void beginFile(VmodlObject obj) {
        String filename = this.getCFile(obj);
        this.beginFile(filename);
        this.emitFileHeader();
        TreeSet<String> includeSet = new TreeSet<String>();
        this.findHeaderSet(obj, includeSet);
        for (String includeFile : includeSet) {
            this.emitLine("#include " + GObjectImplementationEmitter.qq(includeFile));
        }
        this.emitLine();
        this.emitLine("#include " + GObjectImplementationEmitter.qq(this._headerDirectory + "/" + this._packageName + "VersionMap.h"));
        this.emitLine();
    }

    private void emitObject(VmodlObject obj) {
        if (obj instanceof ManagedObject) {
            this.emitManagedObject((ManagedObject)obj);
        } else if (obj instanceof DataObject) {
            this.emitDataObject((DataObject)obj);
        } else if (obj instanceof Enum) {
            this.emitEnum((Enum)obj);
        } else {
            throw new RuntimeException("Unexpected object type");
        }
    }

    private void emitDataObject(DataObject obj) {
        this.emitLine("/**");
        this.emitLine(" * " + this.getGInstanceName(obj) + ":");
        this.emitLine(" *");
        this.emitComment(obj.getComment());
        this.emitLine(" */");
        this.emitLine();
        this.emitGDefineType(obj);
        if (obj.getBaseObject() == null) {
            this.emitSignalEnum(obj, true);
        }
        this.emitPropertyIDs(obj);
        this.emitGetSetProperty(obj);
        this.emitInit(obj);
        this.emitFinalize(obj);
        this.emitClassInit(obj, true);
        this.emitLine();
    }

    private void emitManagedObject(ManagedObject obj) {
        this.emitLine("/**");
        this.emitLine(" * " + this.getGInstanceName(obj) + ":");
        this.emitLine(" *");
        this.emitComment(obj.getComment());
        this.emitLine(" */");
        this.emitLine();
        this.emitGDefineType(obj);
        if (obj.getBaseObject() == null) {
            this.emitSignalEnum(obj, false);
        }
        this.emitPropertyIDs(obj);
        this.emitGetSetProperty(obj);
        this.emitInit(obj);
        this.emitFinalize(obj);
        this.emitClassInit(obj, false);
        this.emitLine();
        for (Method method : obj.getMethodList()) {
            this.emitMethodImpl(method, obj);
            this.emitLine();
        }
    }

    private void endFile(VmodlObject obj) {
        this.emitLine();
        this.emitLine("/* The End */");
        this.endFile();
    }

    private void emitEnum(Enum obj) {
        this.emitLine("/**");
        this.emitLine(" * " + this.getGInstanceName(obj) + ":");
        this.emitLine(" *");
        this.emitComment(obj.getComment());
        this.emitLine(" */");
        this.emitLine();
        this.emitLine("GType ");
        this.emitLine(this.getGetType(obj) + "(void)");
        this.emitLine("{");
        this.indent();
        this.emitLine("static GType eType = 0;");
        this.emitLine("static const gchar *wsdlName = " + GObjectImplementationEmitter.qq(obj.getWsdlName()) + ";");
        this.emitLine("if (G_UNLIKELY(eType == 0)) {");
        this.indent();
        this.emitLine("static const GEnumValue values[] = {");
        this.indent();
        for (String value : obj.getValueList()) {
            String valueString = this.getGEnumValue(value, obj);
            this.emitLine("{ " + valueString + ", \"" + valueString + "\", \"" + value + "\", },");
        }
        this.emitLine("{ 0, NULL, NULL, },");
        this.unindent();
        this.emitLine("};");
        this.emitLine("eType = g_enum_register_static(" + GObjectImplementationEmitter.qq(this.getGInstanceName(obj)) + ", values);");
        this.emitLine();
        this.emitLine("g_type_set_qdata(eType, GVMOMI_QUARK_WSDLNAME, (gpointer)wsdlName);");
        this.unindent();
        this.emitLine("}");
        this.emitLine("return eType;");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitGDefineType(VmodlObject obj) {
        String baseParent = obj instanceof ManagedObject ? "G_TYPE_INITIALLY_UNOWNED" : "G_TYPE_OBJECT";
        String baseType = obj.getBaseObject() != null ? this.getGTypeName(obj.getBaseObject()) : baseParent;
        this.emitLine("G_DEFINE_TYPE_WITH_CODE(" + this.getGInstanceName(obj) + ", " + this.getMethodPrefix(obj) + ", " + baseType + ", \\");
        this.emitLine("                        static const gchar *wsdlName = " + GObjectImplementationEmitter.qq(obj.getWsdlName()) + "; \\");
        this.emitLine("                        g_type_set_qdata(g_define_type_id, GVMOMI_QUARK_WSDLNAME, (gpointer)wsdlName););");
        this.emitLine();
    }

    private void emitPropertyIDs(VmodlObject obj) {
        if (!obj.hasProperties()) {
            return;
        }
        this.emitLine("enum {");
        this.indent();
        this.emitLine("PROP_" + this.getGInstanceName(obj).toUpperCase() + "_0,");
        for (Property property : obj.getPropertyList()) {
            this.emitLine(this.getPropertyID(obj, property) + ",");
        }
        this.unindent();
        this.emitLine("};");
        this.emitLine();
    }

    private void emitPropertyMethod(VmodlObject obj, boolean isSetter) {
        String methodStr = this.getMethodPrefix(obj) + (isSetter ? "_set" : "_get") + "_property(";
        String padding = this.getPadding(methodStr);
        this.emitLine("static void");
        this.emitLine(methodStr + "GObject *self,");
        this.emitLine(padding + "guint prop_id,");
        this.emitLine(padding + (isSetter ? "const " : "") + "GValue *value,");
        this.emitLine(padding + "GParamSpec *pspec)");
        this.emitLine("{");
        this.indent();
        this.emitLine(this.getGInstanceName(obj) + "* obj = " + this.getGTypeCast(obj) + "(self);");
        this.emitLine();
        this.emitLine("switch (prop_id) {");
        for (Property property : obj.getPropertyList()) {
            this.emitLine("case " + this.getPropertyID(obj, property) + ":");
            this.indent();
            if (isSetter) {
                this.emitParamSetImpl(property, this.getBaseGTypeCast(obj));
            } else {
                this.emitParamGetImpl(property, this.getBaseGTypeCast(obj));
            }
            this.emitLine("break;");
            this.unindent();
        }
        this.emitLine("default:");
        this.indent();
        this.emitLine("g_warning(\"Invalid property %d on object of type %s.\\n\", prop_id, " + GObjectImplementationEmitter.qq(this.getGInstanceName(obj)) + ");");
        this.emitLine("break;");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitGetSetProperty(VmodlObject obj) {
        if (!obj.hasProperties()) {
            return;
        }
        this.emitPropertyMethod(obj, false);
        this.emitPropertyMethod(obj, true);
    }

    private void emitClassInit(VmodlObject obj, boolean isData) {
        this.emitLine("static void");
        this.emitLine(this.getMethodPrefix(obj) + "_class_init(" + this.getGClassName(obj) + " *klass)");
        this.emitLine("{");
        this.indent();
        if (obj.hasProperties()) {
            this.emitLine("GParamSpec *paramSpec;");
        }
        this.emitLine("GObjectClass *object_class = G_OBJECT_CLASS(klass);");
        this.emitLine();
        this.emitLine(this.getMethodPrefix(obj) + "_parent_class = g_type_class_peek_parent(klass);");
        this.emitLine();
        this.emitLine("object_class->finalize = " + this.getMethodPrefix(obj) + "_finalize;");
        this.emitLine();
        if (obj.hasProperties()) {
            this.emitLine("object_class->get_property = " + this.getMethodPrefix(obj) + "_get_property;");
            this.emitLine("object_class->set_property = " + this.getMethodPrefix(obj) + "_set_property;");
            this.emitLine();
        }
        for (Property property : obj.getPropertyList()) {
            this.emitParamSpec(property, obj, isData);
            String func = "g_object_class_install_property(";
            String padding = this.getPadding(func);
            this.emitLine(func + "object_class,");
            this.emitLine(padding + this.getPropertyID(obj, property) + ",");
            this.emitLine(padding + "paramSpec);");
            this.emitLine();
        }
        if (obj.getBaseObject() == null) {
            if (!isData) {
                this.emitLeaveImpl(obj);
            }
            this.emitArrayNotifyImpl(obj);
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitInit(VmodlObject obj) {
        this.emitLine("static void");
        this.emitLine(this.getMethodPrefix(obj) + "_init(" + this.getGInstanceName(obj) + " *self)");
        this.emitLine("{");
        this.indent();
        if (obj.hasProperties()) {
            this.emitLine();
            for (Property property : obj.getPropertyList()) {
                this.emitParamInit(property);
            }
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitFinalize(VmodlObject obj) {
        this.emitLine("static void");
        this.emitLine(this.getMethodPrefix(obj) + "_finalize(GObject *self)");
        this.emitLine("{");
        this.indent();
        if (this.needsParamFinalize(obj)) {
            this.emitLine(this.getGInstanceName(obj) + "* obj;");
            this.emitLine("obj = " + this.getGTypeCast(obj) + "(self);");
            this.emitLine();
            for (Property property : obj.getPropertyList()) {
                this.emitParamFinalize(property, this.getBaseGTypeCast(obj));
            }
        }
        if (obj.getBaseObject() == null) {
            if (obj instanceof ManagedObject) {
                this.emitLine("g_free(" + this.getGTypeCast(obj) + "(self)->instanceID);");
            } else if (obj.isFault()) {
                this.emitLine("g_free(" + this.getGTypeCast(obj) + "(self)->code);");
                this.emitLine("g_free(" + this.getGTypeCast(obj) + "(self)->string);");
            }
        }
        this.emitLine();
        this.emitLine("G_OBJECT_CLASS(" + this.getMethodPrefix(obj) + "_parent_class)->finalize(self);");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitParamSpec(Property property, VmodlObject container, boolean isData) {
        VmodlDecl decl = property.getDecl();
        String flags = "G_PARAM_READWRITE" + (decl.isOptional() ? " | GVMOMI_PARAM_OPTIONAL" : "");
        this.emitLine("/**");
        this.emitLine(" * " + this.getGInstanceName(container) + ":" + property.getName() + ":");
        this.emitLine(" *");
        if (decl.isArray()) {
            this.emitLine(" * " + this.getTypeDesc(decl));
            this.emitLine(" *");
        }
        this.emitComment(property.getComment());
        this.emitLine(" */");
        if (decl.isArray()) {
            String func = "paramSpec = g_param_spec_boxed(";
            String padding = this.getPadding(func);
            this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
            this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
            this.emitLine(padding + GObjectImplementationEmitter.qq("Array of '" + this.getTrueTypeString(decl) + "'") + ",");
            this.emitLine(padding + "G_TYPE_ARRAY,");
            this.emitLine(padding + flags + ");");
        } else {
            switch (decl.getTypeId()) {
                case BOOLEAN: {
                    String func = "paramSpec = g_param_spec_boolean(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "FALSE,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case BYTE: {
                    String func = "paramSpec = g_param_spec_char(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "G_MININT8,");
                    this.emitLine(padding + "G_MAXINT8,");
                    this.emitLine(padding + "0,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case SHORT: {
                    String func = "paramSpec = g_param_spec_int(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "G_MININT16,");
                    this.emitLine(padding + "G_MAXINT16,");
                    this.emitLine(padding + "0,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case INT: {
                    String func = "paramSpec = g_param_spec_int(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "G_MININT32,");
                    this.emitLine(padding + "G_MAXINT32,");
                    this.emitLine(padding + "0,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case LONG: {
                    String func = "paramSpec = g_param_spec_int64(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "G_MININT64,");
                    this.emitLine(padding + "G_MAXINT64,");
                    this.emitLine(padding + "0,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case FLOAT: {
                    String func = "paramSpec = g_param_spec_float(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "-G_MAXFLOAT,");
                    this.emitLine(padding + "G_MAXFLOAT,");
                    this.emitLine(padding + "0.0,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case DOUBLE: {
                    String func = "paramSpec = g_param_spec_double(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "-G_MAXDOUBLE,");
                    this.emitLine(padding + "G_MAXDOUBLE,");
                    this.emitLine(padding + "0.0,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case TYPENAME: 
                case METHODNAME: 
                case PROPPATH: 
                case STRING: {
                    String func = "paramSpec = g_param_spec_string(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case ENUM: {
                    String func = "paramSpec = g_param_spec_enum(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + this.getGTypeName(decl.getObject()) + ",");
                    this.emitLine(padding + "0,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case DATA: 
                case MANAGED: {
                    String object = decl.getObject() == null ? "VMODL_TYPE_VMOMI_MANAGED_OBJECT" : this.getGTypeName(decl.getObject());
                    String func = "paramSpec = g_param_spec_object(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + object + ",");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case URI: {
                    String func = "paramSpec = g_param_spec_boxed(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "GVMOMI_TYPE_URI,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case DATETIME: {
                    String func = "paramSpec = g_param_spec_boxed(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "GVMOMI_TYPE_TIMEVAL,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case BINARY: {
                    String func = "paramSpec = g_param_spec_boxed(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "GVMOMI_TYPE_BYTE_ARRAY,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                case ANY: {
                    String func = "paramSpec = g_param_spec_boxed(";
                    String padding = this.getPadding(func);
                    this.emitLine(func + GObjectImplementationEmitter.qq(property.getName()) + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + GObjectImplementationEmitter.qq("") + ",");
                    this.emitLine(padding + "G_TYPE_VALUE,");
                    this.emitLine(padding + flags + ");");
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid type");
                }
            }
        }
        String version = this.getVersionName(property.getVersion());
        if (version.isEmpty()) {
            version = "GVMOMI_VERSION_VIM0";
        }
        this.emitLine("g_param_spec_set_qdata(paramSpec, GVMOMI_QUARK_VERSION, (gpointer)" + version + ");");
        if (decl.isArray()) {
            String gArrayType = decl.isLink() ? "G_TYPE_STRING" : this.getGType(decl);
            this.emitLine("g_param_spec_set_qdata(paramSpec, GVMOMI_QUARK_ARRAYTYPE, (gpointer)" + gArrayType + ");");
        }
    }

    private void emitGValueSet(VmodlDecl decl, String gValue, String value, boolean checkOptional, boolean initAll) {
        String qualifier;
        String gType;
        String initType = "";
        boolean deref = false;
        boolean ref = false;
        initType = this.getGType(decl);
        if (decl.isArray()) {
            this.emitLine("/* Array of '" + this.getTrueTypeString(decl) + "' */");
            gType = "boxed";
            initType = "G_TYPE_ARRAY";
        } else {
            switch (decl.getTypeId()) {
                case BOOLEAN: {
                    gType = "boolean";
                    deref = true;
                    break;
                }
                case BYTE: {
                    gType = "schar";
                    deref = true;
                    break;
                }
                case SHORT: 
                case INT: {
                    gType = "int";
                    deref = true;
                    break;
                }
                case LONG: {
                    gType = "int64";
                    deref = true;
                    break;
                }
                case FLOAT: {
                    gType = "float";
                    deref = true;
                    break;
                }
                case DOUBLE: {
                    gType = "double";
                    deref = true;
                    break;
                }
                case TYPENAME: 
                case METHODNAME: 
                case PROPPATH: 
                case STRING: {
                    gType = "string";
                    break;
                }
                case ENUM: {
                    gType = "enum";
                    deref = true;
                    break;
                }
                case DATA: 
                case MANAGED: {
                    gType = "object";
                    break;
                }
                case URI: 
                case DATETIME: 
                case BINARY: {
                    gType = "boxed";
                    break;
                }
                case ANY: {
                    gType = "boxed";
                    ref = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid type");
                }
            }
        }
        String string = ref ? "&" : (qualifier = checkOptional && deref ? "*" : "");
        if (initAll) {
            this.emitLine("g_value_init(" + gValue + ", " + initType + ");");
        }
        this.emitLine("g_value_set_" + gType + "(" + gValue + ", " + qualifier + value + ");");
    }

    private void emitParamGetImpl(Property property, String cast) {
        VmodlDecl decl = property.getDecl();
        String propVar = "obj->" + this.getMemberName(property);
        if (decl.isManaged()) {
            if (decl.isArray()) {
                this.emitGetManagedObjectArray(propVar, cast);
            } else {
                this.emitGetManagedObject(propVar, propVar + "_managed_type", "value", cast);
            }
        } else if (decl.isAny()) {
            if (decl.isArray()) {
                this.emitLine("if (" + propVar + "_managed_type" + ") {");
                this.indent();
                this.emitGetManagedObjectArray(propVar, cast);
            } else {
                this.emitLine("if (" + propVar + "_managed_type" + " != G_TYPE_INVALID) {");
                this.indent();
                this.emitLine("const gchar *instanceID = g_value_get_string(&" + propVar + ");");
                this.emitLine("GValue moValue = { 0, };");
                this.emitLine("g_value_init(&moValue, " + propVar + "_managed_type" + ");");
                this.emitGetManagedObject("instanceID", propVar + "_managed_type", "&moValue", cast);
                this.emitGValueSet(decl, "value", "moValue", false, false);
                this.emitLine("g_value_unset(&moValue);");
            }
            this.unindent();
            this.emitLine("} else {");
            this.indent();
            this.emitGValueSet(decl, "value", propVar, false, false);
            this.unindent();
            this.emitLine("}");
        } else {
            this.emitGValueSet(decl, "value", propVar, false, false);
        }
    }

    private void emitParamSetImpl(Property property, String cast) {
        VmodlDecl decl = property.getDecl();
        String propVar = "obj->" + this.getMemberName(property);
        this.emitParamFinalize(property, cast);
        if (decl.isArray()) {
            this.emitLine("/* Array of '" + this.getTrueTypeString(decl) + "' */");
            if (decl.isManaged()) {
                this.emitLine("{");
                this.indent();
                this.emitSetManagedObjectArray(propVar, cast);
                this.unindent();
                this.emitLine("}");
            } else if (decl.isAny()) {
                this.emitLine("{");
                this.indent();
                this.emitLine("GArray *array = g_value_get_boxed(value);");
                this.emitLine("if (array->len > 0 &&\n    G_VALUE_HOLDS(&g_array_index(array, GValue, 0), VMODL_TYPE_VMOMI_MANAGED_OBJECT)) {");
                this.indent();
                this.emitSetManagedObjectArray(propVar, cast);
                this.unindent();
                this.emitLine("} else {");
                this.indent();
                this.emitLine(propVar + " = g_value_dup_boxed(value);");
                this.unindent();
                this.emitLine("}");
                this.unindent();
                this.emitLine("}");
            } else {
                this.emitLine(propVar + " = g_value_dup_boxed(value);");
            }
        } else {
            switch (decl.getTypeId()) {
                case BOOLEAN: {
                    this.emitLine(propVar + " = g_value_get_boolean(value);");
                    break;
                }
                case BYTE: {
                    this.emitLine(propVar + " = g_value_get_schar(value);");
                    break;
                }
                case SHORT: 
                case INT: {
                    this.emitLine(propVar + " = g_value_get_int(value);");
                    break;
                }
                case LONG: {
                    this.emitLine(propVar + " = g_value_get_int64(value);");
                    break;
                }
                case FLOAT: {
                    this.emitLine(propVar + " = g_value_get_float(value);");
                    break;
                }
                case DOUBLE: {
                    this.emitLine(propVar + " = g_value_get_double(value);");
                    break;
                }
                case TYPENAME: 
                case METHODNAME: 
                case PROPPATH: 
                case STRING: {
                    this.emitLine(propVar + " = g_value_dup_string(value);");
                    break;
                }
                case ENUM: {
                    this.emitLine(propVar + " = g_value_get_enum(value);");
                    break;
                }
                case DATA: {
                    String propCast = this.getGTypeCast(decl.getObject());
                    if (decl.isLink()) {
                        this.emitLine(propVar + " = " + propCast + "(g_value_get_object(value));");
                        break;
                    }
                    this.emitLine(propVar + " = " + propCast + "(g_value_dup_object(value));");
                    break;
                }
                case MANAGED: {
                    this.emitLine("{");
                    this.indent();
                    this.emitSetManagedObject(propVar, "value", cast, true);
                    this.unindent();
                    this.emitLine("}");
                    break;
                }
                case URI: 
                case DATETIME: 
                case BINARY: {
                    this.emitLine(propVar + " = g_value_dup_boxed(value);");
                    break;
                }
                case ANY: {
                    this.emitLine("{");
                    this.indent();
                    this.emitLine("GValue *newValue = (GValue *)g_value_get_boxed(value);");
                    this.emitLine();
                    this.emitLine("if (G_IS_VALUE(newValue)) {");
                    this.indent();
                    this.emitLine("if (G_VALUE_HOLDS(newValue, VMODL_TYPE_VMOMI_MANAGED_OBJECT)) {");
                    this.indent();
                    this.emitLine("gchar *instanceID = NULL;");
                    this.emitSetManagedObject("instanceID", "newValue", cast, false);
                    this.emitLine("g_value_init(&" + propVar + ", G_TYPE_STRING);");
                    this.emitLine("g_value_take_string(&" + propVar + ", instanceID);");
                    this.emitLine(propVar + "_managed_type" + " = G_VALUE_TYPE(newValue);");
                    this.unindent();
                    this.emitLine("} else {");
                    this.indent();
                    this.emitLine("g_value_init(&" + propVar + ", G_VALUE_TYPE(newValue));");
                    this.emitLine("g_value_copy(newValue, &" + propVar + ");");
                    this.unindent();
                    this.emitLine("}");
                    this.unindent();
                    this.emitLine("}");
                    this.unindent();
                    this.emitLine("}");
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid type");
                }
            }
        }
        if (decl.isOptional()) {
            this.emitLine("g_object_set_data(self, " + GObjectImplementationEmitter.qq(this.getMemberName(property)) + ", (gpointer)(TRUE));");
        }
    }

    private void emitParamInit(Property property) {
        VmodlDecl decl = property.getDecl();
        if (!decl.isArray()) {
            switch (decl.getTypeId()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case TYPENAME: 
                case METHODNAME: 
                case PROPPATH: 
                case STRING: 
                case ENUM: 
                case DATA: 
                case MANAGED: 
                case URI: 
                case DATETIME: 
                case BINARY: 
                case ANY: {
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid type");
                }
            }
        }
    }

    private boolean needsParamFinalize(VmodlObject obj) {
        for (Property property : obj.getPropertyList()) {
            VmodlDecl decl = property.getDecl();
            if (decl.isArray()) {
                return true;
            }
            switch (decl.getTypeId()) {
                case TYPENAME: 
                case METHODNAME: 
                case PROPPATH: 
                case STRING: 
                case DATA: 
                case MANAGED: 
                case URI: 
                case DATETIME: 
                case BINARY: 
                case ANY: {
                    return true;
                }
            }
        }
        return false;
    }

    private void emitParamFinalize(Property property, String cast) {
        VmodlDecl decl = property.getDecl();
        String propVar = "obj->" + this.getMemberName(property);
        if (decl.isArray()) {
            this.emitLine("if (" + propVar + ") {");
            this.indent();
            if (decl.isManaged()) {
                this.emitFinalizeManagedObjectArray(propVar, cast);
            } else if (decl.isAny()) {
                this.emitLine("if (" + propVar + "_managed_type" + ") {");
                this.indent();
                this.emitFinalizeManagedObjectArray(propVar, cast);
                this.unindent();
                this.emitLine("}");
            }
            this.emitLine("g_array_unref(" + propVar + ");");
            this.emitLine(propVar + " = NULL;");
            this.unindent();
            this.emitLine("}");
        } else {
            switch (decl.getTypeId()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case ENUM: {
                    break;
                }
                case TYPENAME: 
                case METHODNAME: 
                case PROPPATH: 
                case STRING: 
                case URI: 
                case DATETIME: {
                    this.emitLine("g_free(" + propVar + ");");
                    break;
                }
                case BINARY: {
                    this.emitLine("if (" + propVar + ") {");
                    this.indent();
                    this.emitLine("g_byte_array_free(" + propVar + ", TRUE);");
                    this.unindent();
                    this.emitLine("}");
                    break;
                }
                case DATA: {
                    if (decl.isLink()) break;
                    this.emitLine("if (" + propVar + ") {");
                    this.indent();
                    this.emitLine("g_object_unref(" + propVar + ");");
                    this.unindent();
                    this.emitLine("}");
                    break;
                }
                case MANAGED: {
                    this.emitFinalizeManagedObject(propVar, cast, true);
                    this.emitLine(propVar + "_managed_type" + " = " + this.getGType(decl) + ";");
                    break;
                }
                case ANY: {
                    this.emitLine("if (G_IS_VALUE(&" + propVar + ")) {");
                    this.indent();
                    this.emitLine("if (" + propVar + "_managed_type" + " != G_TYPE_INVALID) {");
                    this.indent();
                    this.emitLine("const gchar *instanceID = g_value_get_string(&" + propVar + ");");
                    this.emitFinalizeManagedObject("instanceID", cast, false);
                    this.emitLine(propVar + "_managed_type" + " = G_TYPE_INVALID;");
                    this.unindent();
                    this.emitLine("}");
                    this.emitLine("g_value_unset(&" + propVar + ");");
                    this.unindent();
                    this.emitLine("}");
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid type");
                }
            }
        }
    }

    private void emitMethodImpl(Method method, VmodlObject obj) {
        String invokeStr = "gvmomi_session_invoke_method(";
        String padding = this.getPadding(invokeStr);
        this.emitMethodComment(method, obj);
        this.emitLine(this.formatMethodDef(method, obj));
        this.emitLine("{");
        this.indent();
        for (Field field : method.getParameterList()) {
            this.emitLine("GValue " + field.getName() + "Value = { 0, };");
        }
        this.emitLine();
        for (Field field : method.getParameterList()) {
            if (field.getDecl().isOptional()) {
                this.emitLine("if (" + field.getName() + " != NULL) {");
                this.indent();
                this.emitGValueSet(field.getDecl(), "&" + field.getName() + "Value", field.getName(), true, true);
                this.unindent();
                this.emitLine("}");
                continue;
            }
            this.emitGValueSet(field.getDecl(), "&" + field.getName() + "Value", field.getName(), false, true);
        }
        this.emitLine();
        this.emitLine("if (listener) {");
        this.indent();
        if (method.isTask()) {
            this.emitLine("gvmomi_listener_set_return_type(listener, VMODL_TYPE_VIM_TASK, FALSE);");
        } else {
            this.emitLine("gvmomi_listener_set_return_type(listener, " + this.getGType(method.getReturnDecl()) + ", " + (method.getReturnDecl().isArray() ? "TRUE" : "FALSE") + ");");
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        this.emitLine(invokeStr + "VMODL_VMOMI_MANAGED_OBJECT" + "(vmodlObj)->session,");
        this.emitLine(padding + "G_OBJECT(vmodlObj),");
        this.emitLine(padding + GObjectImplementationEmitter.qq(method.getWsdlName()) + ",");
        this.emitLine(padding + "listener,");
        for (Field field : method.getParameterList()) {
            this.emitLine(padding + GObjectImplementationEmitter.qq(field.getName()) + ",");
            this.emitLine(padding + "&" + field.getName() + "Value,");
        }
        this.emitLine(padding + "NULL);");
        this.emitLine();
        for (Field field : method.getParameterList()) {
            if (field.getDecl().isOptional()) {
                this.emitLine("if (" + field.getName() + " != NULL) {");
                this.indent();
            }
            this.emitLine("g_value_unset(&" + field.getName() + "Value);");
            if (!field.getDecl().isOptional()) continue;
            this.unindent();
            this.emitLine("}");
        }
        this.unindent();
        this.emitLine("}");
    }

    private void emitComment(String comment) {
        if (comment != null && (comment = comment.trim()).isEmpty()) {
            comment = null;
        }
        Pattern genericEol = Pattern.compile("\r\n?|\n");
        if (comment != null) {
            comment = comment.replaceAll("<[^>]*>", "");
            for (String line : genericEol.split(comment)) {
                this.emitLine(" * " + line);
            }
        }
    }

    private void emitMethodComment(Method method, VmodlObject obj) {
        Object formatter;
        String desc;
        String comment = method.getComment();
        if (comment != null && (comment = comment.trim()).isEmpty()) {
            comment = null;
        }
        String mainDesc = null;
        Hashtable<String, String> paramDescs = new Hashtable<String, String>();
        Hashtable<String, String> faultDescs = new Hashtable<String, String>();
        String returnDesc = null;
        Pattern generic = Pattern.compile("\r\n?|\n");
        String comment2 = "";
        if (comment != null) {
            comment = comment.replaceAll("<p>", "@para");
            comment = comment.replaceAll("<[^>]*>", "");
            for (String line : generic.split(comment)) {
                line = line.replaceAll("Returns", "Return-s");
                comment2 = comment2 + line + "\n";
            }
            String string = comment2;
            Object regex = Pattern.compile("(.+?)((@param|@throws|@return|@para|@see|\\z).*)", 32);
            Matcher matcher = ((Pattern)regex).matcher(string);
            if (matcher.find()) {
                mainDesc = matcher.group(1);
                String string2 = matcher.group(2);
                regex = Pattern.compile("(@param|@throws|@task|@return|@para|@see)(.+?)(?=@param|@throws|@task|@return|@para|@see|\\z)", 32);
                matcher = ((Pattern)regex).matcher(string2);
                while (matcher.find()) {
                    String name;
                    Matcher nameMatcher;
                    String type = matcher.group(1);
                    String desc2 = matcher.group(2).trim();
                    if (type.equals("@param")) {
                        nameMatcher = Pattern.compile("(.+?)[\\s](.*)", 32).matcher(desc2);
                        if (!nameMatcher.find()) continue;
                        name = nameMatcher.group(1).trim();
                        desc2 = nameMatcher.group(2).trim();
                        paramDescs.put(name, desc2);
                        continue;
                    }
                    if (type.equals("@throws")) {
                        nameMatcher = Pattern.compile("(.+?)[\\s](.*)", 32).matcher(desc2);
                        if (!nameMatcher.find()) continue;
                        name = nameMatcher.group(1).trim();
                        desc2 = nameMatcher.group(2).trim();
                        faultDescs.put(name, desc2);
                        continue;
                    }
                    if (type.equals("@return")) {
                        returnDesc = desc2;
                        continue;
                    }
                    if (type.equals("@see")) {
                        mainDesc = mainDesc + "<para/>\n<i>See:</i> " + desc2;
                        continue;
                    }
                    if (type.equals("@para")) {
                        mainDesc = mainDesc + "<para/>\n" + desc2;
                        continue;
                    }
                    if (!type.equals("@task")) continue;
                }
            }
        }
        this.emitLine("/**");
        this.emitLine(" * " + this.getMethodName(method, obj) + ":");
        this.emitLine(" * @vmodlObj: self (#" + this.getGInstanceName(obj) + ")");
        for (Field field : method.getParameterList()) {
            this.emitLine(" * @" + field.getName() + ": #" + this.getTypeDesc(field.getDecl()) + " " + (field.getDecl().isOptional() ? "(Optional)" : ""));
            desc = (String)paramDescs.get(field.getName());
            if (desc == null) {
                this.emitLine(" *      Undocumented.");
                continue;
            }
            Matcher formatter2 = Pattern.compile("(\r\n?|\n)").matcher(desc);
            this.emitLine(" *      " + formatter2.replaceAll("$1 * "));
        }
        this.emitLine(" * @listener: #GVmomiListener to receive completion and update events");
        this.emitLine(" *");
        if (mainDesc == null) {
            this.emitLine(" *   Method is undocumented.");
        } else {
            formatter = Pattern.compile("(\r\n?|\n)").matcher(mainDesc);
            this.emitLine(" *   " + ((Matcher)formatter).replaceAll("$1 * "));
        }
        this.emitLine(" *");
        this.emitLine(" * WSDL Name: " + GObjectImplementationEmitter.qq(method.getWsdlName()));
        this.emitLine(" *");
        this.emitLine(" * Faults thrown:");
        this.emitLine(" * <itemizedlist>");
        for (VmodlObject vmodlObject : method.getFaultList()) {
            this.emitLine(" * <listitem>" + vmodlObject.getClassName() + ": #" + this.getGInstanceName(vmodlObject));
            desc = (String)faultDescs.get(vmodlObject.getClassName());
            if (desc == null) {
                this.emitLine(" *      Undocumented.</listitem>");
                continue;
            }
            Matcher formatter2 = Pattern.compile("(\r\n?|\n)").matcher(desc);
            this.emitLine(" *      " + formatter2.replaceAll("$1 * ") + "</listitem>");
        }
        this.emitLine(" * </itemizedlist>");
        this.emitLine(" *");
        this.emitLine(" * Return type: #" + this.getTypeDesc(method.getReturnDecl()));
        if (!this.getTypeDesc(method.getReturnDecl()).equals("void") && returnDesc == null) {
            this.emitLine(" *   Return type is undocumented.");
        } else if (returnDesc != null) {
            formatter = Pattern.compile("(\r\n?|\n)").matcher(returnDesc);
            this.emitLine(" *   " + ((Matcher)formatter).replaceAll("$1 * "));
        }
        if (method.isInternal()) {
            this.emitLine(" *");
            this.emitLine(" * This is an internal method.\n");
        }
        this.emitLine(" */");
        this.emitLine();
    }

    private String getHeaderFile(VmodlObject obj) {
        return this.getHeaderFile(obj, this._headerDirectory);
    }

    private void findHeaderSet(VmodlObject obj, TreeSet<String> headerSet) {
        String dependHeader = this.getHeaderFile(obj);
        if (headerSet.contains(dependHeader)) {
            return;
        }
        headerSet.add(dependHeader);
        for (VmodlObject tobj : obj.getAllDependencies()) {
            this.findHeaderSet(tobj, headerSet);
        }
    }

    private String getCFile(VmodlObject obj, String directory) {
        String className = this.getQualifiedClassName(obj);
        if (className.startsWith("::")) {
            className = className.replaceFirst("::", "");
        }
        String filename = className.replaceAll("::", "") + ".c";
        if (directory.length() > 0) {
            filename = directory + "/" + filename;
        }
        return filename;
    }

    private String getCFile(VmodlObject obj) {
        return this.getCFile(obj, this._directory);
    }

    private void emitNameMap(List<VmodlObject> objects) {
        this.beginFile(this._directory + "/nameMap.c");
        this.emitFileHeader();
        this.emitLine("#include " + GObjectImplementationEmitter.qq(this._headerDirectory + "/" + this._packageName + "NameMap.h"));
        this.emitLine();
        for (VmodlObject obj : objects) {
            if (obj.getContainer() != null) continue;
            this.emitLine("#include " + GObjectImplementationEmitter.qq(this.getHeaderFile(obj)));
        }
        this.emitLine();
        this.emitLine("void");
        this.emitLine("vmodl_" + this._packageName + "_populate_name_map(GHashTable *table)");
        this.emitLine("{");
        this.indent();
        this.emitLine("GType type;");
        this.emitLine("const gchar *name;");
        for (VmodlObject obj : objects) {
            this.emitLine();
            this.emitLine("type = " + this.getGTypeName(obj) + ";");
            this.emitLine("name = g_type_get_qdata(type, GVMOMI_QUARK_WSDLNAME);");
            this.emitLine("g_hash_table_insert(table, (gpointer)name, (gpointer)type);");
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        this.endFile();
    }

    private void emitVersionEntry(Version version, String key, String varName, String taskTypeName) {
        this.emitLine("entry = g_new(GVmomiVersionEntry, 1);");
        this.emitLine("entry->vmodlName = " + varName + ";");
        this.emitLine("entry->taskReturnType = " + taskTypeName + ";");
        this.emitLine("entry->versions = g_ptr_array_new();");
        for (Version parent : GObjectEmitter.getTargetVersions()) {
            if (!version.isAncestor(parent)) continue;
            this.emitLine("g_ptr_array_add(entry->versions, (gpointer)" + parent.getVmodlName().replace(".", "") + "wsdl);");
        }
        this.emitLine("g_hash_table_insert(table, (gpointer)" + key + ", (gpointer)entry);");
        this.emitLine();
    }

    private void emitVersionMap() {
        String varName;
        VmodlDecl taskDecl = Method.taskReturnDecl();
        String taskTypeName = taskDecl == null ? "G_TYPE_NONE" : this.getGTypeName(taskDecl.getObject());
        List<Version> targetVersions = GObjectEmitter.getTargetVersions();
        this.beginFile(this._directory + "/versionMap.c");
        this.emitFileHeader();
        this.emitLine("#include " + GObjectImplementationEmitter.qq(this._headerDirectory + "/" + this._packageName + "VersionMap.h"));
        this.emitLine("#include " + GObjectImplementationEmitter.qq("gvmomi/gvmomiInt.h"));
        if (taskDecl != null) {
            this.emitLine("#include " + GObjectImplementationEmitter.qq(this.getHeaderFile(taskDecl.getObject())));
        }
        this.emitLine();
        for (Version version : targetVersions) {
            String vmodlName = version.getVmodlName().replace(".", "");
            String wireId = version.getUniqueWireId();
            this.emitLine("static const gchar *" + vmodlName + " = " + GObjectImplementationEmitter.qq(version.getVmodlName()) + ";");
            this.emitLine("static const gchar *" + vmodlName + "wsdl = " + GObjectImplementationEmitter.qq(version.getWireNs() + (wireId == null ? "" : "/" + wireId)) + ";");
            if (!version.isLegacy()) continue;
            this.emitLine("static const gchar *" + vmodlName + "Legacy = " + GObjectImplementationEmitter.qq(version.getWireNs()) + ";");
        }
        this.emitLine();
        this.emitLine("void");
        this.emitLine("vmodl_" + this._packageName + "_populate_version_map(GHashTable *table)");
        this.emitLine("{");
        this.indent();
        this.emitLine("GVmomiVersionEntry *entry = NULL;");
        this.emitLine();
        for (Version version : targetVersions) {
            varName = version.getVmodlName().replace(".", "");
            this.emitVersionEntry(version, varName + "wsdl", varName, taskTypeName);
            if (!version.isLegacy()) continue;
            this.emitVersionEntry(version, varName + "Legacy", varName, taskTypeName);
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        for (Version version : targetVersions) {
            if (!this.shouldEmitVersionForClass(version, this._packageName)) continue;
            varName = version.getVmodlName().replace(".", "") + "wsdl";
            this.emitLine("GQuark");
            this.emitLine(this.getVersionQuarkName(version).toLowerCase() + "(void)");
            this.emitLine("{");
            this.indent();
            this.emitLine("return g_quark_from_static_string(" + varName + ");");
            this.unindent();
            this.emitLine("}");
            this.emitLine();
        }
        this.endFile();
    }

    private void emitPDef(List<VmodlObject> objects) {
        this.beginFile(this._directory + "/exports.pdef");
        this.emitLine("# Generated File. Do not Edit");
        this.emitLine();
        this.indent();
        for (VmodlObject obj : objects) {
            this.emitLine(this.getGetType(obj));
            if (obj instanceof ManagedObject) {
                this.indent();
                for (Method method : ((ManagedObject)obj).getMethodList()) {
                    this.emitLine(this.getMethodName(method, obj));
                }
                this.unindent();
            }
            this.emitLine();
        }
        for (Version version : GObjectEmitter.getTargetVersions()) {
            if (!this.shouldEmitVersionForClass(version, this._packageName)) continue;
            this.emitLine(this.getVersionQuarkName(version).toLowerCase());
        }
        this.unindent();
        this.endFile();
    }

    private void emitSubdirMk(List<VmodlObject> objects) {
        this.beginFile(this._directory + "/Subdir.mk");
        this.emitLine("SUBDIR_FILES :=");
        for (VmodlObject obj : objects) {
            this.emitLine("SUBDIR_FILES += " + this.getCFile(obj, ""));
        }
        this.emitLine("SUBDIR_FILES += nameMap.c");
        this.emitLine("SUBDIR_FILES += versionMap.c");
        this.endFile();
    }

    private void emitGetManagedObject(String propVar, String gType, String value, String cast) {
        this.emitLine("if (" + propVar + ") {");
        this.indent();
        this.emitLine("GVmomiMOMgr *moMgr = gvmomi_session_get_momgr(" + cast + "(obj)->session);");
        this.emitLine("if (moMgr == NULL) {");
        this.indent();
        this.emitLine("g_warning(\"Failed to get the GVmomiMOMgr to get property %s of type %s.\\n\", " + propVar + ", g_type_name(" + gType + "));");
        this.unindent();
        this.emitLine("} else {");
        this.indent();
        this.emitLine("GObject *mo = gvmomi_momgr_lookup_or_create(moMgr, " + propVar + ", " + gType + ");");
        this.emitLine("g_value_set_object(" + value + ", mo);");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
    }

    private void emitGetManagedObjectArray(String propVar, String cast) {
        this.emitLine("if (" + propVar + ") {");
        this.indent();
        this.emitLine("guint i;");
        this.emitLine("GVmomiMOMgr *moMgr = gvmomi_session_get_momgr(" + cast + "(obj)->session);");
        this.emitLine("if (moMgr == NULL) {");
        this.indent();
        this.emitLine("g_warning(\"Failed to get the GVmomiMOMgr to get an array\\n\");");
        this.unindent();
        this.emitLine("} else {");
        this.indent();
        this.emitLine("GArray *moArray = g_array_new(FALSE, TRUE, sizeof(GValue));");
        this.emitLine("g_array_set_clear_func(moArray, (GDestroyNotify)g_value_unset);");
        this.emitLine("for (i = 0; i < " + propVar + "->len; i++) {");
        this.indent();
        this.emitLine("GValue item = { 0, };");
        this.emitLine("const gchar *instanceID = g_value_get_string(&g_array_index(" + propVar + ", GValue, i));");
        this.emitLine("GObject *mo = gvmomi_momgr_lookup_or_create(moMgr, instanceID, g_array_index(" + propVar + "_managed_type" + ", GType, i));");
        this.emitLine("g_value_init(&item, G_OBJECT_TYPE(mo));");
        this.emitLine("g_value_set_object(&item, mo);");
        this.emitLine("g_array_append_val(moArray, item);");
        this.unindent();
        this.emitLine("}");
        this.emitLine("g_value_take_boxed(value, moArray);");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
    }

    private void emitSetManagedObject(String propVar, String value, String cast, boolean emitType) {
        this.emitLine("GObject *mo = g_value_get_object(" + value + ");");
        this.emitLine("if (mo) {");
        this.indent();
        this.emitLine(propVar + " = g_strdup(" + "VMODL_VMOMI_MANAGED_OBJECT" + "(mo)->instanceID);");
        this.emitLine(cast + "(obj)->session = " + "VMODL_VMOMI_MANAGED_OBJECT" + "(mo)->session;");
        if (emitType) {
            this.emitLine(propVar + "_managed_type" + " = G_OBJECT_TYPE(mo);");
        }
        this.unindent();
        this.emitLine("}");
    }

    private void emitSetManagedObjectArray(String propVar, String cast) {
        this.emitLine("GArray *moArray = g_value_get_boxed(value);");
        this.emitLine("if (moArray) {");
        this.indent();
        this.emitLine("guint i;");
        this.emitLine(propVar + " = g_array_new(FALSE, TRUE, sizeof(GValue));");
        this.emitLine("g_array_set_clear_func(" + propVar + ", (GDestroyNotify)g_value_unset);");
        this.emitLine(propVar + "_managed_type" + " = g_array_new(FALSE, FALSE, sizeof(GType));");
        this.emitLine("for (i = 0; i < moArray->len; i++) {");
        this.indent();
        this.emitLine("GObject *mo = g_value_get_object(&g_array_index(moArray, GValue, i));");
        this.emitLine("if (mo) {");
        this.indent();
        this.emitLine("GValue item = { 0, };");
        this.emitLine("g_value_init(&item, G_TYPE_STRING);");
        this.emitLine("g_value_set_string(&item, VMODL_VMOMI_MANAGED_OBJECT(mo)->instanceID);");
        this.emitLine("g_array_append_val(" + propVar + ", item);");
        this.emitLine("g_array_append_val(" + propVar + "_managed_type" + ", G_OBJECT_TYPE(mo));");
        this.emitLine("if (i == 0) {");
        this.indent();
        this.emitLine(cast + "(obj)->session = " + "VMODL_VMOMI_MANAGED_OBJECT" + "(mo)->session;");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
    }

    private void emitFinalizeManagedObject(String propVar, String cast, boolean freeVar) {
        this.emitLine("if (" + propVar + ") {");
        this.indent();
        this.emitLine("GVmomiMOMgr *moMgr = gvmomi_session_get_momgr(" + cast + "(obj)->session);");
        this.emitLine("if (moMgr) {");
        this.indent();
        this.emitLine("GObject *mo = gvmomi_momgr_lookup(moMgr, " + propVar + ");");
        this.emitLine("if (mo) {");
        this.indent();
        this.emitLine("g_object_ref_sink(mo);");
        this.emitLine("g_object_unref(mo);");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        if (freeVar) {
            this.emitLine("g_free(" + propVar + ");");
            this.emitLine(propVar + " = NULL;");
        }
        this.unindent();
        this.emitLine("}");
    }

    private void emitFinalizeManagedObjectArray(String propVar, String cast) {
        this.emitLine("guint i;");
        this.emitLine("GVmomiMOMgr *moMgr = gvmomi_session_get_momgr(" + cast + "(obj)->session);");
        this.emitLine("if (moMgr) {");
        this.indent();
        this.emitLine("for (i = 0; i < " + propVar + "->len; i++) {");
        this.indent();
        this.emitLine("GValue *value = &g_array_index(" + propVar + ", GValue, i);");
        this.emitLine("const gchar *instanceID = g_value_get_string(value);");
        this.emitLine("GObject *mo = gvmomi_momgr_lookup(moMgr, instanceID);");
        this.emitLine("if (mo) {");
        this.indent();
        this.emitLine("g_object_ref_sink(mo);");
        this.emitLine("g_object_unref(mo);");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        this.emitLine("g_array_free(" + propVar + "_managed_type" + ", TRUE);");
        this.emitLine(propVar + "_managed_type" + " = NULL;");
    }

    private void emitSignalEnum(VmodlObject obj, boolean isData) {
        this.emitLine("/* Signals */");
        this.emitLine("enum {");
        this.indent();
        if (!isData) {
            this.emitLine(this.getGTypeCast(obj) + "_LEAVE,");
        }
        this.emitLine(this.getGTypeCast(obj) + "_ARRAY_NOTIFY,");
        this.emitLine(this.getGTypeCast(obj) + "_LAST_SIGNAL,");
        this.unindent();
        this.emitLine("};");
        this.emitLine();
        this.emitLine("static guint " + this.getMethodPrefix(obj) + "_signals[" + this.getGTypeCast(obj) + "_LAST_SIGNAL] = { 0, };");
        this.emitLine();
    }

    private void emitLeaveImpl(VmodlObject obj) {
        this.emitLine("/**");
        this.emitLine(" * " + this.getGInstanceName(obj) + "::leave:");
        this.emitLine(" * @object: The object on which the signal was emitted");
        this.emitLine(" * ");
        this.emitLine(" * The leave signal is emitted when a managed object is destroyed");
        this.emitLine(" * on the server. From this point on, clients will no longer receive");
        this.emitLine(" * updates on the object's properties, and attempts to invoke methods");
        this.emitLine(" * on it will result in a fault being returned by the server.");
        this.emitLine(" */");
        this.emitLine(this.getMethodPrefix(obj) + "_signals[" + this.getGTypeCast(obj) + "_LEAVE] =");
        this.emitLine("   g_signal_new(\"leave\",");
        this.emitLine("                G_TYPE_FROM_CLASS(klass),");
        this.emitLine("                G_SIGNAL_RUN_FIRST | G_SIGNAL_NO_RECURSE | G_SIGNAL_ACTION,");
        this.emitLine("                G_STRUCT_OFFSET(" + this.getGClassName(obj) + ", leave),");
        this.emitLine("                NULL, NULL,");
        this.emitLine("                g_cclosure_marshal_VOID__VOID,");
        this.emitLine("                G_TYPE_NONE,");
        this.emitLine("                0);");
    }

    private void emitArrayNotifyImpl(VmodlObject obj) {
        this.emitLine("/**");
        this.emitLine(" * " + this.getGInstanceName(obj) + "::array_notify:");
        this.emitLine(" * @object: The object on which the signal was emitted");
        this.emitLine(" * @pspec: The #GParamSpec of the property which changed");
        this.emitLine(" * @added: Whether the notification is of an add or a remove");
        this.emitLine(" * @value: The added or removed value");
        this.emitLine(" * ");
        this.emitLine(" * The array_notify signal is emitted when an element is added");
        this.emitLine(" * or removed from an array property.");
        this.emitLine(" */");
        this.emitLine(this.getMethodPrefix(obj) + "_signals[" + this.getGTypeCast(obj) + "_ARRAY_NOTIFY] =");
        this.emitLine("   g_signal_new(\"array_notify\",");
        this.emitLine("                G_TYPE_FROM_CLASS(klass),");
        this.emitLine("                G_SIGNAL_RUN_FIRST | G_SIGNAL_NO_RECURSE | G_SIGNAL_DETAILED |");
        this.emitLine("                G_SIGNAL_NO_HOOKS | G_SIGNAL_ACTION,");
        this.emitLine("                G_STRUCT_OFFSET(" + this.getGClassName(obj) + ", array_notify),");
        this.emitLine("                NULL, NULL,");
        this.emitLine("                gvmomi_marshal_VOID__PARAM_BOOLEAN_BOXED,");
        this.emitLine("                G_TYPE_NONE,");
        this.emitLine("                3, G_TYPE_PARAM, G_TYPE_BOOLEAN, G_TYPE_VALUE);");
    }

    private void emitWrapInit(List<VmodlObject> objects) {
        this.beginFile(this._directory + "/wrapInit.cc");
        this.emitFileHeader();
        this.emitLine("#include <glibmm.h>");
        this.emitLine();
        for (VmodlObject obj : objects) {
            if (obj.getContainer() != null) continue;
            this.emitLine("#include " + GObjectImplementationEmitter.qq(this.getHeaderFile(obj)));
        }
        this.emitLine();
        this.emitLine("static void");
        this.emitLine("vmodl_" + this._packageName + "_wrap_init(Glib::WrapNewFunction wrapNew)");
        this.emitLine("{");
        this.indent();
        for (VmodlObject obj : objects) {
            if (!(obj instanceof DataObject) && !(obj instanceof ManagedObject)) continue;
            this.emitLine("Glib::wrap_register(" + this.getGTypeName(obj) + ", wrapNew);");
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        this.endFile();
    }
}

