/*
 * Decompiled with CFR 0.152.
 */
package emitters.core;

import emitters.Utils;
import emitters.model.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import vmodl.wsdlName;

public class MethodsRegistrar {
    private Map<String, Method> _registry = new HashMap<String, Method>();
    private Map<String, List<Method>> _multiRegistry = new HashMap<String, List<Method>>();

    public void register(String name, wsdlName wsdlName2, Method method) {
        String methodName = MethodsRegistrar.getMethodName(wsdlName2, name);
        List<Method> methodList = this._multiRegistry.get(methodName);
        if (methodList == null) {
            Method existingLateWsdl = this._registry.get(methodName);
            if (existingLateWsdl == null) {
                this._registry.put(methodName, method);
                return;
            }
            this._registry.remove(methodName);
            methodList = new ArrayList<Method>(2);
            this._multiRegistry.put(methodName, methodList);
            methodList.add(existingLateWsdl);
        }
        methodList.add(method);
    }

    public void setMethodsWireNames() {
        for (Map.Entry<String, List<Method>> entry : this._multiRegistry.entrySet()) {
            String methodName = entry.getKey();
            for (Method method : entry.getValue()) {
                String wsdlName2 = method.getContainer().getWsdlName() + "_" + MethodsRegistrar.getWsdlName(method, methodName);
                method.setWsdlName(wsdlName2);
            }
        }
        for (Map.Entry<String, Object> entry : this._registry.entrySet()) {
            Method method = (Method)entry.getValue();
            String wsdlName3 = MethodsRegistrar.getWsdlName(method, entry.getKey());
            method.setWsdlName(wsdlName3);
        }
    }

    public static String getMethodName(wsdlName wsdlName2, String name) {
        return wsdlName2 != null ? wsdlName2.value() : Utils.capitalize(name);
    }

    private static String getWsdlName(Method method, String methodName) {
        return method.isTask() ? methodName + "_Task" : methodName;
    }
}

