/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators;

import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.model.Namespace;
import emitters.model.Product;
import emitters.model.ReleaseVersions;
import emitters.model.Version;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import vmodl.internalBefore;
import vmodl.nsDescription;
import vmodl.releaseVersions;
import vmodl.releaseVersionsList;
import vmodl.supportsManagedObjectsOf;
import vmodl.versionDef;
import vmodl.viJsonReleases;

public class LifecycleEmitter
extends VmodlEmitter {
    private static final String VERSION_KIND_PREFIX = versionDef.Kind.class.getCanonicalName() + ".";
    private static final String VERSION_KIND_FEATURE = VERSION_KIND_PREFIX + versionDef.Kind.FEATURE;
    private static final String VERSION_KIND_MILESTONE = VERSION_KIND_PREFIX + versionDef.Kind.MILESTONE;
    private static final String VERSION_KIND_LTS = VERSION_KIND_PREFIX + versionDef.Kind.LTS;
    private final String _folder;
    private final Map<String, String> _productNextVersionMap = new HashMap<String, String>();
    private static final String PRODUCT = "product.";

    public LifecycleEmitter(Map<String, String> options, String folder) {
        this._folder = folder;
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(PRODUCT)) {
                throw new RuntimeException("Unknown option key given -Alifecycle." + key);
            }
            String product = key.substring(PRODUCT.length());
            this._productNextVersionMap.put(product, entry.getValue());
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.emitPackageInfo(Versions.getVmodlNamespace());
        this.emitSedScripts(Versions.getVmodlNamespace());
        this.emitNextRelease();
    }

    private void emitNextRelease() {
        for (Map.Entry<String, String> entry : this._productNextVersionMap.entrySet()) {
            String productKey = entry.getKey();
            Product product = Product.products.get(productKey);
            if (product == null) {
                throw new RuntimeException("Unknown product given " + productKey);
            }
            this.beginFile(productKey + "-next-release.pseudo-java");
            this.emitLine("@" + viJsonReleases.class.getSimpleName() + "({", INDENT);
            ArrayList<String> naturalOrderReleleases = new ArrayList<String>(product.getViJsonReleases());
            Collections.reverse(naturalOrderReleleases);
            for (String releaseName : naturalOrderReleleases) {
                this.emitLine(LifecycleEmitter.qq(releaseName));
            }
            this.emitLine(UNINDENT, "})");
            this.endFile();
        }
    }

    private void emitSedCommands(String releaseId, Version version) {
        if (version == null) {
            return;
        }
        String fullyQualified = version.getVmodlName();
        String simpleName = version.getSimpleName();
        this.emitLine("sed -i \\");
        this.indent();
        this.emitLine("-e '/import " + fullyQualified + "/d' \\");
        this.emitLine("-e '/import " + internalBefore.class.getCanonicalName() + "/d' \\");
        this.emitLine("-e 's/@" + simpleName + "/@released(\"" + releaseId + "\")/' \\");
        this.emitLine("-e 's/@" + fullyQualified + "/@released(\"" + releaseId + "\")/' \\");
        this.emitLine("-e 's/@internalBefore(" + simpleName + ".class)/@wasInternalBefore(\"" + releaseId + "\")/' \\");
        this.emitLine("-e 's/@internalBefore(" + fullyQualified + ".class)/@wasInternalBefore(\"" + releaseId + "\")/' \\");
        this.emitLine("$1");
        this.unindent();
    }

    private void emitSedScripts(String vmodlNamespace) {
        Namespace ns = Versions.getNamespace(vmodlNamespace);
        if (ns == null) {
            return;
        }
        this.beginFile(vmodlNamespace + "-version-sed.sh");
        for (Map.Entry<String, ReleaseVersions> entry : ns.getReleaseVersionsMap().entrySet()) {
            String releaseId = entry.getKey();
            ReleaseVersions vRelease = entry.getValue();
            this.emitSedCommands(releaseId, vRelease.ltsVersion());
        }
        this.endFile();
    }

    private void emitPackageInfo(String vmodlNamespace) {
        this.beginFile(vmodlNamespace + "-package-info.java");
        this.emitNamespaceDescription(vmodlNamespace);
        this.emitLine("package " + vmodlNamespace + ";");
        this.endFile();
    }

    private void emitNamespaceDescription(String vmodlNamespace) {
        Namespace ns = Versions.getNamespace(vmodlNamespace);
        this.emitLine(this.makeAnnotation(nsDescription.class) + "(", INDENT);
        this.emitLine("releases = " + this.makeAnnotation(releaseVersionsList.class) + "({", INDENT);
        if (ns != null) {
            this.emitWithNs(ns);
        } else {
            this.emitFromVersionList(Versions.enumerateVersions());
        }
        this.emitLine(UNINDENT, "}),");
        this.emitLine("versions = {", INDENT);
        if (ns != null) {
            this.emitVersionDefsFromNS(ns);
        } else {
            this.emitVersionDefsFromVersionList(Versions.enumerateVersions());
        }
        this.emitLine(UNINDENT, "}");
        this.emitLine(UNINDENT, ")");
    }

    private void emitVersionDefsFromNS(Namespace ns) {
        for (ReleaseVersions rv : ns.getReleaseVersions()) {
            this.emitVersionDef(rv.ltsVersion());
        }
    }

    private void emitVersionDefsFromVersionList(List<Version> versions) {
        for (Version version : versions) {
            if (version.getKind() != Version.Kind.LTS) continue;
            this.emitVersionDef(version);
        }
    }

    private void emitWithNs(Namespace ns) {
        Iterator<Map.Entry<String, ReleaseVersions>> releaseIt = ns.getReleaseVersionsMap().entrySet().iterator();
        while (releaseIt.hasNext()) {
            Map.Entry<String, ReleaseVersions> entry = releaseIt.next();
            ReleaseVersions release = entry.getValue();
            this.emitLine(this.makeAnnotation(releaseVersions.class) + "(", INDENT);
            this.emitPartial("id = \"" + entry.getKey() + "\"");
            if (release.ltsVersion() != null) {
                this.emitLine(",");
                this.emitPartial("ltsVersion = \"" + release.ltsVersion().getVmodlName() + "\"");
            }
            this.emitLine(UNINDENT, ")" + (releaseIt.hasNext() ? "," : ""));
        }
    }

    private void emitFromVersionList(List<Version> versions) {
        for (int i = 0; i < versions.size(); ++i) {
            Version version = versions.get(i);
            Version.Kind kind = version.getKind();
            if (kind != Version.Kind.LTS) continue;
            this.emitLine(this.makeAnnotation(releaseVersions.class) + "(", INDENT);
            this.emitPartial("id = \"" + version.getWireId() + "\"");
            this.emitLine(",");
            this.emitPartial("ltsVersion = \"" + version.getVmodlName() + "\"");
            this.emitLine(UNINDENT, ")" + (i + 1 < versions.size() ? "," : ""));
        }
    }

    private String getVersionKind(Version version) {
        switch (version.getKind()) {
            case FEATURE: {
                return VERSION_KIND_FEATURE;
            }
            case MILESTONE: {
                return VERSION_KIND_MILESTONE;
            }
        }
        return VERSION_KIND_LTS;
    }

    private void emitVersionDef(Version version) {
        this.emitLine("@" + versionDef.class.getCanonicalName() + "(", INDENT);
        this.emitLine("id = \"" + version.getSimpleName() + "\",");
        this.emitLine("kind = " + this.getVersionKind(version) + ",");
        this.emitLine("wsdlName = \"" + version.getWireNs() + "\",");
        this.emitLine("versionId = \"" + version.getWireId() + "\",");
        this.emitLine("displayName = \"" + version.getDisplayName() + "\",");
        supportsManagedObjectsOf supportedMOs = version.getSupportedMO();
        if (supportedMOs != null) {
            String[] mos = supportedMOs.value();
            ArrayList<String> outMOs = new ArrayList<String>();
            this.emitPartial("supportedMO = ");
            this.emitPartial(this.makeAnnotation(supportsManagedObjectsOf.class) + "({");
            for (String mo : mos) {
                outMOs.add("\"" + mo + "\"");
            }
            this.emitJoin(outMOs, ",");
            this.emitLine("}),");
        }
        Set<Version> parents = version.getDirectParents();
        TreeSet<String> asStrings = new TreeSet<String>();
        for (Version parent : parents) {
            asStrings.add("\"" + parent.getVmodlName() + "\"");
        }
        if (asStrings.size() != 0) {
            String compatibleVersions = "{ " + LifecycleEmitter.join(asStrings, ", ") + " }";
            this.emitLine("compatible = " + compatibleVersions);
        }
        this.emitLine(UNINDENT, "),");
    }

    private void emitJoin(List<String> toEmit, String sep) {
        if (sep.equals("\n")) {
            for (String str : toEmit) {
                this.emitLine(str);
            }
        } else {
            String joined = LifecycleEmitter.join(toEmit, sep);
            this.emitPartial(joined);
        }
    }

    private String makeAnnotation(Class<?> cls) {
        return "@" + cls.getCanonicalName();
    }

    @Override
    protected void beginFile(String filename) {
        super.beginFile(this._folder + "/" + filename);
    }
}

