/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.info;

import emitters.VmodlEmitter;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ListPrivileges
extends VmodlEmitter {
    private final String _folderPrefix;
    private final Kind _kind;
    private ManagedObject _currentMo;
    private String _apiKind;
    private Kind _reportKind;
    private boolean _isFileOpened;
    private boolean _isHeaderWritten;

    public ListPrivileges(Map<String, String> options, String folder) {
        this._folderPrefix = folder + File.separator;
        Kind kind = null;
        String kindParameter = options.get("kind");
        if (kindParameter != null) {
            if (kindParameter.equals("anonymous")) {
                kind = Kind.ANONYMOUS;
            } else if (kindParameter.equals("dynamic")) {
                kind = Kind.DYNAMIC;
            } else if (kindParameter.equals("default")) {
                kind = Kind.DEFAULT;
            } else {
                throw new RuntimeException("Unsupported info.perm.kind: " + kindParameter);
            }
        }
        this._kind = kind;
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.processObjectList(objects);
        this.setReportingContext(null, null, null);
    }

    private void processObjectList(Collection<VmodlObject> objects) {
        for (VmodlObject object : objects) {
            switch (object.getKind()) {
                case ManagedObject: {
                    ManagedObject managedObject = (ManagedObject)object;
                    if (this._kind != null) {
                        this.processManagedObject(managedObject, this._kind);
                        break;
                    }
                    this.processManagedObject(managedObject, Kind.ANONYMOUS);
                    this.processManagedObject(managedObject, Kind.DYNAMIC);
                    this.processManagedObject(managedObject, Kind.DEFAULT);
                    break;
                }
            }
            this.processObjectList(object.getNestedList());
        }
    }

    private void processManagedObject(ManagedObject managedObject, Kind kind) {
        this.setReportingContext(managedObject, "Methods", kind);
        for (Method method : managedObject.getMethodList()) {
            if (!this.shouldReport(method.getPrivilegeId(), method.isDynamicPrivs(), kind)) continue;
            this.reportApi(method);
        }
        this.setReportingContext(managedObject, "Managed properties", kind);
        for (Property property : managedObject.getPropertyListWithOverrides()) {
            if (!this.shouldReport(property.getPrivilegeId(), false, kind)) continue;
            this.reportApi(property);
        }
    }

    private boolean shouldReport(String privId, boolean isDynamic, Kind kind) {
        switch (kind) {
            case ANONYMOUS: {
                return "System.Anonymous".equals(privId);
            }
            case DYNAMIC: {
                return isDynamic;
            }
            case DEFAULT: {
                return privId == null && !isDynamic;
            }
        }
        return false;
    }

    private void setReportingContext(ManagedObject managedObject, String apiKind, Kind reportKind) {
        if (!(!this._isHeaderWritten || this._apiKind.equals(apiKind) && this._reportKind.equals((Object)reportKind))) {
            this.unindent();
            this.emitLine();
            this._isHeaderWritten = false;
        }
        if (this._isFileOpened && managedObject != this._currentMo) {
            this.endFile();
            this._isFileOpened = false;
        }
        this._currentMo = managedObject;
        this._apiKind = apiKind;
        this._reportKind = reportKind;
    }

    private void reportApi(VmodlApi vmodlApi) {
        if (!this._isFileOpened) {
            this._isFileOpened = true;
            this.beginFile(this._currentMo);
            this.emitLine("Executables in ", this._currentMo.getQualifiedVmodlType(), ":");
            this.emitLine();
        }
        if (!this._isHeaderWritten) {
            this._isHeaderWritten = true;
            this.emitLine(this._apiKind, " with ", this._reportKind.toString(), " access:");
            this.indent();
        }
        this.emitLine("- ", vmodlApi.getName());
    }

    private void beginFile(VmodlObject object) {
        String fileName = object.getQualifiedVmodlType().replace(".", File.separator);
        this.beginFile(this._folderPrefix + fileName + ".txt");
    }

    static enum Kind {
        ANONYMOUS,
        DYNAMIC,
        DEFAULT;

    }
}

