/*
 * Decompiled with CFR 0.152.
 */
package emitters.javac;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Options
extends emitters.core.Options {
    private Set<String> _cmdLineEmitSet = new HashSet<String>();

    public boolean mustFilterCmdLineFiles() {
        return !this._cmdLineEmitSet.isEmpty();
    }

    public boolean shouldEmitCmdLineFile(String source) {
        if (source == null || source.isEmpty()) {
            return true;
        }
        return this._cmdLineEmitSet.contains(source);
    }

    private boolean isFileArgumentList(String filePath) {
        Path path = Paths.get(filePath.substring(1), new String[0]);
        try {
            List<String> lines = Files.readAllLines(path, Charset.defaultCharset());
            for (String line : lines) {
                if (!line.startsWith("-A")) continue;
                return false;
            }
            this._cmdLineEmitSet.addAll(lines);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean platformSpecificOption(String optionName, String optionValue) {
        if (optionName.equals("want.passed.in.files")) {
            String cmdLine = System.getProperty("sun.java.command");
            if (cmdLine != null) {
                String option;
                String[] stringArray = cmdLine.split(" ");
                int n = stringArray.length;
                for (int i = 0; !(i >= n || (option = stringArray[i]).startsWith("@") && this.isFileArgumentList(option)); ++i) {
                    File file = new File(option);
                    if (!file.isFile() || !file.exists()) continue;
                    this._cmdLineEmitSet.add(option);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void Parse(Map<String, String> rawOptions) {
        for (Map.Entry<String, String> entry : rawOptions.entrySet()) {
            if (this.platformSpecificOption(entry.getKey(), entry.getValue())) continue;
            this.processOption(entry.getKey(), entry.getValue());
        }
        this.finalizeParsing();
    }
}

