/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.model.Property;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import emitters.model.raw.RawObject;
import emitters.model.raw.RawVersion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DataObject
extends VmodlObject {
    private boolean _hasKey;
    private boolean _hasDynamicProperties;

    public DataObject(RawObject rawObject, RawVersion rawVersion) {
        super(rawObject, rawVersion);
    }

    public void setDynamic() {
        this._hasDynamicProperties = true;
    }

    public void setupDynamicProperty() {
        this._propertyList.add(null);
        this._propertyListDigest = new ArrayList();
    }

    public void updateDynamicProperty(Property property) {
        this._propertyList.set(0, property);
    }

    public void removeDynamicProperty() {
        this._propertyList.remove(0);
    }

    @Override
    public void addProperty(Property prop) {
        super.addProperty(prop);
        if (prop.getName().equals("key") && prop.getDecl().getTypeId() == VmodlDecl.TypeId.STRING) {
            this._hasKey = true;
        }
    }

    @Override
    public VmodlObject.Kind getKind() {
        return VmodlObject.Kind.DataObject;
    }

    public Set<VmodlDecl> getReferencedDecls(boolean wantFaults) {
        HashSet<VmodlDecl> declSet = new HashSet<VmodlDecl>();
        for (Property p : this._propertyList) {
            declSet.add(p.getDecl());
        }
        return declSet;
    }

    public boolean hasKey() {
        return this._hasKey;
    }

    public boolean hasDynamicProperties() {
        return this._hasDynamicProperties;
    }

    public int getNextPropIndex() {
        return this._propertyList.size();
    }

    @Override
    public void print() {
        super.print();
        System.out.println("Has key: " + this._hasKey);
        System.out.println("Has dynamic properties: " + this._hasDynamicProperties);
    }
}

