/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import com.sun.source.util.DocTreePath;
import emitters.Utils;
import emitters.Versions;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.function.Supplier;

public class ManagedProperty
extends Property {
    private Version _internalBefore;

    public ManagedProperty(VmodlObject container, String name, String wsdlName2, VmodlDecl decl, String privId, Version version, String comment, Supplier<DocTreePath> docSupplier) {
        super(container, name, wsdlName2, decl, true, privId, version, comment, docSupplier);
        this.validateVisibility(container, decl);
    }

    ManagedProperty(ManagedProperty mprop, Version version) {
        super(mprop, version);
        this.validateVisibility(this._container, mprop._decl);
    }

    public void setInternalBefore(Version version) {
        this._internalBefore = version;
    }

    @Override
    public Method getAccessor() {
        String accessorName = this.getAccessorPrefix() + Utils.capitalize(this.getName());
        Method method = new Method(this._container, accessorName, this._decl, this._privId, this.getVersion(), this.getComment(), this.getDocSupplier());
        method.setWsdlName("Get" + this._wsdlName);
        return method;
    }

    @Override
    public Method getMutator() {
        String mutatorName = this.getMutatorPrefix() + Utils.capitalize(this.getName());
        Method method = new Method(this._container, mutatorName, VmodlDecl.voidType, this.getVersion(), this.getComment());
        method.setWsdlName("Set" + this._wsdlName);
        method.addParameter(new Parameter("val", this._decl, this._privId, this.getVersion(), this.getComment(), this.getDocSupplier()));
        return method;
    }

    @Override
    public Method getUnsetter() {
        throw new RuntimeException("Managed properties have no unsetter");
    }

    @Override
    public Method getPeeker() {
        String peekerName = this.getPeekerPrefix() + Utils.capitalize(this.getName());
        return new Method(this._container, peekerName, this._decl, this.getVersion(), this.getComment());
    }

    @Override
    public Method getSwapper() {
        String swapperName = this.getSwapperPrefix() + Utils.capitalize(this.getName());
        Method method = new Method(this._container, swapperName, VmodlDecl.voidType, this.getVersion(), this.getComment());
        method.addParameter(new Parameter("val", this._decl, this.getVersion(), this.getComment(), this.getDocSupplier()));
        return method;
    }

    @Override
    public String getAccessorPrefix() {
        return this._decl.isBoolean() ? "Is" : "Get";
    }

    @Override
    public String getMutatorPrefix() {
        if (this._readonly) {
            throw new RuntimeException("Readonly managed property has no mutator");
        }
        return "Set";
    }

    @Override
    public String getUnsetterPrefix() {
        if (this._decl.isOptional() && this._decl.isPrimitive() && !this._decl.isArray()) {
            return "Unset";
        }
        throw new RuntimeException("Unset used for non-optional-primitive type");
    }

    @Override
    public String getPeekerPrefix() {
        return "Peek";
    }

    @Override
    public String getSwapperPrefix() {
        return "Swap";
    }

    @Override
    public boolean isInternal() {
        return this._decl.isInternal();
    }

    @Override
    public Version getInternalBefore() {
        return this._internalBefore;
    }

    @Override
    void enqueueDigest(VmodlApi vmodlApi) {
        super.enqueueDigest(vmodlApi);
        this.getVersion().enqueueDigestWsdlName(this);
    }

    @Override
    void print(String indent) {
        super.print(indent);
        if (this._internalBefore != null) {
            System.out.print(" internal before: " + this._internalBefore.getVmodlName());
        }
    }

    private void validateVisibility(VmodlObject container, VmodlDecl decl) {
        if (container == null || container.isInternal() || decl.getObject() == null) {
            return;
        }
        if (!this.isInternal() && decl.getObject().isInternal()) {
            Versions.reportVisibilityViolation("Official type " + container.getVmodlName() + " has an official property " + this.getVmodlName() + " of internal type " + decl.getObject().getVmodlName());
        }
    }
}

