/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.backend.FeatureState;
import emitters.backend.FssConfig;
import emitters.backend.Platform;
import emitters.model.Feature;
import emitters.model.Namespace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import vmodl.featureList;
import vmodl.featureSpec;
import vmodl.releasedFeaturesList;
import vmodl.syntheticBase;
import vmodl.syntheticBaseList;
import vmodl.viJsonReleases;

public class Product {
    public static Map<String, Product> products = new HashMap<String, Product>();
    private final String _name;
    private FssConfig _fssConfig;
    private final Set<Feature> _features = new HashSet<Feature>();
    private final Map<String, Feature> _featureMap = new HashMap<String, Feature>();
    private final Set<String> _releasedFeatures = new LinkedHashSet<String>();
    private final Map<String, String> _syntheticBases = new HashMap<String, String>();
    private LinkedHashSet<String> _viJsonReleases;
    private static final List<Feature> NO_PARENTS = new ArrayList<Feature>(0);

    public Product(String name, featureList featureList2, releasedFeaturesList releasedFeaturesList2, syntheticBaseList syntheticBaseList2, viJsonReleases viJsonReleases2) {
        this._name = name;
        String configClass = "emitters.config." + name + "FssConfig";
        this._fssConfig = Platform.fetchFssConfig(configClass);
        this.retrieveFeatures(featureList2.value());
        this.retrieveReleasedFeatures(releasedFeaturesList2.value());
        this.retrieveSyntheticBases(syntheticBaseList2.value());
        this.retrieveViJsonReleases(viJsonReleases2.value());
    }

    private void retrieveFeatures(featureSpec[] featureList2) {
        this.validateFeatureSpec(featureList2);
        this.fillFeatureMap(featureList2, 0);
    }

    private void validateFeatureSpec(featureSpec[] featureList2) {
        if (this._name.contains("Test")) {
            return;
        }
        String previousName = "";
        for (featureSpec feature2 : featureList2) {
            String name = feature2.name();
            int result = name.compareToIgnoreCase(previousName);
            if (result <= 0) {
                throw new RuntimeException("Features in non-alphabetical order in product " + this._name + ": " + previousName + " followed by " + name);
            }
            previousName = name;
        }
    }

    private void fillFeatureMap(featureSpec[] featureSpecs, int index) {
        for (int i = index; i < featureSpecs.length; ++i) {
            Feature feature2;
            List<Feature> parents;
            featureSpec fspec = featureSpecs[i];
            String featureName = fspec.name();
            String[] featureDeps = fspec.dependencies();
            if (this._featureMap.containsKey(featureName)) continue;
            if (featureDeps.length == 0) {
                parents = NO_PARENTS;
            } else {
                boolean recurse = false;
                parents = new ArrayList<Feature>();
                int j = 0;
                while (j < featureDeps.length) {
                    if (this._featureMap.containsKey(featureDeps[j])) {
                        parents.add(this._featureMap.get(featureDeps[j]));
                        ++j;
                        continue;
                    }
                    if (recurse) {
                        throw new RuntimeException("Feature '" + featureName + "' depends on '" + featureDeps[j] + "' which is not defined or there is a circular dependency in  product " + this._name);
                    }
                    recurse = true;
                    this.fillFeatureMap(featureSpecs, i + 1);
                }
            }
            switch (this._fssConfig.getState(featureName)) {
                case DISABLED: {
                    feature2 = new Feature(featureName, parents);
                    this._features.add(feature2);
                    break;
                }
                case ENABLED: {
                    String message = "The feature '" + featureName + "' is enabled. Remove references from @featureList and add the feature name to @releasedFeaturesList.\nTo ensure backward compatibility during product development, follow the below RULES for the @releasedFeaturesList content:\n- The list of enabled/released features must be kept in reverse chronological order (the latest enabled feature is on the top).\n- Do NOT remove the feature's name as a part of the feature cleanup.\n";
                    throw new RuntimeException(message);
                }
                default: {
                    throw new RuntimeException("Unsupported state for feature " + featureName);
                }
            }
            this._featureMap.put(featureName, feature2);
        }
    }

    private void retrieveReleasedFeatures(String[] releasedFeatures) {
        for (int i = releasedFeatures.length - 1; i >= 0; --i) {
            String releasedFeature2 = releasedFeatures[i];
            FeatureState fs = this._fssConfig.checkState(releasedFeature2);
            if (fs != null && fs != FeatureState.ENABLED) {
                String message = "The feature '" + releasedFeature2 + "' is not marked as released. Remove the feature's name from @releasedFeaturesList, and update @featureList.";
                throw new RuntimeException(message);
            }
            this._releasedFeatures.add(releasedFeature2);
        }
    }

    private void retrieveSyntheticBases(syntheticBase[] syntheticBases) {
        for (syntheticBase syntheticBase2 : syntheticBases) {
            if (this._syntheticBases.put(syntheticBase2.namespace(), syntheticBase2.wireId()) == null) continue;
            throw new RuntimeException("Re-definition of sytnehtic base for namespace " + syntheticBase2.namespace());
        }
    }

    private void retrieveViJsonReleases(String[] viJsonReleases2) {
        this._viJsonReleases = new LinkedHashSet<String>(Arrays.asList(viJsonReleases2));
    }

    public Feature getFeature(String name) {
        return this._featureMap.get(name);
    }

    public String getName() {
        return this._name;
    }

    public FssConfig getFssConfig() {
        return this._fssConfig;
    }

    public Set<Feature> getFeatures() {
        return this._features;
    }

    public Set<String> getReleasedFeatures() {
        return this._releasedFeatures;
    }

    public String getSyntheticBase(Namespace namespace) {
        String name = namespace.getName();
        String syntheticBase2 = this._syntheticBases.get(name);
        if (syntheticBase2 == null) {
            throw new RuntimeException("Missing synthetic base config for namespace " + name);
        }
        return syntheticBase2.isEmpty() ? null : syntheticBase2;
    }

    public LinkedHashSet<String> getViJsonReleases() {
        return this._viJsonReleases;
    }
}

