/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.backend.Platform;
import emitters.model.Entity;
import emitters.model.SourcePos;
import emitters.model.VmodlObject;
import java.util.Comparator;

public class ScopedSourcedOrderComparator
implements Comparator<Entity> {
    final VmodlObject _scope;

    public ScopedSourcedOrderComparator(VmodlObject scope) {
        this._scope = scope;
    }

    @Override
    public int compare(Entity lhs, Entity rhs) {
        if (lhs.equals(rhs)) {
            return 0;
        }
        SourcePos p1 = Platform.getSourcePos(this._scope, lhs);
        SourcePos p2 = Platform.getSourcePos(this._scope, rhs);
        if (p1 == null) {
            return p2 == null ? 0 : -1;
        }
        if (p2 == null) {
            return 1;
        }
        int order = p1.fileName.compareTo(p2.fileName);
        if (order == 0 && (order = p1.line - p2.line) == 0 && (order = p1.column - p2.column) == 0) {
            order = System.identityHashCode(lhs) - System.identityHashCode(rhs);
        }
        return order;
    }
}

