/*
 * Decompiled with CFR 0.152.
 */
package emitters.wsdl;

import emitters.Services;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.model.Entity;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class BaseXMLGenerator
extends VmodlEmitter {
    int _indentationLevel;
    static Map<VmodlDecl.TypeId, String> _vmodlDeclTypeMap;
    boolean _synthesizeArrayTypes = true;
    boolean _wrapArrayTypeParameters = false;
    boolean _importAutoPrepTypes = false;
    boolean _mapManagedObjectsToXsdString = false;
    boolean _addThisParameterToOperations = true;
    boolean _addRuntimeFaultToOPerations = true;
    boolean _singleFault = false;
    boolean _needManagedObjectReferenceType;
    boolean _needStringArrayType;
    boolean _needAnyTypeArrayType;
    boolean _needDateTimeArrayType;
    boolean _needUriArrayType;
    boolean _needManagedObjectReferenceArrayType;
    boolean _needBinaryArrayType;
    private boolean _initialized = false;
    protected Collection<VmodlObject> _vmodlObjects;
    protected String _outputDirPath;
    boolean _needVmodlDeclMoArrayType = false;
    private Set<VmodlObject> _vmodlDeclNeedingArrayType = new HashSet<VmodlObject>();
    Set<VmodlDecl.TypeId> _vmodlDeclPrimitivesNeedingArrayType = new TreeSet<VmodlDecl.TypeId>();

    public BaseXMLGenerator() throws InvalidOptionValueException {
        if (!this._initialized) {
            this._initialized = true;
            this.fillPrimitiveTypeMap();
        }
        this._needStringArrayType = false;
        this._needAnyTypeArrayType = false;
        this._needDateTimeArrayType = false;
        this._needUriArrayType = false;
        this._needManagedObjectReferenceArrayType = false;
        this._needBinaryArrayType = false;
    }

    abstract void fillPrimitiveTypeMap();

    boolean needStringArray() {
        return this._vmodlDeclPrimitivesNeedingArrayType.contains((Object)VmodlDecl.TypeId.STRING);
    }

    boolean needAnyArray() {
        return this._vmodlDeclPrimitivesNeedingArrayType.contains((Object)VmodlDecl.TypeId.ANY);
    }

    boolean needDateTimeArray() {
        return this._vmodlDeclPrimitivesNeedingArrayType.contains((Object)VmodlDecl.TypeId.DATETIME);
    }

    boolean needURIArray() {
        return this._vmodlDeclPrimitivesNeedingArrayType.contains((Object)VmodlDecl.TypeId.URI);
    }

    boolean needBinaryArray() {
        return this._vmodlDeclPrimitivesNeedingArrayType.contains((Object)VmodlDecl.TypeId.BINARY);
    }

    boolean needMoRefArray() {
        return this._needVmodlDeclMoArrayType;
    }

    boolean needArrayOf(VmodlObject obj) {
        return this._vmodlDeclNeedingArrayType.contains(obj);
    }

    private void collectVmodlDecl(VmodlDecl decl) {
        if (!decl.isArray()) {
            return;
        }
        if (decl.isPrimitive() && !decl.getTypeId().equals((Object)VmodlDecl.TypeId.ENUM) || decl.getTypeId().equals((Object)VmodlDecl.TypeId.ANY)) {
            this._vmodlDeclPrimitivesNeedingArrayType.add(decl.getTypeId());
            return;
        }
        if (decl.isManaged()) {
            this._needVmodlDeclMoArrayType = true;
            return;
        }
        this._vmodlDeclNeedingArrayType.add(decl.getObject());
    }

    private boolean relaxedShouldGenerateFor(Method api) {
        if (api.isExplicitlyInternal() && this.hideInternalDecls()) {
            return false;
        }
        if (api.isUndocumented() && this.hideUndocumentedDecls()) {
            return false;
        }
        Version ib = api.getInternalBefore();
        Version target = Versions.getTargetVersion();
        return Versions.isTargetNewerThan(api.getVersion()) && (ib == null || ib == target || Versions.isTargetNewerThan(ib));
    }

    private void collectMoNeededArray(ManagedObject mobj) {
        for (Method method : mobj.getMethodList()) {
            if (!this.relaxedShouldGenerateFor(method)) continue;
            this.collectVmodlDecl(method.getReturnDecl());
            for (Parameter param : method.getParameterList()) {
                if (!this.shouldGenerateFor(param)) continue;
                this.collectVmodlDecl(param.getDecl());
            }
        }
        this.collectPropertiesNeedingArray(mobj);
    }

    private boolean shouldGenerateForDecl(VmodlDecl decl) {
        return decl.getObject() == null || this.shouldGenerateFor(decl.getObject());
    }

    private void collectPropertiesNeedingArray(VmodlObject dobj) {
        for (Property prop : dobj.getPropertyList()) {
            if (!this.shouldGenerateFor(dobj, prop) || !this.shouldGenerateForDecl(prop.getDecl())) continue;
            this.collectVmodlDecl(prop.getDecl());
        }
    }

    private void collectSynthesizedArrayTypesImpl(Collection<VmodlObject> objs) {
        for (VmodlObject obj : objs) {
            switch (obj.getKind()) {
                case Enum: {
                    break;
                }
                case ManagedObject: {
                    this.collectMoNeededArray((ManagedObject)obj);
                    break;
                }
                case DataObject: {
                    this.collectPropertiesNeedingArray(obj);
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error: VmodlObject is of unknown kind");
                }
            }
            if (obj.getNestedList().size() == 0) continue;
            this.collectSynthesizedArrayTypesImpl(obj.getNestedList());
        }
    }

    void collectSynthesizedArrayTypes() {
        this.collectSynthesizedArrayTypesImpl(this._vmodlObjects);
    }

    String schemaNamespaceId(VmodlObject obj) {
        String serviceNS = Services.schemaNamespaceId(obj.getVersion());
        if (!this.hideInternalDecls()) {
            serviceNS = "internal" + serviceNS;
        }
        return serviceNS;
    }

    @Override
    protected void indent() {
        ++this._indentationLevel;
    }

    @Override
    protected void unindent() {
        --this._indentationLevel;
        if (this._indentationLevel < 0) {
            throw new IllegalStateException("negative indentation level");
        }
    }

    void emitIndentation(PrintWriter out) {
        for (int i = 0; i < this._indentationLevel; ++i) {
            out.print("   ");
        }
    }

    static void emitNewline(PrintWriter out) {
        out.print("\n");
    }

    static void emitString(PrintWriter out, String s) {
        out.print(s);
    }

    static void emitFormattedString(PrintWriter out, String format, Object ... args) {
        out.printf(format, args);
    }

    void emitIndentedLine(PrintWriter out, String format, Object ... args) {
        this.emitIndentation(out);
        out.printf(format, args);
        BaseXMLGenerator.emitNewline(out);
    }

    protected String schemaTypeReferenceDo(VmodlObject obj) {
        return this.schemaId(obj) + ':' + obj.getWsdlName();
    }

    protected String schemaTypeReference(VmodlObject obj, VmodlDecl decl) {
        if (obj != null && decl.isLink()) {
            return this.schemaDefaultNS() + "string";
        }
        if (_vmodlDeclTypeMap.containsKey((Object)decl.getTypeId())) {
            return _vmodlDeclTypeMap.get((Object)decl.getTypeId());
        }
        if (decl.isManaged()) {
            String result = this._mapManagedObjectsToXsdString ? this.schemaDefaultNS() + "string" : this.schemaArrayPrefix() + ":ManagedObjectReference";
            return result;
        }
        if (decl.isData() || decl.isEnum()) {
            return this.schemaTypeReferenceDo(obj);
        }
        if (decl.isPrimitive()) {
            return this.schemaDefaultNS() + decl.getTypeId().toString().toLowerCase();
        }
        throw new RuntimeException("Unknown VmodlDecl and VmodlObject for " + (Object)((Object)decl.getTypeId()) + " " + (obj == null ? "" : obj.getQualifiedVmodlType()));
    }

    public static String getNonTaskWsdlName(String wsdlName2) {
        int index = wsdlName2.lastIndexOf("_Task");
        if (index < 0) {
            return wsdlName2;
        }
        return wsdlName2.substring(0, index);
    }

    abstract String schemaId(VmodlObject var1);

    abstract String schemaArrayPrefix();

    abstract String schemaDefaultNS();

    static <T> SortedSet<T> sortedSet(Comparator<? super T> comparator, Collection<T> collection) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        treeSet.addAll(collection);
        return treeSet;
    }

    static <T extends Entity> SortedSet<T> sortedLocatables(Collection<T> collection, Comparator<Entity> comparator) {
        return BaseXMLGenerator.sortedSet(comparator, collection);
    }

    static <T extends VmodlObject> SortedSet<T> sortedVmodlObjects(Collection<T> collection, Comparator<VmodlObject> comparator) {
        return BaseXMLGenerator.sortedSet(comparator, collection);
    }

    public static class InvalidOptionValueException
    extends OptionException {
        private String _value;

        public InvalidOptionValueException(String option, String value) {
            super(option);
            this._value = value;
        }

        public String getValue() {
            return this._value;
        }
    }

    static class MissingRequiredOptionException
    extends OptionException {
        public MissingRequiredOptionException(String option) {
            super(option);
        }
    }

    static class OptionException
    extends RuntimeException {
        private String _option;

        public OptionException(String option) {
            this._option = option;
        }

        public String getOption() {
            return this._option;
        }
    }
}

