/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.ssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

class SslUtil {
    private static final String HEX = "0123456789ABCDEF";
    private static final String THUMBPRINT_ALGO_SHA1 = "SHA-1";
    private static final String THUMBPRINT_ALGO_SHA256 = "SHA-256";

    private static String computeSHA1Thumbprint(X509Certificate cert) throws CertificateEncodingException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(THUMBPRINT_ALGO_SHA1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        byte[] digest = md.digest(cert.getEncoded());
        StringBuilder thumbprint = new StringBuilder();
        int len = digest.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                thumbprint.append(':');
            }
            byte b = digest[i];
            thumbprint.append(HEX.charAt((b & 0xF0) >> 4));
            thumbprint.append(HEX.charAt(b & 0xF));
        }
        return thumbprint.toString();
    }

    private static String computeSHA256Thumbprint(X509Certificate cert) throws CertificateEncodingException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(THUMBPRINT_ALGO_SHA256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        StringBuilder thumbprint = new StringBuilder();
        for (byte b : md.digest(cert.getEncoded())) {
            thumbprint.append(HEX.charAt((b & 0xF0) >> 4));
            thumbprint.append(HEX.charAt(b & 0xF));
        }
        return thumbprint.toString();
    }

    static String computeCertificateThumbprint(X509Certificate cert, String originalThumbprint) throws CertificateEncodingException {
        if (originalThumbprint == null || originalThumbprint.isEmpty() || originalThumbprint.replaceAll(":", "").length() == 40) {
            return SslUtil.computeSHA1Thumbprint(cert);
        }
        if (originalThumbprint.replaceAll(":", "").length() == 64) {
            return SslUtil.computeSHA256Thumbprint(cert);
        }
        String errMsg = "Got invalid thumbprint length " + originalThumbprint.length();
        throw new IllegalStateException(errMsg);
    }

    private SslUtil() {
    }
}

