/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.token.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidateUtil {
    public static void validateNotNull(Object fieldValue, String fieldName) {
        if (fieldValue == null) {
            ValidateUtil.logAndThrow(String.format("'%s' value should not be NULL", fieldName));
        }
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass().equals(String.class)) {
            return ((String)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        String message = "String, java.lang.Array or java.util.Collection expected but " + obj.getClass().getName() + " was found ";
        ValidateUtil.getLog().error(message);
        throw new IllegalArgumentException(message);
    }

    public static void validateNotEmpty(Object fieldValue, String fieldName) {
        if (ValidateUtil.isEmpty(fieldValue)) {
            ValidateUtil.logAndThrow(String.format("'%s' value should not be empty", fieldName));
        }
    }

    private static void logAndThrow(String msg) {
        ValidateUtil.getLog().error(msg);
        throw new IllegalArgumentException(msg);
    }

    private static Logger getLog() {
        return LoggerFactory.getLogger(ValidateUtil.class);
    }

    private ValidateUtil() {
    }
}

