/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client;

import com.vmware.identity.token.impl.ValidateUtil;
import com.vmware.vim.sso.client.exception.SsoException;
import com.vmware.vim.sso.client.exception.SsoRuntimeException;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleMessageSource {
    private static final String BASE_NAME = "com.vmware.identity.token.impl.messages.Messages";
    private final Logger _log = LoggerFactory.getLogger(BundleMessageSource.class);
    private final ResourceBundle _messages;

    public BundleMessageSource(Locale locale) {
        this._messages = ResourceBundle.getBundle(BASE_NAME, locale);
    }

    public String get(Key key) {
        ValidateUtil.validateNotNull((Object)key, "key");
        return this._messages.getString(key._bundleKey);
    }

    public String createMessage(SsoException e) {
        return this.createMessage(e.getMessageKey(), e.getMessageDetails(), e.getMessage());
    }

    public String createMessage(SsoRuntimeException e) {
        return this.createMessage(e.getMessageKey(), e.getMessageDetails(), e.getMessage());
    }

    String createMessage(Key messageKey, Object[] details, String fallbackMessage) {
        if (messageKey == null) {
            return fallbackMessage;
        }
        Object[] localizedDetails = new Object[details != null ? details.length : 0];
        for (int i = 0; i < localizedDetails.length; ++i) {
            localizedDetails[i] = details[i] instanceof Key ? this.get((Key)((Object)details[i])) : details[i];
        }
        try {
            return String.format(this.get(messageKey), localizedDetails);
        }
        catch (IllegalFormatException e) {
            String roughMessage = this.get(messageKey) + " " + Arrays.asList(localizedDetails);
            this._log.warn("Failed to create valid message for localized pattern&params: " + roughMessage);
            return roughMessage;
        }
    }

    public Locale getLocale() {
        return this._messages.getLocale();
    }

    public static enum Key {
        MALFORMED_SAML_TOKEN("malformedSamlToken"),
        INVALID_SAML_TOKEN("invalidSamlToken"),
        INVALID_CREDENTIALS("invalidCredentials"),
        INVALID_REQUESTED_TIME_RANGE("invalidRequestedTimeRange"),
        RENEW_NEEDED("renewNeeded"),
        POTENITAL_TAMPERING_OF_REQUEST("potenitalTamperingOfRequest"),
        REQUEST_EXPIRED("requestExpired"),
        SIGNATURE_VALIDATION_FAULT("signatureValidationFault"),
        UNEXPECTED_SERVER_ERROR("unexpectedServerError"),
        TIME_SYNCHRONIZATION_ERROR("timeSynchronizationError"),
        UNEXPECTED_RESPONSE_FORMAT("unexpectedResponseFormat"),
        INTERNAL_CLIENT_ERROR("internalClientError"),
        BAD_SERVER_SSL_CERTIFICATE("serverSslCertficateIsNotTrusted"),
        FAILED_TO_CONNECT_TO_SERVER("failedToConnectToServer"),
        ACCOUNT_LOCKED("accountLocked"),
        EXPIRED_PASSWORD("expiredPassword"),
        REQUEST_AFFECTED_BY_TIME_SKEW("requestAffectedByTimeSkew"),
        INVALID_REQUEST("invalidRequest"),
        PARSER_ERROR("serializationError"),
        FAILED_TO_SIGN_REQUEST("failedToSignRequest");

        private final String _bundleKey;

        private Key(String bundleKey) {
            this._bundleKey = bundleKey;
        }
    }
}

