/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.tracing;

import com.vmware.vim.vmomi.core.tracing.GlobalTelemetry;
import com.vmware.vim.vmomi.core.tracing.GlobalTracer;
import com.vmware.vim.vmomi.core.tracing.NoopTracer;
import com.vmware.vim.vmomi.core.tracing.Tracer;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class OtracTracer
implements Tracer {
    private final io.opentracing.Tracer _tracer;

    private OtracTracer(io.opentracing.Tracer tracer) {
        assert (tracer != null);
        this._tracer = tracer;
    }

    static Tracer createFromGlobalTracer() {
        io.opentracing.Tracer tracer = GlobalTracer.get();
        return new OtracTracer(tracer);
    }

    @Override
    public Tracer.Span getActiveSpan() {
        Span span = this._tracer.activeSpan();
        if (span == null) {
            return NoopTracer.INSTANCE.getActiveSpan();
        }
        return new OtracSpan(span);
    }

    @Override
    public <C> Tracer.SpanContext extractFrom(C carrier, Tracer.TextMapGetter<C> getter) {
        SpanContext context = this._tracer.extract(Format.Builtin.HTTP_HEADERS, new OtracTextMapGetter<C>(carrier, getter));
        return new OtracSpanContext(context);
    }

    @Override
    public Tracer.SpanBuilder spanBuilder(String spanName) {
        Tracer.SpanBuilder spanBuilder = this._tracer.buildSpan(spanName);
        return new OtracSpanBuilder(spanBuilder);
    }

    private static final class OtracTextMapGetter<C>
    implements TextMap {
        private final C _carrier;
        private final Tracer.TextMapGetter<C> _getter;

        OtracTextMapGetter(C carrier, Tracer.TextMapGetter<C> getter) {
            this._carrier = carrier;
            this._getter = getter;
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            final Iterator<String> keyIterator = this._getter.keys(this._carrier).iterator();
            return new Iterator<Map.Entry<String, String>>(){

                @Override
                public boolean hasNext() {
                    return keyIterator.hasNext();
                }

                @Override
                public Map.Entry<String, String> next() {
                    final String key = (String)keyIterator.next();
                    return new Map.Entry<String, String>(){

                        @Override
                        public String getKey() {
                            return key;
                        }

                        @Override
                        public String getValue() {
                            return _getter.get(_carrier, key);
                        }

                        @Override
                        public String setValue(String value) {
                            throw new UnsupportedOperationException("setValue");
                        }
                    };
                }
            };
        }

        public void put(String key, String value) {
            throw new UnsupportedOperationException("put");
        }
    }

    private static final class OtracTextMapSetter<C>
    implements TextMap {
        private final C _carrier;
        private final Tracer.TextMapSetter<C> _setter;

        public OtracTextMapSetter(C carrier, Tracer.TextMapSetter<C> setter) {
            this._carrier = carrier;
            this._setter = setter;
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            throw new UnsupportedOperationException("Should be used only with tracer#inject()");
        }

        public void put(String key, String value) {
            this._setter.set(this._carrier, key, value);
        }
    }

    private final class OtracSpan
    implements Tracer.Span {
        private final Span _span;

        OtracSpan(Span span) {
            assert (span != null);
            this._span = span;
        }

        @Override
        public void setAttribute(String key, String value) {
            this._span.setTag(key, value);
        }

        @Override
        public void setAttribute(String key, int value) {
            this._span.setTag(key, (Number)value);
        }

        @Override
        public void setAttribute(String key, boolean value) {
            this._span.setTag(key, value);
        }

        @Override
        public void addBaggage(String key, String value) {
            this._span.setBaggageItem(key, value);
        }

        @Override
        public String getBaggage(String key) {
            return this._span.getBaggageItem(key);
        }

        @Override
        public void addThreadSwitchEvent() {
            this.addThreadSwitchEvent(Collections.emptyMap());
        }

        @Override
        public void addThreadSwitchEvent(Map<String, String> extraAttributes) {
            HashMap<String, String> fields = new HashMap<String, String>(2, 1.0f);
            fields.put("event", "thread-switch");
            fields.put("thread", Thread.currentThread().getName());
            fields.putAll(extraAttributes);
            this._span.log(fields);
        }

        @Override
        public void addErrorEvent(Exception ex) {
            assert (ex != null);
            this._span.setTag("error", true);
            GlobalTelemetry.getErrorType(ex).ifPresent(errorType -> this._span.setTag("error.type", errorType));
            Map<String, Exception> errorLogs = Collections.singletonMap("error.what", ex);
            this._span.log(errorLogs);
        }

        @Override
        public <C> void injectInto(C carrier, Tracer.TextMapSetter<C> setter) {
            OtracTracer.this._tracer.inject(this._span.context(), Format.Builtin.HTTP_HEADERS, new OtracTextMapSetter<C>(carrier, setter));
        }

        @Override
        public void runWithinSpanContext(Runnable runnable) {
            assert (runnable != null);
            try (Scope scope = OtracTracer.this._tracer.activateSpan(this._span);){
                runnable.run();
            }
        }

        @Override
        public void updateName(String name2) {
            assert (name2 != null);
            this._span.setOperationName(name2);
        }

        @Override
        public void end() {
            this._span.finish();
        }
    }

    private final class OtracSpanBuilder
    implements Tracer.SpanBuilder {
        private final Tracer.SpanBuilder _spanBuilder;

        OtracSpanBuilder(Tracer.SpanBuilder spanBuilder) {
            assert (spanBuilder != null);
            this._spanBuilder = spanBuilder;
        }

        @Override
        public Tracer.SpanBuilder setAttribute(String key, String value) {
            this._spanBuilder.withTag(key, value);
            return this;
        }

        @Override
        public Tracer.SpanBuilder setAttribute(String key, boolean value) {
            this._spanBuilder.withTag(key, value);
            return this;
        }

        @Override
        public Tracer.SpanBuilder setAttribute(String key, int value) {
            this._spanBuilder.withTag(key, (Number)value);
            return this;
        }

        @Override
        public Tracer.Span startSpan() {
            Span span = this._spanBuilder.start();
            return new OtracSpan(span);
        }
    }

    private final class OtracSpanContext
    implements Tracer.SpanContext {
        private final SpanContext _context;

        OtracSpanContext(SpanContext context) {
            this._context = context;
        }

        @Override
        public Tracer.SpanBuilder spanBuilder(String spanName) {
            Tracer.SpanBuilder spanBuilder = OtracTracer.this._tracer.buildSpan(spanName);
            if (this._context != null) {
                spanBuilder.asChildOf(this._context);
            }
            return new OtracSpanBuilder(spanBuilder);
        }
    }
}

