/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class CharSequenceReader
extends Reader {
    private CharSequence _seq = null;
    private int _seqLength = 0;
    private int _readChars = 0;

    public CharSequenceReader(CharSequence seq) {
        this._seq = seq;
        this._seqLength = seq.length();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int copiedChars;
        this.ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException("Unable to read characters from input");
        }
        if (len == 0) {
            return 0;
        }
        for (copiedChars = 0; copiedChars < len && this._readChars < this._seqLength; ++copiedChars) {
            cbuf[copiedChars + off] = this._seq.charAt(this._readChars);
            ++this._readChars;
        }
        return copiedChars == 0 ? -1 : copiedChars;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this._readChars >= this._seqLength) {
            return -1;
        }
        char next = this._seq.charAt(this._readChars);
        ++this._readChars;
        return next;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int copiedChars;
        this.ensureOpen();
        int len = target.remaining();
        if (len == 0) {
            return 0;
        }
        for (copiedChars = 0; copiedChars < len && this._readChars < this._seqLength; ++copiedChars) {
            target.put(this._seq.charAt(this._readChars));
            ++this._readChars;
        }
        return copiedChars == 0 ? -1 : copiedChars;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("Mark operation unsupported");
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return true;
    }

    @Override
    public void close() throws IOException {
        this._readChars = 0;
        this._seq = null;
        this._seqLength = 0;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n < 0L) {
            throw new IOException("Cannot skip negative number of characters.");
        }
        if (this._readChars >= this._seqLength) {
            return 0L;
        }
        this._readChars = (int)((long)this._readChars + n);
        if (this._readChars < this._seqLength) {
            return n;
        }
        return n - (long)(this._readChars - this._seqLength);
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Reset operation not supported.");
    }

    private void ensureOpen() throws IOException {
        if (this._seq == null) {
            throw new IOException("CharSequenceReader closed");
        }
    }
}

