/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsrfGuard {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsrfGuard.class);
    private static final String CSRF_NONCE_SESSION_ATTR_NAME = "DR_CSRF_NONCE";
    private static final String CSRF_NONCE_RESPONSE_PARAM = "csrf-token";
    private static final String CSRF_NONCE_REQUEST_PARAM = "x-csrf-token";
    private static final String BASE_PATH_WITH_SLASH = "/dr/";
    private static final int DENY_STATUS = 403;
    private static final Random RANDOM_SOURCE = new SecureRandom();

    public static void guardSession(HttpServletRequest request, HttpServletResponse response) {
        Validate.notNull((Object)request, (String)"request");
        Validate.notNull((Object)response, (String)"response");
        HttpSession session = request.getSession(false);
        Validate.notNull((Object)session, (String)"session");
        LOGGER.trace("CSRF guard session");
        String newNonce = CsrfGuard.generateNonce();
        CsrfGuard.setReponseNonce(newNonce, request, response);
        session.setAttribute(CSRF_NONCE_SESSION_ATTR_NAME, (Object)newNonce);
    }

    static boolean enforce(ServletRequest request, ServletResponse response) throws IOException {
        return CsrfGuard.enforce(request, response, true);
    }

    static boolean enforce(ServletRequest request, ServletResponse response, boolean failOnNoSession) throws IOException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return true;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if ("GET".equals(req.getMethod())) {
            return true;
        }
        HttpSession session = req.getSession(false);
        if (session == null) {
            LOGGER.warn("CSRF guard - no session");
            if (failOnNoSession) {
                res.sendError(403);
                return false;
            }
            return true;
        }
        String sessionNonce = (String)session.getAttribute(CSRF_NONCE_SESSION_ATTR_NAME);
        String previousNonce = req.getHeader(CSRF_NONCE_REQUEST_PARAM);
        if (sessionNonce == null || previousNonce == null || !sessionNonce.equals(previousNonce)) {
            LOGGER.warn("CSRF guard - DENY");
            res.sendError(403);
            return false;
        }
        return true;
    }

    private static void setReponseNonce(String nonce, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.trace("CSRF guard set response new nonce");
        Cookie cookie = CsrfGuard.getCookie(request, CSRF_NONCE_REQUEST_PARAM);
        if (cookie == null) {
            cookie = new Cookie(CSRF_NONCE_RESPONSE_PARAM, nonce);
            cookie.setPath(BASE_PATH_WITH_SLASH);
            cookie.setSecure(true);
        } else {
            cookie.setValue(nonce);
        }
        response.addCookie(cookie);
    }

    private static Cookie getCookie(HttpServletRequest request, String name) {
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    private static String generateNonce() {
        byte[] random = new byte[16];
        StringBuilder buffer = new StringBuilder();
        RANDOM_SOURCE.nextBytes(random);
        for (byte aRandom : random) {
            byte b1 = (byte)((aRandom & 0xF0) >> 4);
            byte b2 = (byte)(aRandom & 0xF);
            if (b1 < 10) {
                buffer.append((char)(48 + b1));
            } else {
                buffer.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                buffer.append((char)(48 + b2));
                continue;
            }
            buffer.append((char)(65 + (b2 - 10)));
        }
        return buffer.toString();
    }
}

