/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.websso;

import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import com.vmware.srm.client.infrastructure.authentication.websso.WebSsoAuthenticationStrategy;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.init.InitFilter;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.infrastructure.websso.LogoutWorkflow;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.topology.impl.init.Config;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebSsoLogoutServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configurator configurator = InitFilter.getConfigurator(request);
        WebSsoLogoutController controller = new WebSsoLogoutController(request, response, configurator);
        controller.start(Config.get().getResponseTimeout());
    }

    private static class WebSsoLogoutController
    extends BaseAsyncController {
        private final Configurator _configurator;

        WebSsoLogoutController(HttpServletRequest request, HttpServletResponse response, Configurator configurator) {
            super(request, response);
            this._configurator = configurator;
        }

        @Override
        protected BaseAsyncController.HttpProcessStage createPipeline() {
            return () -> this._configurator.getWebSsoStrategy().thenApply(WebSsoAuthenticationStrategy.class::cast).thenApply(strategy -> {
                LogoutImpl logout = new LogoutImpl(strategy.getSsoContext());
                logout.complete(this._request, this._response);
                return null;
            }).toStream().flatMap(unused -> Streams.empty());
        }
    }

    static final class LogoutImpl
    extends LogoutWorkflow {
        LogoutImpl(SsoContext context) {
            super(context, "/dr/");
        }

        @Override
        protected void onSuccess(String sessionIndex) {
            HttpSession session = SessionWrapper.removeSession(sessionIndex);
            if (session != null) {
                AuthenticationUtils.destroySession(session);
            }
        }
    }
}

