/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeException.class);
    private final Exception[] _exceptions;

    public CompositeException(Exception[] exceptions) {
        this._exceptions = exceptions;
    }

    public CompositeException(Collection<? extends Exception> exceptions) {
        this._exceptions = new Exception[exceptions.size()];
        exceptions.toArray(this._exceptions);
    }

    public Exception[] getExceptions() {
        return this._exceptions;
    }

    @Override
    public String getMessage() {
        StringBuilder strBuilder = new StringBuilder();
        String msg = super.getMessage();
        if (msg != null) {
            strBuilder.append(msg);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.append(strBuilder.toString() + NEW_LINE);
        for (Exception exception : this._exceptions) {
            if (exception == null) continue;
            if (exception.getCause() != null) {
                exception.getCause().printStackTrace(printWriter);
            }
            strBuilder.append(NEW_LINE + exception.getMessage());
        }
        LOGGER.error(stringWriter.toString());
        printWriter.close();
        return strBuilder.toString();
    }
}

