/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.jmx;

import org.apache.commons.lang.Validate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class LoggerManager {
    public static Level validate(String category, String level) {
        Validate.notEmpty((String)category, (String)"category");
        Validate.notEmpty((String)level, (String)"level");
        Level level1 = Level.toLevel((String)level, (Level)Level.DEBUG);
        Level level2 = Level.toLevel((String)level, (Level)Level.INFO);
        Validate.isTrue((level1 == level2 ? 1 : 0) != 0, (String)("Unsupported level '" + level + "'."));
        return level2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateLogger(String category, String level) {
        Level previous;
        Logger logger;
        Level newLevel = LoggerManager.validate(category, level);
        Logger logger2 = logger = LogManager.getLogger((String)category);
        synchronized (logger2) {
            previous = logger.getLevel();
            Configurator.setLevel((String)logger.getName(), (Level)newLevel);
        }
        return previous == null ? null : previous.toString();
    }
}

