/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.localization.catalogManager;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.infrastructure.http.io.HttpResponseController;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.vc.VcServersView;
import com.vmware.srm.client.topology.client.vmomi.vc.VcService;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.vmomi.vc.VcServiceImpl;
import com.vmware.vim.binding.vim.LocalizationManager;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.Future;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogUpdater.class);
    private static final String DR_KEY = "com.vmware.vcDr";
    private static final String VMSG_EXTENSION = ".vmsg";
    private static final String DEFAULT_CATALOG_MODULE = "vc";
    private static final String DEFAULT = "";
    private static final String TASK_CATALOG_NAME = "task";
    private static final String AUTH_CATALOG_NAME = "auth";
    private static final String FAULT_CATALOG_NAME = "fault";
    private static final String ENUM_CATALOG_NAME = "enum";
    private static final Set<String> CATALOGS_TO_DOWNLOAD = new HashSet<String>();
    private static final int BUFFER_SIZE = 8192;
    private final String _basePath;

    CatalogUpdater(String basePath) {
        Validate.notEmpty((String)basePath, (String)"basePath");
        this._basePath = basePath;
    }

    public Promise<Integer> update(Topology topology) {
        VcServersView view = (VcServersView)topology.getView();
        return view.getLocalVcServers().flatMap(vc -> this.downloadCatalogs((VcService)vc.service())).collect().thenApply(Collection::size);
    }

    private Stream<File> downloadCatalogs(VcService service) {
        LOGGER.debug("Start retrieving catalog info from {}", (Object)service.getServerUrl());
        return this.getMessageCatalogs(service).materialize().toStream().flatMap(pr -> {
            if (pr.isSuccessful()) {
                LOGGER.debug("Retrieved catalog info from {}", (Object)service.getServerUrl());
                return Promises.resolve((Object)((LocalizationManager.MessageCatalog[])pr.getResult()));
            }
            LOGGER.warn("Failed to retrieve catalog info from '{}'", (Object)service.getServerUrl(), (Object)pr.getError());
            return Streams.empty();
        }).map(cats -> this.filterMessageCatalogs(service.getServerUrl().getHost(), (LocalizationManager.MessageCatalog[])cats)).flatMap(cats -> this.downloadCatalogs(service, (List<LocalizationManager.MessageCatalog>)cats));
    }

    private Promise<LocalizationManager.MessageCatalog[]> getMessageCatalogs(VcService service) {
        return service.getContent().thenCompose(content -> {
            LocalizationManager lm = (LocalizationManager)service.createStub(content.getLocalizationManager());
            FuturePromise result = new FuturePromise();
            lm.getCatalog((Future)result);
            return result;
        });
    }

    private List<LocalizationManager.MessageCatalog> filterMessageCatalogs(String vcHost, LocalizationManager.MessageCatalog[] cats) {
        if (ArrayUtils.isEmpty((Object[])cats)) {
            return Collections.emptyList();
        }
        List filtered = Arrays.stream(cats).filter(cat -> Config.get().getHmsExtensionKey().equals(cat.moduleName) || DEFAULT.equals(cat.moduleName) || cat.moduleName.startsWith(DR_KEY)).filter(cat -> CATALOGS_TO_DOWNLOAD.contains(cat.catalogName)).filter(cat -> !this.getDestinationFile(vcHost, (LocalizationManager.MessageCatalog)cat).exists()).collect(Collectors.toList());
        Map<File, List<LocalizationManager.MessageCatalog>> catByFile = filtered.stream().collect(Collectors.groupingBy(cat -> this.getDestinationFile(vcHost, (LocalizationManager.MessageCatalog)cat)));
        ArrayList<LocalizationManager.MessageCatalog> result = new ArrayList<LocalizationManager.MessageCatalog>(catByFile.size());
        for (Map.Entry<File, List<LocalizationManager.MessageCatalog>> entry : catByFile.entrySet()) {
            LocalizationManager.MessageCatalog mc = entry.getValue().get(0);
            if (entry.getValue().size() > 1) {
                LOGGER.debug("Catalogs '{}' map to '{}'. Will use '{}'.", new Object[]{entry.getValue(), entry.getKey(), mc});
            }
            result.add(mc);
        }
        return result;
    }

    private Stream<File> downloadCatalogs(VcService service, List<LocalizationManager.MessageCatalog> cats) {
        LOGGER.debug("Found following new catalogs: {}.", cats);
        return Streams.from(cats).flatMap(cat -> this.downloadCatalog(service, (LocalizationManager.MessageCatalog)cat).materialize().toStream().flatMap(pr -> {
            if (pr.isSuccessful()) {
                LOGGER.debug("Downloaded catalog {}", cat);
                return Streams.just((Object[])new File[]{(File)pr.getResult()});
            }
            LOGGER.warn("Failed to download '{}'", cat, (Object)pr.getError());
            return Streams.empty();
        }));
    }

    private Promise<File> downloadCatalog(VcService service, LocalizationManager.MessageCatalog catalog) {
        LOGGER.debug("Downloading catalog {}", (Object)catalog);
        return Promises.resolve((Object)catalog).thenApply(cat -> this.getData(service, (LocalizationManager.MessageCatalog)cat)).thenCompose(this::download);
    }

    private Promise<File> download(CatalogData data) {
        return HttpResponseController.doGet(data.url, data.store, data.verifier).thenApply(response -> {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new RuntimeException("No http entity in response from '" + data.url + "'");
            }
            try (InputStream is = entity.getContent();){
                this.writeFile(is, data.file);
            }
            catch (IOException | UnsupportedOperationException e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
            return data.file;
        });
    }

    private File getDestinationFile(String vcHost, LocalizationManager.MessageCatalog catalog) {
        String catalogModule = StringUtils.isEmpty((String)catalog.moduleName) ? DEFAULT_CATALOG_MODULE : catalog.moduleName;
        catalogModule = catalogModule.startsWith(DR_KEY) ? DR_KEY : catalogModule;
        String builder = this._basePath + File.separator + vcHost + File.separator + catalogModule + File.separator + catalog.locale + File.separator + catalog.catalogName + this.getCatalogCheckSumSuffix(catalog) + VMSG_EXTENSION;
        return new File(builder);
    }

    private String getCatalogCheckSumSuffix(LocalizationManager.MessageCatalog catalog) {
        Validate.notNull((Object)catalog, (String)"catalog");
        Object suffix = catalog.getMd5sum();
        suffix = StringUtils.isEmpty((String)suffix) ? DEFAULT : "_" + (String)suffix;
        return suffix;
    }

    private KeyStore getKeyStore(VcService service) {
        return ((VcServiceImpl)service).getTrustStore();
    }

    private ThumbprintVerifier getVerifier(VcService service) {
        return ((VcServiceImpl)service).getVerifier();
    }

    private CatalogData getData(VcService service, LocalizationManager.MessageCatalog cat) {
        URI url = service.getServerUrl().resolve(cat.catalogUri);
        KeyStore store = this.getKeyStore(service);
        ThumbprintVerifier verifier = this.getVerifier(service);
        File file = this.getDestinationFile(service.getServerUrl().getHost(), cat);
        return new CatalogData(url, store, verifier, file);
    }

    private void writeFile(InputStream is, File file) throws IOException {
        if (!file.getParentFile().mkdirs()) {
            LOGGER.warn("Unable to create parent directories for '{}'", (Object)file);
        }
        try (OutputStream os = Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
    }

    static {
        CATALOGS_TO_DOWNLOAD.add(TASK_CATALOG_NAME);
        CATALOGS_TO_DOWNLOAD.add(AUTH_CATALOG_NAME);
        CATALOGS_TO_DOWNLOAD.add(FAULT_CATALOG_NAME);
        CATALOGS_TO_DOWNLOAD.add(ENUM_CATALOG_NAME);
    }

    private static final class CatalogData {
        final URI url;
        final KeyStore store;
        final ThumbprintVerifier verifier;
        final File file;

        CatalogData(URI url, KeyStore store, ThumbprintVerifier verifier, File file) {
            this.url = url;
            this.store = store;
            this.verifier = verifier;
            this.file = file;
        }
    }
}

