/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks.create.impl;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.StreamImpl;
import com.vmware.srm.client.infrastructure.tasks.TaskUtil;
import com.vmware.srm.client.infrastructure.tasks.create.TaskHandle;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskHandleImpl<T>
extends PromiseImpl<T>
implements TaskHandle<T> {
    private final ManagedObjectReference _moRef;
    private final AtomicInteger _progress = new AtomicInteger(0);
    private final Calendar _startTime = Calendar.getInstance();
    private volatile String _key;
    private volatile TaskInfo _result;
    private static final Promise<Void> FIRST_EVENT = Promises.resolve(null);
    private final StreamImpl<Void> _progressChanged = new StreamImpl();

    public TaskHandleImpl(ManagedObjectReference moRef) {
        this._moRef = moRef;
    }

    @Override
    public ManagedObjectReference getRef() {
        return this._moRef;
    }

    @Override
    public TaskInfo getTaskInfo() {
        TaskInfo result = this._result;
        if (result == null && this.isComplete()) {
            do {
                Thread.yield();
            } while ((result = this._result) == null);
        }
        if (result != null) {
            return result;
        }
        result = TaskUtil.createInitialTaskInfo(this._moRef);
        result.setStartTime(this._startTime);
        result.setProgress(Integer.valueOf(this._progress.get()));
        result.setKey(this._key);
        return result;
    }

    @Override
    public void setKey(String key) {
        this._key = key;
    }

    @Override
    public boolean setProgress(Integer progress) {
        int current;
        progress = progress == null ? 0 : progress;
        while ((current = this._progress.get()) < progress) {
            if (!this._progress.compareAndSet(current, progress)) continue;
            this._progressChanged.publishNext(null);
            return true;
        }
        return current == progress;
    }

    @Override
    public boolean complete(T result) {
        return this.setResult(result);
    }

    @Override
    public boolean fail(Exception exc) {
        return this.setError(exc);
    }

    @Override
    public void cancel() {
        this.setError(new TaskHandle.TaskCancelledException(this));
    }

    @Override
    public boolean isCancelled() {
        return this.getTaskInfo().isCancelled();
    }

    @Override
    public Stream<Void> getProgressChanged() {
        return this._progressChanged.merge(new Publisher[]{FIRST_EVENT, this.materialize().thenApply(ignored -> null)});
    }

    public boolean setResult(T value) {
        this.setProgress(100);
        TaskInfo ti = new TaskInfo();
        ti.descriptionId = "";
        ti.task = this._moRef;
        ti.progress = 100;
        ti.state = TaskInfo.State.success;
        ti.startTime = this._startTime;
        ti.completeTime = Calendar.getInstance();
        ti.result = value;
        ti.key = this._key;
        if (super.setResult(value)) {
            this._result = ti;
            this._progressChanged.publishComplete();
            return true;
        }
        return false;
    }

    public boolean setError(Exception err) {
        this.setProgress(100);
        TaskInfo ti = new TaskInfo();
        ti.descriptionId = "";
        ti.task = this._moRef;
        ti.progress = 100;
        ti.state = TaskInfo.State.error;
        ti.startTime = this._startTime;
        ti.completeTime = Calendar.getInstance();
        ti.error = err;
        ti.cancelled = err instanceof TaskHandle.TaskCancelledException;
        ti.key = this._key;
        if (super.setError(err)) {
            this._result = ti;
            this._progressChanged.publishComplete();
            return true;
        }
        return false;
    }
}

