/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdBuilder.class);
    private final String _localGuid;
    private final String _remoteGuid;

    IdBuilder(String localGuid, String remoteGuid) {
        this._localGuid = localGuid;
        this._remoteGuid = remoteGuid;
    }

    public String buildRootFolderId(String guid) {
        return this.getPrefix(guid) + "folder_group-d1";
    }

    public String buildId(ManagedObjectReference moRef) {
        String type;
        switch (moRef.getType()) {
            case "ComputeResource": 
            case "ClusterComputeResource": {
                type = "computeResource_";
                break;
            }
            case "Datacenter": {
                type = "dc_";
                break;
            }
            case "HostSystem": {
                type = "host_";
                break;
            }
            case "Folder": 
            case "vmFolder": 
            case "hostFolder": {
                type = "folder_";
                break;
            }
            case "Network": 
            case "network": 
            case "DistributedVirtualPortgroup": 
            case "OpaqueNetwork": {
                type = "network_";
                break;
            }
            case "Datastore": 
            case "datastore": {
                type = "datastore_";
                break;
            }
            case "VirtualMachine": {
                type = "vm_";
                break;
            }
            case "ResourcePool": 
            case "VirtualApp": {
                type = "resource_";
                break;
            }
            case "DrReplicationVmProtectionGroup": {
                type = "pg_";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unmatched moref type: %s.", moRef));
            }
        }
        if (type.equals("pg_")) {
            return type + moRef.getValue();
        }
        try {
            return this.getPrefix(moRef.getServerGuid()) + type + moRef.getValue();
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Unable to build ID for moRef: '{}', reason: '{}'.", (Object)moRef, (Object)e.getMessage());
            switch (type) {
                case "computeResource_": 
                case "host_": 
                case "folder_": 
                case "network_": 
                case "datastore_": 
                case "resource_": {
                    return null;
                }
            }
            throw e;
        }
    }

    private String getPrefix(String guid) {
        if (guid.equals(this._localGuid)) {
            return "l_";
        }
        if (guid.equals(this._remoteGuid)) {
            return "r_";
        }
        throw new IllegalArgumentException(String.format("Guid '%s' not from the pair.", guid));
    }
}

