/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.ClientFuture;
import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.common.impl.ResponseImpl;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.ApacheClientRequestConfigurationMerger;
import com.vmware.vim.vmomi.client.http.impl.HttpAsyncProtocolBindingImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpExchangeBase;
import com.vmware.vim.vmomi.client.http.impl.InetAddressSniffingResponseConsumer;
import com.vmware.vim.vmomi.client.http.impl.TracingScopedRunnable;
import com.vmware.vim.vmomi.core.SyncFuture;
import com.vmware.vim.vmomi.core.tracing.Tracer;
import java.net.URI;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class HttpAsyncExchange
extends HttpExchangeBase {
    private static final Log LOG = LogFactory.getLog(HttpAsyncExchange.class);
    private final HttpAsyncClient _client;
    private final HttpAsyncProtocolBindingImpl _binding;
    private final boolean _sync;
    private HttpClientContext httpContext;

    public HttpAsyncExchange(Request request, Response response, CompiledHttpConfiguration compiledHttpConfig, HttpAsyncClient client, ApacheClientRequestConfigurationMerger configMerger, URI endpoint, boolean enableCompression, InvocationInterceptor invocationInterceptor, HttpAsyncProtocolBindingImpl binding, boolean sync, Tracer tracer) {
        super(request, response, compiledHttpConfig, configMerger, endpoint, enableCompression, invocationInterceptor, "NIO", sync, tracer);
        this._client = client;
        this._binding = binding;
        this._sync = sync;
    }

    @Override
    protected void invokeWithinScope() {
        HttpUriRequest request;
        this.beginInvocation();
        try {
            request = this.prepareRequest();
            this.httpContext = this.prepareContext();
        }
        catch (Exception e) {
            this.setResponseError(e);
            return;
        }
        InetAddressSniffingResponseConsumer responseConsumer = new InetAddressSniffingResponseConsumer((HttpAsyncResponseConsumer<HttpResponse>)HttpAsyncMethods.createConsumer(), this);
        this._client.execute(HttpAsyncMethods.create((HttpUriRequest)request), (HttpAsyncResponseConsumer)responseConsumer, (HttpContext)this.httpContext, this.createCallback());
    }

    private HttpClientContext prepareContext() {
        HttpClientContext result = this.prepareLocalContext();
        result.setCookieStore(this._binding.getCookieStore());
        return result;
    }

    private void execute(Runnable runnable) {
        ClientFuture<Object> future;
        Response response;
        if (this._sync && (response = this.getResponse()) instanceof ResponseImpl && (future = ((ResponseImpl)response).getFuture()) instanceof SyncFuture) {
            ((SyncFuture)future).executeInBlockedThread(runnable);
            return;
        }
        if (LOG.isDebugEnabled()) {
            this.getTracingSpan().addThreadSwitchEvent();
        }
        this._binding.executeRunnable(runnable, false);
    }

    private FutureCallback<HttpResponse> createCallback() {
        return new FutureCallback<HttpResponse>(){

            public void failed(final Exception e) {
                try {
                    HttpAsyncExchange.this.execute(new TracingScopedRunnable(){

                        @Override
                        protected void invokeWithinScope() {
                            if (LOG.isDebugEnabled()) {
                                this.getTracingSpan().addThreadSwitchEvent();
                            }
                            HttpAsyncExchange.this.setResponseError(e);
                            HttpAsyncExchange.this.completeInvocation(false);
                        }

                        @Override
                        protected Tracer.Span getTracingSpan() {
                            return HttpAsyncExchange.this.getTracingSpan();
                        }
                    });
                }
                catch (RejectedExecutionException ree) {
                    try {
                        if (LOG.isWarnEnabled()) {
                            String message = String.format("Execution rejected upon failing request %h to %s", HttpAsyncExchange.this.getRequest(), HttpAsyncExchange.this.getEndPoint());
                            LOG.warn((Object)message, (Throwable)ree);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setError(e);
                }
            }

            public void completed(final HttpResponse response) {
                try {
                    HttpAsyncExchange.this.execute(new TracingScopedRunnable(){

                        @Override
                        public void invokeWithinScope() {
                            boolean success = true;
                            try {
                                if (LOG.isDebugEnabled()) {
                                    this.getTracingSpan().addThreadSwitchEvent();
                                }
                                HttpAsyncExchange.this.extractUserToken(HttpAsyncExchange.this.httpContext);
                                HttpAsyncExchange.this.parseResponse(response);
                            }
                            catch (Exception e) {
                                success = false;
                                HttpAsyncExchange.this.setResponseError(e);
                            }
                            finally {
                                HttpAsyncExchange.this.completeInvocation(success);
                            }
                        }

                        @Override
                        protected Tracer.Span getTracingSpan() {
                            return HttpAsyncExchange.this.getTracingSpan();
                        }
                    });
                }
                catch (RejectedExecutionException ree) {
                    this.setError(ree);
                }
            }

            public void cancelled() {
                this.failed(new TransportProtocolException("Http exchange canceled."));
            }

            private void setError(Exception e) {
                try {
                    HttpAsyncExchange.this.setResponseError(e);
                    HttpAsyncExchange.this.finishTrace();
                }
                catch (Exception setErrorException) {
                    try {
                        if (LOG.isErrorEnabled()) {
                            String message = String.format("Unable to notify consumer of error on request %h", HttpAsyncExchange.this.getRequest());
                            LOG.error((Object)message, (Throwable)setErrorException);
                            message = String.format("Request %h to %s failed with the following error", HttpAsyncExchange.this.getRequest(), HttpAsyncExchange.this.getEndPoint());
                            LOG.error((Object)message, (Throwable)e);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

