/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public class KeyManagerWrapper
extends X509ExtendedKeyManager {
    private X509KeyManager _baseKM = null;
    private String _alias = null;

    public KeyManagerWrapper(X509KeyManager baseKM, String alias) {
        this._baseKM = baseKM;
        this._alias = alias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (null == this._alias) {
            return this._baseKM.chooseClientAlias(keyType, issuers, socket);
        }
        return this.findMatchingAlias(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this._baseKM.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this._baseKM.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this._baseKM.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this._baseKM.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this._baseKM.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine sslEngine) {
        if (null == this._alias) {
            return super.chooseEngineClientAlias(keyType, issuers, sslEngine);
        }
        String alias = this.findMatchingAlias(keyType, issuers);
        if (alias == null) {
            return super.chooseEngineClientAlias(keyType, issuers, sslEngine);
        }
        return alias;
    }

    private String findMatchingAlias(String[] keyType, Principal[] issuers) {
        for (int i = 0; i < keyType.length; ++i) {
            String[] validAliases = this._baseKM.getClientAliases(keyType[i], issuers);
            if (validAliases == null) continue;
            for (int j = 0; j < validAliases.length; ++j) {
                if (!this.aliasMatches(validAliases[j])) continue;
                return validAliases[j];
            }
        }
        return null;
    }

    private boolean aliasMatches(String alias) {
        return alias.equals(this._alias) || alias.contains("." + this._alias + ".");
    }
}

