/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.version.impl;

import com.vmware.vim.binding.impl.vmodl.infra.VmodlNs_Impl;
import com.vmware.vim.binding.vmodl.fault.InvalidRequest;
import com.vmware.vim.binding.vmodl.infra.VmodlNs;
import com.vmware.vim.binding.vmodl.infra.version.internal.version1;
import com.vmware.vim.binding.vmodl.versionKind;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.impl.ClientFactory;
import com.vmware.vim.vmomi.client.version.VersionProvider;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.soap.NotSupportedVersionException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmodlNsVersionProvider
implements VersionProvider {
    private static final Log LOG = LogFactory.getLog(VmodlNsVersionProvider.class);
    private final ClientConfiguration config;
    private final String namespace;
    private final boolean internal;

    private VmodlNsVersionProvider(ClientConfiguration config, String namespace, boolean internal2) {
        this.config = config;
        this.namespace = namespace;
        this.internal = internal2;
    }

    @Override
    public CompletionStage<VmodlVersion> getVersionAsync(VersionProvider.GetVersionSpec spec) {
        NegotiateSpec negotiateSpec = new NegotiateSpec(spec);
        Executor executor = this.config.getExecutor();
        if (executor == null) {
            executor = VmodlNsVersionProvider.selfDestroyingExecutor(String.format("vlsi-version-negotiate-%s", this.namespace));
        }
        CompletableFuture<VmodlVersion> future = new CompletableFuture<VmodlVersion>();
        future.whenCompleteAsync((r, t) -> negotiateSpec.infraClient.shutdown());
        CompletableFuture.runAsync(() -> this.negotiate(negotiateSpec, future), executor).whenComplete((r, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            }
        });
        return future;
    }

    private static Executor selfDestroyingExecutor(String threadName) {
        return new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread t = new Thread(r);
            t.setName(threadName);
            return t;
        });
    }

    private void negotiate(NegotiateSpec spec, CompletableFuture<VmodlVersion> future) {
        VmodlNs stub = spec.infraClient.createStub(VmodlNs.class, "infra-vmodl-ns");
        VmodlNs_Impl.ApiCapabilitiesImpl apiCapabilities = new VmodlNs_Impl.ApiCapabilitiesImpl();
        apiCapabilities.setVmodlNamespace(this.namespace);
        apiCapabilities.setInternal(this.internal);
        apiCapabilities.setReleaseIDs(spec.getReleaseIDs());
        apiCapabilities.setMilestoneIDs(spec.getMilestoneIDs());
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("Negotiating versions with %s using: '%s'", spec.endpoint, apiCapabilities));
        }
        stub.selectCapabilities(apiCapabilities, new FutureCommonCapabilitiesAdapter(future, spec));
    }

    private static Optional<VmodlVersion> findVersion(List<VmodlVersion> localVersions, String serverChosenVersion) {
        return localVersions.stream().filter(v -> serverChosenVersion.equals(v.getVersionId())).findFirst();
    }

    private static String[] extractIDs(List<VmodlVersion> versions2) {
        if (versions2 == null) {
            return null;
        }
        return (String[])versions2.stream().map(v -> v.getVersionId()).toArray(String[]::new);
    }

    public static class Builder {
        private final String namespace;
        private ClientConfiguration clientConfig;
        private boolean internal;

        public Builder(String namespace) {
            this.namespace = Objects.requireNonNull(namespace);
        }

        public Builder setClientConfiguration(ClientConfiguration config) {
            this.clientConfig = config;
            return this;
        }

        public Builder setInternal(boolean internal2) {
            this.internal = internal2;
            return this;
        }

        public VmodlNsVersionProvider build() {
            ClientConfiguration config = this.clientConfig;
            if (config == null) {
                config = HttpClientConfiguration.Factory.newInstance();
            }
            return new VmodlNsVersionProvider(config, this.namespace, this.internal);
        }
    }

    public static class VmodlNsFault
    extends RuntimeException {
        public VmodlNsFault(String message) {
            super(message);
        }
    }

    class FutureCommonCapabilitiesAdapter
    implements Future<VmodlNs.CommonCapabilities> {
        private final CompletableFuture<VmodlVersion> future;
        private final NegotiateSpec spec;

        FutureCommonCapabilitiesAdapter(CompletableFuture<VmodlVersion> future, NegotiateSpec spec) {
            this.future = future;
            this.spec = spec;
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        public VmodlNs.CommonCapabilities get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new IllegalStateException();
        }

        public VmodlNs.CommonCapabilities get() throws InterruptedException, ExecutionException {
            throw new IllegalStateException();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        public void setException(Exception e) {
            if (e instanceof NotSupportedVersionException || e instanceof InvalidRequest) {
                e = new VersionProvider.UnsupportedNegotiationMechanismException(e);
            }
            this.future.completeExceptionally(e);
        }

        public void set() {
            throw new IllegalStateException();
        }

        public void set(VmodlNs.CommonCapabilities ret) {
            VmodlVersion version;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("%s responded with %s for namespace '%s'", this.spec.endpoint, ret, VmodlNsVersionProvider.this.namespace));
            }
            try {
                version = this.extractVersion(ret);
            }
            catch (VmodlNsFault e) {
                this.setException(e);
                return;
            }
            this.future.complete(version);
        }

        private VmodlVersion extractVersion(VmodlNs.CommonCapabilities capabilities) {
            List<VmodlVersion> localVersions;
            String serverChosenVersion = capabilities.getMilestoneId();
            if (serverChosenVersion != null) {
                localVersions = this.spec.milestoneVersions;
            } else {
                serverChosenVersion = capabilities.getReleaseId();
                if (serverChosenVersion == null) {
                    throw new VmodlNsFault(String.format("No milestoneId, nor releaseId returned by %s for namespace '%s'", this.spec.endpoint, VmodlNsVersionProvider.this.namespace));
                }
                localVersions = this.spec.ltsVersions;
            }
            Optional match = VmodlNsVersionProvider.findVersion(localVersions, serverChosenVersion);
            if (!match.isPresent()) {
                throw new VmodlNsFault(String.format("Version '%s' determined by %s for namespace '%s' is not found on the client", serverChosenVersion, this.spec.endpoint, VmodlNsVersionProvider.this.namespace));
            }
            return (VmodlVersion)match.get();
        }
    }

    class NegotiateSpec {
        final URI endpoint;
        final Client infraClient;
        final List<VmodlVersion> ltsVersions;
        final List<VmodlVersion> milestoneVersions;

        NegotiateSpec(VersionProvider.GetVersionSpec spec) {
            this.endpoint = VmodlNsVersionProvider.this.config.getServerEndpointProvider() == null ? spec.getProtocolBinding().getEndpointUri() : null;
            VmodlContext context = spec.getContext();
            VmodlVersionMap allVersions = context.getVmodlVersionMap();
            Map namespaceVersions = allVersions.getVersionsByNamespace(VmodlNsVersionProvider.this.namespace);
            if (namespaceVersions == null) {
                throw new IllegalStateException(String.format("No versions present in context for namespace '%s'", VmodlNsVersionProvider.this.namespace));
            }
            this.ltsVersions = (List)namespaceVersions.get(versionKind.Value.LTS);
            this.milestoneVersions = (List)namespaceVersions.get(versionKind.Value.MILESTONE);
            if ((this.ltsVersions == null || this.ltsVersions.isEmpty()) && (this.milestoneVersions == null || this.milestoneVersions.isEmpty())) {
                throw new IllegalStateException(String.format("No milestone, nor LTS versions present for namespace '%s'. Feature versions are not supported.", VmodlNsVersionProvider.this.namespace));
            }
            VmodlContext infraContext = VmodlContext.createContext((String[])new String[]{"com.vmware.vim.binding.infra"});
            this.infraClient = ClientFactory.createClient(this.endpoint, version1.class, VmodlNsVersionProvider.this.config, infraContext);
        }

        String[] getReleaseIDs() {
            return VmodlNsVersionProvider.extractIDs(this.ltsVersions);
        }

        String[] getMilestoneIDs() {
            return VmodlNsVersionProvider.extractIDs(this.milestoneVersions);
        }
    }
}

